/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.auth.DseGSSAPIAuthProvider;
import com.datastax.driver.dse.auth.DsePlainTextAuthProvider;
import com.datastax.driver.dse.auth.EmbeddedADS;
import com.datastax.driver.dse.auth.KerberosUtils;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import java.io.File;
import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@DseVersion(value="5.1.0")
public class GraphProxyAuthenticationTest
extends CCMGraphTestsSupport {
    private static final String realm = "DATASTAX.COM";
    private static final String address = TestUtils.IP_PREFIX + "1";
    private final EmbeddedADS adsServer = EmbeddedADS.builder().withKerberos().withRealm("DATASTAX.COM").withAddress(address).build();
    private final String dsePrincipal = "dse/" + this.adsServer.getHostname() + "@" + "DATASTAX.COM";
    private final String bobPrincipal = "bob@DATASTAX.COM";
    private final String charliePrincipal = "charlie@DATASTAX.COM";
    private File dseKeytab;
    private File bobKeytab;
    private File charlieKeytab;

    @Override
    protected void initTestContext(Object testInstance, Method testMethod) throws Exception {
        this.setupKDC();
        super.initTestContext(testInstance, testMethod);
    }

    void setupKDC() throws Exception {
        if (this.adsServer.isStarted()) {
            return;
        }
        this.adsServer.start();
        this.dseKeytab = this.adsServer.addUserAndCreateKeytab("dse", "dse", this.dsePrincipal);
        this.bobKeytab = this.adsServer.addUserAndCreateKeytab("bob", "bob", "bob@DATASTAX.COM");
        this.charlieKeytab = this.adsServer.addUserAndCreateKeytab("charlie", "charlie", "charlie@DATASTAX.COM");
    }

    @AfterClass(groups={"long"}, alwaysRun=true)
    public void teardownKDC() throws Exception {
        this.adsServer.stop();
    }

    @Override
    public void onTestContextInitialized() {
        super.onTestContextInitialized();
        this.executeGraph(GraphFixtures.modern);
        this.execute("CREATE ROLE IF NOT EXISTS guser WITH PASSWORD = 'guser' AND LOGIN = FALSE", "CREATE ROLE IF NOT EXISTS ben WITH PASSWORD = 'ben' AND LOGIN = TRUE", "CREATE ROLE IF NOT EXISTS 'bob@DATASTAX.COM' WITH LOGIN = TRUE", "CREATE ROLE IF NOT EXISTS 'charlie@DATASTAX.COM' WITH PASSWORD = 'charlie' AND LOGIN = TRUE", "CREATE ROLE IF NOT EXISTS steve WITH PASSWORD = 'steve' AND LOGIN = TRUE", String.format("GRANT ALL ON KEYSPACE %s TO guser", this.graphName()), String.format("GRANT ALL ON KEYSPACE %s_system TO guser", this.graphName()), "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'ben'", "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'bob@DATASTAX.COM'", "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'steve'", "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'charlie@DATASTAX.COM'", "GRANT PROXY.LOGIN ON ROLE 'guser' TO 'ben'", "GRANT PROXY.LOGIN ON ROLE 'guser' TO 'bob@DATASTAX.COM'", "GRANT PROXY.EXECUTE ON ROLE 'guser' TO 'steve'", "GRANT PROXY.EXECUTE ON ROLE 'guser' TO 'charlie@DATASTAX.COM'");
        if (this.ccm().getDSEVersion().compareTo(VersionNumber.parse((String)"6.0")) < 0) {
            this.execute(String.format("GRANT ALL ON KEYSPACE %s_pvt TO guser", this.graphName()));
        }
    }

    @Override
    public CCMBridge.Builder configureCCM() {
        String authenticationOptions = "authentication_options:\n  enabled: true\n  default_scheme: kerberos\n  other_schemes:\n    - internal";
        return super.configureCCM().withCassandraConfiguration("authorizer", "com.datastax.bdp.cassandra.auth.DseAuthorizer").withCassandraConfiguration("authenticator", "com.datastax.bdp.cassandra.auth.DseAuthenticator").withDSEConfiguration(authenticationOptions).withDSEConfiguration("authorization_options.enabled", true).withDSEConfiguration("kerberos_options.keytab", this.dseKeytab.getAbsolutePath()).withDSEConfiguration("kerberos_options.service_principal", "dse/_HOST@DATASTAX.COM").withDSEConfiguration("kerberos_options.qop", "auth").withJvmArgs("-Dcassandra.superuser_setup_delay_ms=0", "-Djava.security.krb5.conf=" + this.adsServer.getKrb5Conf().getAbsolutePath());
    }

    @Override
    public DseCluster.Builder createClusterBuilder() {
        return super.createClusterBuilder().withAuthProvider((AuthProvider)new DsePlainTextAuthProvider("cassandra", "cassandra"));
    }

    @Test(groups={"long"})
    public void should_make_traversal_using_plain_text_with_proxy_authentication() {
        this.query((AuthProvider)new DsePlainTextAuthProvider("ben", "ben", "guser"));
    }

    @Test(groups={"long"})
    public void should_make_traversal_using_plain_text_with_proxy_execution() {
        this.queryWithExecuteAs((AuthProvider)new DsePlainTextAuthProvider("steve", "steve"));
    }

    @Test(groups={"long"})
    public void should_make_traversal_using_kerberos_with_proxy_authentication() {
        this.query((AuthProvider)DseGSSAPIAuthProvider.builder().withLoginConfiguration(KerberosUtils.keytabClient(this.bobKeytab, "bob@DATASTAX.COM")).withAuthorizationId("guser").build());
    }

    @Test(groups={"long"})
    public void should_make_traversal_using_kerberos_with_proxy_execution() {
        this.queryWithExecuteAs((AuthProvider)DseGSSAPIAuthProvider.builder().withLoginConfiguration(KerberosUtils.keytabClient(this.charlieKeytab, "charlie@DATASTAX.COM")).build());
    }

    private void query(AuthProvider authProvider) {
        this.query(authProvider, false);
    }

    private void queryWithExecuteAs(AuthProvider authProvider) {
        this.query(authProvider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void query(AuthProvider authProvider, boolean executeAs) {
        DseCluster cluster = super.createClusterBuilder().addContactPointsWithPorts(this.getContactPointsWithPorts()).withGraphOptions(new GraphOptions().setGraphName(this.graphName())).withAuthProvider(authProvider).build();
        try {
            DseSession session = cluster.connect();
            SimpleGraphStatement statement = new SimpleGraphStatement("g.V().count()");
            if (executeAs) {
                statement = statement.executingAs("guser");
            }
            int count = session.executeGraph((GraphStatement)statement).one().asInt();
            Assertions.assertThat((int)count).isEqualTo(6);
        }
        finally {
            cluster.close();
        }
    }
}

