/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphFixtures;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
public class GraphAuthenticationTest
extends CCMGraphTestsSupport {
    @Override
    public void onTestContextInitialized() {
        super.onTestContextInitialized();
        this.executeGraph(GraphFixtures.modern);
    }

    @Override
    public CCMBridge.Builder configureCCM() {
        return super.configureCCM().withCassandraConfiguration("authenticator", "PasswordAuthenticator").withJvmArgs("-Dcassandra.superuser_setup_delay_ms=0");
    }

    @Test(groups={"short"})
    public void should_be_able_to_make_graph_query() {
        int count = this.session().executeGraph("g.V().count()").one().asInt();
        Assertions.assertThat((int)count).isEqualTo(6);
    }

    @Override
    public DseCluster.Builder createClusterBuilder() {
        return super.createClusterBuilder().withCredentials("cassandra", "cassandra");
    }
}

