/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultPath;
import com.datastax.driver.dse.graph.EdgeAssert;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.PathAssert;
import com.datastax.driver.dse.graph.VertexAssert;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.testng.annotations.Test;

public class DefaultPathDeserializerTest {
    @Test(groups={"unit"})
    public void should_deserialize_as_path_graphson_1_0() throws Exception {
        Path path = (Path)GraphJsonUtils.readStringAsTree((String)Resources.toString((URL)this.getClass().getResource("/graphson-1.0/path1.json"), (Charset)Charsets.UTF_8)).as(Path.class);
        this.assertPath(path);
    }

    @Test(groups={"unit"})
    public void should_deserialize_as_path_graphson_2_0() throws Exception {
        Path path = (Path)GraphJsonUtils.readStringAsTreeGraphson20((String)Resources.toString((URL)this.getClass().getResource("/graphson-2.0/path1.json"), (Charset)Charsets.UTF_8)).as(Path.class);
        this.assertPath(path);
    }

    void assertPath(Path path) throws IOException {
        PathAssert pathAssert = ((PathAssert)GraphAssertions.assertThat(path).isInstanceOf(DefaultPath.class)).hasLabel("a").hasLabel("b").hasLabel("c").hasLabel("d").hasLabel("e").hasLabel("f").hasLabel("g").hasLabel(4, "a").hasLabel(0, "a").hasLabel(1, "b").hasLabel(2, "c", "d").hasLabel(3, "e", "f", "g").hasLabel(4, "a").doesNotHaveLabel("h");
        GraphAssertions.assertThat((List)path.getObjects()).hasSize(5);
        GraphAssertions.assertThat((int)path.size()).isEqualTo(5);
        ((VertexAssert)((Object)pathAssert.object(0).asVertex().hasLabel("person"))).hasProperty("name", "marko").hasProperty("age", 29);
        ((EdgeAssert)((Object)pathAssert.object(1).asEdge().hasLabel("knows"))).hasInVLabel("person").hasOutVLabel("person").hasProperty("weight", Float.valueOf(1.0f));
        ((VertexAssert)((Object)pathAssert.object(2).asVertex().hasLabel("person"))).hasProperty("name", "josh").hasProperty("age", 32);
        ((EdgeAssert)((Object)pathAssert.object(3).asEdge().hasLabel("created"))).hasInVLabel("software").hasOutVLabel("person").hasProperty("weight", Float.valueOf(1.0f));
        ((VertexAssert)((Object)pathAssert.object(4).asVertex().hasLabel("software"))).hasProperty("name", "ripple").hasProperty("lang", "java");
        ((VertexAssert)((Object)pathAssert.object("a").asVertex().hasLabel("person"))).hasProperty("name", "marko").hasProperty("age", 29);
        pathAssert.objects("a").hasSize(2);
        ((VertexAssert)((Object)GraphAssertions.assertThat(((GraphNode)path.getObjects("a").get(0)).asVertex()).hasLabel("person"))).hasProperty("name", "marko").hasProperty("age", 29);
        ((VertexAssert)((Object)GraphAssertions.assertThat(((GraphNode)path.getObjects("a").get(1)).asVertex()).hasLabel("software"))).hasProperty("name", "ripple").hasProperty("lang", "java");
        GraphAssertions.assertThat(path.getObject("nonexistent")).isNull();
        GraphAssertions.assertThat(path.getObject(5)).isNull();
    }
}

