/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphExtractors;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.datastax.driver.dse.graph.Vertex;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
public class AsyncQueryTest
extends CCMGraphTestsSupport {
    @Override
    public void onTestContextInitialized() {
        super.onTestContextInitialized();
        this.executeGraph("schema.config().option('graph.schema_mode').set('production')", "schema.config().option('graph.allow_scan').set('true')", "schema.propertyKey('name').Text().create()", "schema.propertyKey('uuid').Uuid().create()", "schema.propertyKey('number').Double().create()", "schema.vertexLabel('person').properties('name', 'uuid', 'number').create()");
    }

    @Test(groups={"short"})
    public void should_handle_multiple_vertex_creation_queries_simultaneously() throws Exception {
        int concurrency = 20;
        int requests = 100;
        final Semaphore permits = new Semaphore(concurrency);
        Random random = new Random();
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)requests);
        for (int i = 0; i < requests; ++i) {
            if (!permits.tryAcquire(30L, TimeUnit.SECONDS)) {
                throw new Exception("Could not acquire permit to send query within 30 seconds");
            }
            final String name = "User " + i;
            final UUID uuid = UUID.randomUUID();
            final Double number = random.nextDouble();
            SimpleGraphStatement addV = new SimpleGraphStatement("g.addV('person').property('name', name).property('uuid', uuid).property('number', number)").set("name", (Object)name).set("uuid", (Object)uuid.toString()).set("number", (Object)number);
            ListenableFuture future = this.session().executeGraphAsync((GraphStatement)addV);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    permits.release();
                }
            }, GuavaCompatibility.INSTANCE.sameThreadExecutor());
            futures.add(GuavaCompatibility.INSTANCE.transformAsync(future, (AsyncFunction)new AsyncFunction<GraphResultSet, Vertex>(){

                public ListenableFuture<Vertex> apply(GraphResultSet input) {
                    try {
                        GraphNode r = input.one();
                        GraphAssertions.assertThat(r).asVertex().hasProperty("name", name).hasProperty("uuid", uuid.toString()).hasProperty("number", number);
                        return Futures.immediateFuture((Object)r.asVertex());
                    }
                    catch (Throwable t) {
                        return Futures.immediateFailedFuture((Throwable)t);
                    }
                }
            }));
        }
        List addedVertices = (List)Uninterruptibles.getUninterruptibly((Future)Futures.allAsList((Iterable)futures), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        List results = this.session().executeGraph("g.V().hasLabel('person')").all();
        GraphAssertions.assertThat((List)results).extracting(GraphExtractors.asVertex()).containsOnlyElementsOf((Iterable)addedVertices);
    }
}

