/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry.codecs;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Utils;
import com.datastax.driver.dse.geometry.codecs.GeometryCodecIntegrationTest;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

@DseVersion(value="5.0.0")
public class LineStringCodecIntegrationTest
extends GeometryCodecIntegrationTest<LineString> {
    public LineStringCodecIntegrationTest() {
        super("LineStringType", Lists.newArrayList((Object[])new LineString[]{new LineString(Utils.p(0.0, 10.0), Utils.p(10.0, 0.0), new Point[0]), new LineString(Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), new Point[]{Utils.p(40.0, 40.0)}), new LineString(Utils.p(-5.0, 0.0), Utils.p(0.0, 10.0), new Point[]{Utils.p(10.0, 5.0)})}));
    }

    @Test(groups={"short"})
    public void should_insert_and_retrieve_empty_linestring() {
        LineString empty = LineString.fromWellKnownText((String)"LINESTRING EMPTY");
        UUID key = UUIDs.random();
        this.session().execute("INSERT INTO tbl (k, g) VALUES (?, ?)", new Object[]{key, empty});
        Row row = this.session().execute("SELECT g from tbl where k=?", new Object[]{key}).one();
        Assertions.assertThat((List)((LineString)row.get("g", LineString.class)).getPoints()).isEmpty();
    }
}

