/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.shared.DefaultDnFactory;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.sasl.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.plain.PlainMechanismHandler;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedADS {
    Logger logger = LoggerFactory.getLogger(EmbeddedADS.class);
    private final String dn;
    private final String realm;
    private int kdcPort;
    private int ldapPort;
    private final boolean kerberos;
    private InetAddress address;
    private String hostname;
    private File confDir;
    private volatile boolean isInit = false;
    private DirectoryService service;
    private LdapServer ldapServer;
    private KdcServer kdcServer;
    private Dn usersDN;
    private File krb5Conf;

    private EmbeddedADS(String dn, String realm, String address, int ldapPort, boolean kerberos, int kdcPort, File confDir) {
        this.dn = dn;
        this.realm = realm;
        try {
            this.address = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            this.logger.error("Failure resolving address '{}', falling back to loopback.", (Object)address, (Object)e);
            this.address = InetAddress.getLoopbackAddress();
        }
        this.hostname = this.address.getHostName().toLowerCase();
        this.ldapPort = ldapPort;
        this.kerberos = kerberos;
        this.kdcPort = kdcPort;
        this.confDir = confDir;
    }

    public void start() throws Exception {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        File workDir = Files.createTempDir();
        if (this.confDir == null) {
            this.confDir = workDir;
        }
        if (this.kerberos) {
            this.kdcPort = this.kdcPort != -1 ? this.kdcPort : EmbeddedADS.findAvailablePort(60088);
            this.krb5Conf = this.createKrb5Conf();
            System.setProperty("java.security.krb5.conf", this.krb5Conf.getAbsolutePath());
        }
        this.service = new DefaultDirectoryService();
        InstanceLayout layout = new InstanceLayout(workDir);
        this.service.setInstanceLayout(layout);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
        CacheService cacheService = new CacheService();
        cacheService.initialize(layout);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager();
        this.service.setSchemaManager((SchemaManager)schemaManager);
        schemaManager.loadAllEnabled();
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        LdifPartition ldifPartition = new LdifPartition((SchemaManager)schemaManager, this.service.getDnFactory());
        ldifPartition.setPartitionPath(new File(layout.getPartitionsDirectory(), "schema").toURI());
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        this.service.setSchemaPartition(schemaPartition);
        DefaultDnFactory dnFactory = new DefaultDnFactory((SchemaManager)schemaManager, cacheService.getCache("dnCache"));
        this.service.setDnFactory((DnFactory)dnFactory);
        JdbmPartition systemPartition = this.createPartition("system", dnFactory.create("ou=system"));
        this.service.setSystemPartition((Partition)systemPartition);
        this.service.startup();
        Dn partitionDn = dnFactory.create(this.dn);
        String dnName = partitionDn.getRdn().getValue().getString();
        JdbmPartition partition = this.createPartition(dnName, partitionDn);
        Entry context = this.service.newEntry(partitionDn);
        context.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
        context.add(partitionDn.getRdn().getType(), new String[]{dnName});
        partition.setContextEntry(context);
        this.service.addPartition((Partition)partition);
        this.usersDN = partitionDn.add(dnFactory.create("ou=users"));
        Entry usersEntry = this.service.newEntry(this.usersDN);
        usersEntry.add("objectClass", new String[]{"organizationalUnit", "top"});
        usersEntry.add("ou", new String[]{"users"});
        if (this.kerberos) {
            usersEntry = this.kerberize(usersEntry);
        }
        this.service.getAdminSession().add(usersEntry);
        this.startLdap();
        if (this.kerberos) {
            Dn tgtDN = this.usersDN.add(dnFactory.create("uid=krbtgt"));
            String servicePrincipal = "krbtgt/" + this.realm + "@" + this.realm;
            Entry tgtEntry = this.service.newEntry(tgtDN);
            tgtEntry.add("objectClass", new String[]{"person", "inetOrgPerson", "top", "krb5KDCEntry", "uidObject", "krb5Principal"});
            tgtEntry.add("krb5KeyVersionNumber", new String[]{"0"});
            tgtEntry.add("krb5PrincipalName", new String[]{servicePrincipal});
            tgtEntry.add("uid", new String[]{"krbtgt"});
            tgtEntry.add("userPassword", new String[]{"secret"});
            tgtEntry.add("sn", new String[]{"Service"});
            tgtEntry.add("cn", new String[]{"KDC Service"});
            this.service.getAdminSession().add(this.kerberize(tgtEntry));
            String saslPrincipal = "ldap/" + this.hostname + "@" + this.realm;
            this.ldapServer.setSaslPrincipal(saslPrincipal);
            Dn ldapDN = this.usersDN.add(dnFactory.create("uid=ldap"));
            Entry ldapEntry = this.service.newEntry(ldapDN);
            ldapEntry.add("objectClass", new String[]{"top", "person", "inetOrgPerson", "krb5KDCEntry", "uidObject", "krb5Principal"});
            ldapEntry.add("krb5KeyVersionNumber", new String[]{"0"});
            ldapEntry.add("krb5PrincipalName", new String[]{saslPrincipal});
            ldapEntry.add("uid", new String[]{"ldap"});
            ldapEntry.add("userPassword", new String[]{"secret"});
            ldapEntry.add("sn", new String[]{"Service"});
            ldapEntry.add("cn", new String[]{"LDAP Service"});
            this.service.getAdminSession().add(this.kerberize(ldapEntry));
            this.startKDC(servicePrincipal);
        }
    }

    public boolean isStarted() {
        return this.isInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createKrb5Conf() throws IOException {
        File krb5Conf = new File(this.confDir, "krb5.conf");
        String config = String.format("[libdefaults]%ndefault_realm = %s%ndefault_tgs_enctypes = aes128-cts-hmac-sha1-96 aes256-cts-hmac-sha1-96%n%n[realms]%n%s = {%n  kdc = %s:%d%n  admin_server = %s:%d%n}%n", this.realm, this.realm, this.hostname, this.kdcPort, this.hostname, this.kdcPort);
        FileOutputStream fios = new FileOutputStream(krb5Conf);
        try {
            PrintWriter pw = new PrintWriter(fios);
            pw.write(config);
            pw.close();
        }
        finally {
            fios.close();
        }
        return krb5Conf;
    }

    public File getKrb5Conf() {
        return this.krb5Conf;
    }

    public File addUserAndCreateKeytab(String user, String password, String principal) throws IOException, LdapException {
        this.addUser(user, password, principal);
        return this.createKeytab(user, password, principal);
    }

    public File createKeytab(String user, String password, String principal) throws IOException {
        File keytabFile = new File(this.confDir, user + ".keytab");
        Keytab keytab = Keytab.getInstance();
        KerberosTime timeStamp = new KerberosTime(System.currentTimeMillis());
        Map keys = KerberosKeyFactory.getKerberosKeys((String)principal, (String)password);
        KeytabEntry keytabEntry = new KeytabEntry(principal, 0, timeStamp, 0, (EncryptionKey)keys.get(EncryptionType.AES128_CTS_HMAC_SHA1_96));
        keytab.setEntries(Collections.singletonList(keytabEntry));
        keytab.write(keytabFile);
        return keytabFile;
    }

    public void addUser(String user, String password) throws LdapException {
        this.addUser(user, password, null);
    }

    public void addUser(String user, String password, String principal) throws LdapException {
        Preconditions.checkState((boolean)this.isInit);
        Dn userDN = this.usersDN.add("uid=" + user);
        Entry userEntry = this.service.newEntry(userDN);
        if (this.kerberos && principal != null) {
            userEntry.add("objectClass", new String[]{"organizationalPerson", "person", "extensibleObject", "inetOrgPerson", "top", "krb5KDCEntry", "uidObject", "krb5Principal"});
            userEntry.add("krb5KeyVersionNumber", new String[]{"0"});
            userEntry.add("krb5PrincipalName", new String[]{principal});
            userEntry = this.kerberize(userEntry);
        } else {
            userEntry.add("objectClass", new String[]{"organizationalPerson", "person", "extensibleObject", "inetOrgPerson", "top", "uidObject"});
        }
        userEntry.add("uid", new String[]{user});
        userEntry.add("sn", new String[]{user});
        userEntry.add("cn", new String[]{user});
        userEntry.add("userPassword", new String[]{password});
        this.service.getAdminSession().add(userEntry);
    }

    public void stop() {
        if (this.ldapServer != null) {
            this.ldapServer.stop();
        }
        if (this.kdcServer != null) {
            this.kdcServer.stop();
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    private Entry kerberize(Entry entry) throws LdapException {
        entry.add("entryCSN", new String[]{new CsnFactory(0).newInstance().toString()});
        entry.add("entryUUID", new String[]{UUID.randomUUID().toString()});
        return entry;
    }

    private JdbmPartition createPartition(String id, Dn dn) throws LdapInvalidDnException {
        JdbmPartition partition = new JdbmPartition(this.service.getSchemaManager(), this.service.getDnFactory());
        partition.setId(id);
        partition.setPartitionPath(new File(this.service.getInstanceLayout().getPartitionsDirectory(), id).toURI());
        partition.setSuffixDn(dn);
        partition.setSchemaManager(this.service.getSchemaManager());
        return partition;
    }

    private void startLdap() throws Exception {
        this.ldapServer = new LdapServer();
        HashMap mechanismHandlerMap = Maps.newHashMap();
        mechanismHandlerMap.put("PLAIN", new PlainMechanismHandler());
        mechanismHandlerMap.put("CRAM-MD5", new CramMd5MechanismHandler());
        mechanismHandlerMap.put("DIGEST-MD5", new DigestMd5MechanismHandler());
        mechanismHandlerMap.put("GSSAPI", new GssapiMechanismHandler());
        this.ldapServer.setSaslMechanismHandlers((Map)mechanismHandlerMap);
        this.ldapServer.setSaslHost(this.hostname);
        this.ldapServer.setSaslRealms(Collections.singletonList(this.realm));
        this.ldapServer.setSearchBaseDn(this.dn);
        this.ldapPort = this.ldapPort != -1 ? this.ldapPort : EmbeddedADS.findAvailablePort(10389);
        this.ldapServer.setTransports(new Transport[]{new TcpTransport(this.address.getHostAddress(), this.ldapPort)});
        this.ldapServer.setDirectoryService(this.service);
        if (this.kerberos) {
            KeyDerivationInterceptor interceptor = new KeyDerivationInterceptor();
            interceptor.init(this.service);
            this.service.addLast((Interceptor)interceptor);
        }
        this.ldapServer.start();
    }

    private void startKDC(String servicePrincipal) throws Exception {
        KerberosConfig config = new KerberosConfig();
        config.setEncryptionTypes((Set)Sets.newHashSet((Object[])new EncryptionType[]{EncryptionType.AES128_CTS_HMAC_SHA1_96}));
        config.setSearchBaseDn(this.dn);
        config.setServicePrincipal(servicePrincipal);
        this.kdcServer = new KdcServer(config);
        this.kdcServer.setDirectoryService(this.service);
        this.kdcServer.setTransports(new Transport[]{new TcpTransport(this.address.getHostAddress(), this.kdcPort), new UdpTransport(this.address.getHostAddress(), this.kdcPort)});
        this.kdcServer.start();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static int findAvailablePort(int startingWith) {
        IOException last = null;
        for (int port = startingWith; port < startingWith + 100; ++port) {
            try {
                ServerSocket s = new ServerSocket(port);
                s.close();
                return port;
            }
            catch (IOException e) {
                last = e;
                continue;
            }
        }
        throw new RuntimeException("Could not acquire an available port", last);
    }

    public static class Builder {
        private String dn = "dc=datastax,dc=com";
        private String realm = "DATASTAX.COM";
        private boolean kerberos = false;
        private int kdcPort = -1;
        private int ldapPort = -1;
        private String address = "127.0.0.1";
        private File confDir = null;

        private Builder() {
        }

        public EmbeddedADS build() {
            return new EmbeddedADS(this.dn, this.realm, this.address, this.ldapPort, this.kerberos, this.kdcPort, this.confDir);
        }

        public Builder withBaseDn(String dn) {
            this.dn = dn;
            return this;
        }

        public Builder withRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder withConfDir(File confDir) {
            this.confDir = confDir;
            return this;
        }

        public Builder withLdapPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
            this.ldapPort = port;
            return this;
        }

        public Builder withKerberos(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
            this.kdcPort = port;
            return this.withKerberos();
        }

        public Builder withKerberos() {
            this.kerberos = true;
            return this;
        }

        public Builder withAddress(String address) {
            this.address = address;
            return this;
        }
    }
}

