/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.auth.DseGSSAPIAuthProvider;
import com.datastax.driver.dse.auth.DsePlainTextAuthProvider;
import com.datastax.driver.dse.auth.EmbeddedADS;
import com.datastax.driver.dse.auth.KerberosUtils;
import java.io.File;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(ccmProvider="configureCCM")
@DseVersion(value="5.1.0")
public class DseProxyAuthenticationTest
extends CCMDseTestsSupport {
    private static final String realm = "DATASTAX.COM";
    private static final String address = TestUtils.IP_PREFIX + "1";
    private final EmbeddedADS adsServer = EmbeddedADS.builder().withKerberos().withRealm("DATASTAX.COM").withAddress(address).build();
    private final String dsePrincipal = "dse/" + this.adsServer.getHostname() + "@" + "DATASTAX.COM";
    private final String bobPrincipal = "bob@DATASTAX.COM";
    private final String charliePrincipal = "charlie@DATASTAX.COM";
    private File dseKeytab;
    private File bobKeytab;
    private File charlieKeytab;

    @BeforeClass(groups={"long"})
    public void setupKDC() throws Exception {
        if (this.adsServer.isStarted()) {
            return;
        }
        this.adsServer.start();
        this.dseKeytab = this.adsServer.addUserAndCreateKeytab("dse", "dse", this.dsePrincipal);
        this.bobKeytab = this.adsServer.addUserAndCreateKeytab("bob", "bob", "bob@DATASTAX.COM");
        this.charlieKeytab = this.adsServer.addUserAndCreateKeytab("charlie", "charlie", "charlie@DATASTAX.COM");
    }

    @AfterClass(groups={"long"}, alwaysRun=true)
    public void teardownKDC() throws Exception {
        this.adsServer.stop();
    }

    public CCMBridge.Builder configureCCM() {
        String authenticationOptions = "authentication_options:\n  enabled: true\n  default_scheme: kerberos\n  other_schemes:\n    - internal";
        return CCMBridge.builder().withCassandraConfiguration("authorizer", "com.datastax.bdp.cassandra.auth.DseAuthorizer").withCassandraConfiguration("authenticator", "com.datastax.bdp.cassandra.auth.DseAuthenticator").withDSEConfiguration(authenticationOptions).withDSEConfiguration("authorization_options.enabled", true).withDSEConfiguration("kerberos_options.keytab", this.dseKeytab.getAbsolutePath()).withDSEConfiguration("kerberos_options.service_principal", "dse/_HOST@DATASTAX.COM").withDSEConfiguration("kerberos_options.qop", "auth").withJvmArgs("-Dcassandra.superuser_setup_delay_ms=0", "-Djava.security.krb5.conf=" + this.adsServer.getKrb5Conf().getAbsolutePath());
    }

    @Override
    public DseCluster.Builder createClusterBuilder() {
        return super.createClusterBuilder().withAuthProvider((AuthProvider)new DsePlainTextAuthProvider("cassandra", "cassandra"));
    }

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE ROLE IF NOT EXISTS alice WITH PASSWORD = 'alice' AND LOGIN = FALSE", "CREATE ROLE IF NOT EXISTS ben WITH PASSWORD = 'ben' AND LOGIN = TRUE", "CREATE ROLE IF NOT EXISTS 'bob@DATASTAX.COM' WITH LOGIN = TRUE", "CREATE ROLE IF NOT EXISTS 'charlie@DATASTAX.COM' WITH PASSWORD = 'charlie' AND LOGIN = TRUE", "CREATE ROLE IF NOT EXISTS steve WITH PASSWORD = 'steve' AND LOGIN = TRUE", "CREATE KEYSPACE IF NOT EXISTS aliceks WITH REPLICATION = {'class':'SimpleStrategy', 'replication_factor':'1'}", "CREATE TABLE IF NOT EXISTS aliceks.alicetable (key text PRIMARY KEY, value text)", "INSERT INTO aliceks.alicetable (key, value) VALUES ('hello', 'world')", "GRANT ALL ON KEYSPACE aliceks TO alice", "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'ben'", "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'bob@DATASTAX.COM'", "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'steve'", "GRANT EXECUTE ON ALL AUTHENTICATION SCHEMES TO 'charlie@DATASTAX.COM'", "GRANT PROXY.LOGIN ON ROLE 'alice' TO 'ben'", "GRANT PROXY.LOGIN ON ROLE 'alice' TO 'bob@DATASTAX.COM'", "GRANT PROXY.EXECUTE ON ROLE 'alice' TO 'steve'", "GRANT PROXY.EXECUTE ON ROLE 'alice' TO 'charlie@DATASTAX.COM'");
    }

    @Test(groups={"long"})
    public void should_allow_plain_text_authorized_user_to_login_as() throws Exception {
        DsePlainTextAuthProvider authProvider = new DsePlainTextAuthProvider("ben", "ben", "alice");
        Row row = this.connectAndQuery((AuthProvider)authProvider, null);
        Assertions.assertThat((Object)row).isNotNull();
    }

    @Test(groups={"long"})
    public void should_allow_kerberos_authorized_user_to_login_as() throws Exception {
        DseGSSAPIAuthProvider authProvider = DseGSSAPIAuthProvider.builder().withLoginConfiguration(KerberosUtils.keytabClient(this.bobKeytab, "bob@DATASTAX.COM")).withAuthorizationId("alice").build();
        Row row = this.connectAndQuery((AuthProvider)authProvider, null);
        Assertions.assertThat((Object)row).isNotNull();
    }

    @Test(groups={"long"}, expectedExceptions={AuthenticationException.class})
    public void should_not_allow_plain_text_unauthorized_user_to_login_as() throws Exception {
        DsePlainTextAuthProvider authProvider = new DsePlainTextAuthProvider("steve", "steve", "alice");
        this.connectAndQuery((AuthProvider)authProvider, null);
    }

    @Test(groups={"long"}, expectedExceptions={AuthenticationException.class})
    public void should_not_allow_kerberos_unauthorized_user_to_login_as() throws Exception {
        DseGSSAPIAuthProvider authProvider = DseGSSAPIAuthProvider.builder().withLoginConfiguration(KerberosUtils.keytabClient(this.charlieKeytab, "charlie@DATASTAX.COM")).withAuthorizationId("alice").build();
        this.connectAndQuery((AuthProvider)authProvider, null);
    }

    @Test(groups={"long"})
    public void should_allow_plain_text_authorized_user_to_execute_as() throws Exception {
        DsePlainTextAuthProvider authProvider = new DsePlainTextAuthProvider("steve", "steve");
        Row row = this.connectAndQuery((AuthProvider)authProvider, "alice");
        Assertions.assertThat((Object)row).isNotNull();
    }

    @Test(groups={"long"})
    public void should_allow_plain_text_authorized_user_to_execute_batch_as() throws Exception {
        DsePlainTextAuthProvider authProvider = new DsePlainTextAuthProvider("steve", "steve");
        this.connectAndBatchQuery((AuthProvider)authProvider, "alice");
    }

    @Test(groups={"long"})
    public void should_allow_kerberos_authorized_user_to_execute_as() throws Exception {
        DseGSSAPIAuthProvider authProvider = DseGSSAPIAuthProvider.builder().withLoginConfiguration(KerberosUtils.keytabClient(this.charlieKeytab, "charlie@DATASTAX.COM")).build();
        Row row = this.connectAndQuery((AuthProvider)authProvider, "alice");
        Assertions.assertThat((Object)row).isNotNull();
    }

    @Test(groups={"long"})
    public void should_not_allow_plain_text_unauthorized_user_to_execute_as() throws Exception {
        DsePlainTextAuthProvider authProvider = new DsePlainTextAuthProvider("ben", "ben");
        try {
            this.connectAndQuery((AuthProvider)authProvider, "alice");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (UnauthorizedException e) {
            this.verifyException(e, "ben");
        }
    }

    @Test(groups={"long"})
    public void should_not_allow_plain_text_unauthorized_user_to_execute_batch_as() throws Exception {
        DsePlainTextAuthProvider authProvider = new DsePlainTextAuthProvider("ben", "ben");
        try {
            this.connectAndBatchQuery((AuthProvider)authProvider, "alice");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (UnauthorizedException e) {
            this.verifyException(e, "ben");
        }
    }

    @Test(groups={"long"})
    public void should_not_allow_kerberos_unauthorized_user_to_execute_as() throws Exception {
        DseGSSAPIAuthProvider authProvider = DseGSSAPIAuthProvider.builder().withLoginConfiguration(KerberosUtils.keytabClient(this.bobKeytab, "bob@DATASTAX.COM")).build();
        try {
            this.connectAndQuery((AuthProvider)authProvider, "alice");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (UnauthorizedException e) {
            this.verifyException(e, "bob@DATASTAX.COM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row connectAndQuery(AuthProvider authProvider, String as) {
        DseCluster cluster = this.createClusterBuilder().addContactPointsWithPorts(this.getContactPointsWithPorts()).withAuthProvider(authProvider).build();
        try {
            SimpleStatement statement = new SimpleStatement("select * from aliceks.alicetable");
            if (as != null) {
                statement = statement.executingAs(as);
            }
            Row row = cluster.connect().execute((Statement)statement).one();
            return row;
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndBatchQuery(AuthProvider authProvider, String as) {
        DseCluster cluster = this.createClusterBuilder().addContactPointsWithPorts(this.getContactPointsWithPorts()).withAuthProvider(authProvider).build();
        try {
            BatchStatement statement = new BatchStatement();
            statement.add((Statement)new SimpleStatement("delete from aliceks.alicetable where key = 'doesnotexist'"));
            if (as != null) {
                statement.executingAs(as);
            }
            cluster.connect().execute((Statement)statement).one();
        }
        finally {
            cluster.close();
        }
    }

    private void verifyException(UnauthorizedException e, String user) {
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)String.format("Either '%s' does not have permission to execute queries as 'alice' or that role does not exist. Run 'GRANT PROXY.EXECUTE ON ROLE 'alice' TO '%s' as an administrator if you wish to allow this.", user, user));
    }
}

