/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.dse.DseLoadBalancingPolicy;
import com.datastax.driver.dse.HostTargetingStatement;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DseLoadBalancingPolicyTest {
    @Mock
    LoadBalancingPolicy childPolicy;
    @Mock
    Host host1;
    @Mock
    Host host2;
    @Mock
    Host host3;
    @Mock
    Cluster cluster;
    DseLoadBalancingPolicy targetingPolicy;

    @BeforeMethod(groups={"unit"})
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.targetingPolicy = new DseLoadBalancingPolicy(this.childPolicy);
        this.targetingPolicy.init(this.cluster, (Collection)Lists.newArrayList((Object[])new Host[]{this.host1, this.host2, this.host3}));
    }

    @Test(groups={"unit"})
    public void should_return_child_plan_if_statement_not_targeted() {
        this.setChildPlan(this.host1, this.host2, this.host3);
        Iterator plan = this.targetingPolicy.newQueryPlan("ks", (Statement)new SimpleStatement("test"));
        Assertions.assertThat((Iterator)plan).containsExactly((Object[])new Host[]{this.host1, this.host2, this.host3});
    }

    @Test(groups={"unit"})
    public void should_move_target_host_first_if_statement_targeted() {
        this.setChildPlan(this.host1, this.host2, this.host3);
        HostTargetingStatement s = new HostTargetingStatement((Statement)new SimpleStatement("test"), this.host2);
        Iterator plan = this.targetingPolicy.newQueryPlan("ks", (Statement)s);
        Assertions.assertThat((Iterator)plan).containsExactly((Object[])new Host[]{this.host2, this.host1, this.host3});
    }

    @Test(groups={"unit"})
    public void should_ignore_target_host_if_down() {
        this.targetingPolicy.onDown(this.host2);
        this.setChildPlan(this.host1, this.host3);
        HostTargetingStatement s = new HostTargetingStatement((Statement)new SimpleStatement("test"), this.host2);
        Iterator plan = this.targetingPolicy.newQueryPlan("ks", (Statement)s);
        Assertions.assertThat((Iterator)plan).containsExactly((Object[])new Host[]{this.host1, this.host3});
    }

    private void setChildPlan(Host ... hosts) {
        Mockito.when((Object)this.childPolicy.newQueryPlan(Matchers.anyString(), (Statement)Matchers.any(Statement.class))).thenReturn((Object)Iterators.forArray((Object[])hosts));
    }
}

