/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.Drop;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class DropTest {
    @Test(groups={"unit"})
    public void should_drop_table() throws Exception {
        Drop statement = SchemaBuilder.dropTable((String)"test");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP TABLE test");
    }

    @Test(groups={"unit"})
    public void should_drop_table_with_keyspace() throws Exception {
        Drop statement = SchemaBuilder.dropTable((String)"ks", (String)"test");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP TABLE ks.test");
    }

    @Test(groups={"unit"})
    public void should_drop_table_with_keyspace_if_exists() throws Exception {
        Drop statement = SchemaBuilder.dropTable((String)"ks", (String)"test").ifExists();
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP TABLE IF EXISTS ks.test");
    }

    @Test(groups={"unit"})
    public void should_drop_type() throws Exception {
        Drop statement = SchemaBuilder.dropType((String)"test");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP TYPE test");
    }

    @Test(groups={"unit"})
    public void should_drop_type_with_keyspace() throws Exception {
        Drop statement = SchemaBuilder.dropType((String)"ks", (String)"test");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP TYPE ks.test");
    }

    @Test(groups={"unit"})
    public void should_drop_type_with_keyspace_if_exists() throws Exception {
        Drop statement = SchemaBuilder.dropType((String)"ks", (String)"test").ifExists();
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP TYPE IF EXISTS ks.test");
    }

    @Test(groups={"unit"})
    public void should_drop_index() throws Exception {
        Drop statement = SchemaBuilder.dropIndex((String)"test");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP INDEX test");
    }

    @Test(groups={"unit"})
    public void should_drop_index_with_keyspace() throws Exception {
        Drop statement = SchemaBuilder.dropIndex((String)"ks", (String)"test");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP INDEX ks.test");
    }

    @Test(groups={"unit"})
    public void should_drop_index_with_keyspace_if_exists() throws Exception {
        Drop statement = SchemaBuilder.dropIndex((String)"ks", (String)"test").ifExists();
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"DROP INDEX IF EXISTS ks.test");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The keyspace name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_keyspace_name_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.dropTable((String)"add", (String)"test").getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The table name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_table_name_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.dropTable((String)"add").getQueryString();
    }
}

