/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class CreateIndexTest {
    @Test(groups={"unit"})
    public void should_create_index() throws Exception {
        SchemaStatement statement = SchemaBuilder.createIndex((String)"myIndex").ifNotExists().onTable("ks", "test").andColumn("col");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE INDEX IF NOT EXISTS myIndex ON ks.test(col)");
    }

    @Test(groups={"unit"})
    public void should_create_index_on_keys_of_map_column() throws Exception {
        SchemaStatement statement = SchemaBuilder.createIndex((String)"myIndex").ifNotExists().onTable("ks", "test").andKeysOfColumn("col");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE INDEX IF NOT EXISTS myIndex ON ks.test(KEYS(col))");
    }
}

