/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.nio.ByteBuffer;
import org.testng.Assert;
import org.testng.annotations.Test;

@CCMConfig(clusterProvider="createClusterBuilderNoDebouncing")
public class QueryBuilderRoutingKeyTest
extends CCMTestsSupport {
    private static final String TABLE_TEXT = "test_text";
    private static final String TABLE_INT = "test_int";
    private static final String TABLE_CASE = "test_case";
    private static final String TABLE_CASE_QUOTED = "test_case_quoted";

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, a int, b int)", TABLE_TEXT), String.format("CREATE TABLE %s (k int PRIMARY KEY, a int, b int)", TABLE_INT), String.format("CREATE TABLE %s (theKey int PRIMARY KEY, a int, b int)", TABLE_CASE), String.format("CREATE TABLE %s (\"theKey\" int PRIMARY KEY, a int, b int, \"tHEkEY\" int)", TABLE_CASE_QUOTED));
    }

    @Test(groups={"short"})
    public void textRoutingKeyTest() throws Exception {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable(TABLE_TEXT);
        Assert.assertNotNull((Object)table);
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        String txt = "If she weighs the same as a duck... she's made of wood.";
        Insert query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"k", "a", "b"}, new Object[]{txt, 1, 2});
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)ByteBuffer.wrap(txt.getBytes()));
        this.session().execute((Statement)query);
        query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)txt));
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)ByteBuffer.wrap(txt.getBytes()));
        Row row = this.session().execute((Statement)query).one();
        Assert.assertEquals((String)row.getString("k"), (String)txt);
        Assert.assertEquals((int)row.getInt("a"), (int)1);
        Assert.assertEquals((int)row.getInt("b"), (int)2);
    }

    @Test(groups={"short"})
    public void routingKeyColumnCaseSensitivityTest() throws Exception {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable(TABLE_CASE);
        Assert.assertNotNull((Object)table);
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        Insert query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"theKey", "a", "b"}, new Object[]{42, 1, 2});
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 42);
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        this.session().execute((Statement)query);
        query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"theKey", (Object)42));
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        Row row = this.session().execute((Statement)query).one();
        Assert.assertEquals((int)row.getInt("theKey"), (int)42);
        Assert.assertEquals((int)row.getInt("a"), (int)1);
        Assert.assertEquals((int)row.getInt("b"), (int)2);
        query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"ThEkEy", "a", "b"}, new Object[]{42, 1, 2});
        bb = ByteBuffer.allocate(4);
        bb.putInt(0, 42);
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        this.session().execute((Statement)query);
        query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"ThEkEy", (Object)42));
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        row = this.session().execute((Statement)query).one();
        Assert.assertEquals((int)row.getInt("theKey"), (int)42);
        Assert.assertEquals((int)row.getInt("a"), (int)1);
        Assert.assertEquals((int)row.getInt("b"), (int)2);
    }

    @Test(groups={"short"})
    public void routingKeyColumnCaseSensitivityForQuotedIdentifiersTest() throws Exception {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable(TABLE_CASE_QUOTED);
        Assert.assertNotNull((Object)table);
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        Insert query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"\"theKey\"", "a", "b", "\"tHEkEY\""}, new Object[]{42, 1, 2, 3});
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 42);
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"theKey", "a", "b", "\"tHEkEY\""}, new Object[]{42, 1, 2, 3});
        Assert.assertNull((Object)query.getRoutingKey(protocolVersion, codecRegistry));
        query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"theKey", "a", "b", "theKey"}, new Object[]{42, 1, 2, 3});
        Assert.assertNull((Object)query.getRoutingKey(protocolVersion, codecRegistry));
    }

    @Test(groups={"short"})
    public void intRoutingKeyTest() throws Exception {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable(TABLE_INT);
        Assert.assertNotNull((Object)table);
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        Insert query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"k", "a", "b"}, new Object[]{42, 1, 2});
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 42);
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        this.session().execute((Statement)query);
        query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)42));
        Assert.assertEquals((Object)query.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        Row row = this.session().execute((Statement)query).one();
        Assert.assertEquals((int)row.getInt("k"), (int)42);
        Assert.assertEquals((int)row.getInt("a"), (int)1);
        Assert.assertEquals((int)row.getInt("b"), (int)2);
    }

    @Test(groups={"short"})
    public void intRoutingBatchKeyTest() throws Exception {
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable(TABLE_INT);
        Assert.assertNotNull((Object)table);
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 42);
        Select.Where query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)42));
        String batch_query = "BEGIN BATCH ";
        batch_query = batch_query + String.format("INSERT INTO %s.test_int (k,a) VALUES (42,1);", this.keyspace);
        batch_query = batch_query + String.format("UPDATE %s.test_int USING TTL 400;", this.keyspace);
        batch_query = batch_query + "APPLY BATCH;";
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"k", "a"}, new Object[]{42, 1})).add((RegularStatement)QueryBuilder.update((TableMetadata)table).using(QueryBuilder.ttl((int)400)));
        Assert.assertEquals((Object)batch.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
        batch_query = "BEGIN BATCH ";
        batch_query = batch_query + String.format("SELECT * FROM %s.test_int WHERE k=42;", this.keyspace);
        batch_query = batch_query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[]{query});
        Assert.assertEquals((Object)batch.getRoutingKey(protocolVersion, codecRegistry), (Object)bb);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
        batch_query = "BEGIN BATCH ";
        batch_query = batch_query + "SELECT * FROM foo WHERE k=42;";
        batch_query = batch_query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.select().from("foo").where(QueryBuilder.eq((String)"k", (Object)42)));
        Assert.assertEquals((Object)batch.getRoutingKey(protocolVersion, codecRegistry), null);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
        batch_query = "BEGIN BATCH USING TIMESTAMP 42 ";
        batch_query = batch_query + "INSERT INTO foo.bar (a) VALUES (123);";
        batch_query = batch_query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).using(QueryBuilder.timestamp((long)42L)).add((RegularStatement)QueryBuilder.insertInto((String)"foo", (String)"bar").value("a", (Object)123));
        Assert.assertEquals((Object)batch.getRoutingKey(protocolVersion, codecRegistry), null);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
    }
}

