/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.policies.AbstractRetryPolicyIntegrationTest;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mockito.Mockito;
import org.scassandra.http.client.Result;
import org.slf4j.helpers.MessageFormatter;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LoggingRetryPolicyIntegrationTest
extends AbstractRetryPolicyIntegrationTest {
    private volatile RetryPolicy.RetryDecision retryDecision;
    private Logger logger = Logger.getLogger((String)LoggingRetryPolicy.class.getName());
    private MemoryAppender appender;
    private Level originalLevel;
    private ConsistencyLevel defaultCL;

    @BeforeClass(groups={"short", "unit"})
    public void setUpRetryPolicy() {
        this.setRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)new CustomRetryPolicy()));
    }

    @BeforeMethod(groups={"short"})
    public void storeDefaultCL() {
        this.defaultCL = this.cluster.getConfiguration().getQueryOptions().getConsistencyLevel();
    }

    @BeforeMethod(groups={"short", "unit"})
    public void startCapturingLogs() {
        this.originalLevel = this.logger.getLevel();
        this.logger.setLevel(Level.INFO);
        this.appender = new MemoryAppender();
        this.logger.addAppender((Appender)this.appender);
    }

    @AfterMethod(groups={"short", "unit"})
    public void stopCapturingLogs() {
        this.logger.setLevel(this.originalLevel);
        this.logger.removeAppender((Appender)this.appender);
    }

    @Test(groups={"short"})
    public void should_log_ignored_read_timeout() throws InterruptedException {
        this.simulateError(1, Result.read_request_timeout);
        this.retryDecision = RetryPolicy.RetryDecision.ignore();
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Ignoring read timeout (initial consistency: {}, required responses: {}, received responses: {}, data retrieved: {}, retries: {})", this.defaultCL, 1, 0, false, 0));
    }

    @Test(groups={"short"})
    public void should_log_retried_read_timeout() throws InterruptedException {
        this.simulateError(1, Result.read_request_timeout);
        this.retryDecision = RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)ConsistencyLevel.LOCAL_ONE);
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Retrying on read timeout on {} at consistency {} (initial consistency: {}, required responses: {}, received responses: {}, data retrieved: {}, retries: {})", "next host", ConsistencyLevel.LOCAL_ONE, this.defaultCL, 1, 0, false, 0));
    }

    @Test(groups={"short"})
    public void should_log_ignored_write_timeout() throws InterruptedException {
        this.simulateError(1, Result.write_request_timeout);
        this.retryDecision = RetryPolicy.RetryDecision.ignore();
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Ignoring write timeout (initial consistency: {}, write type: {}, required acknowledgments: {}, received acknowledgments: {}, retries: {})", this.defaultCL, WriteType.SIMPLE, 1, 0, 0));
    }

    @Test(groups={"short"})
    public void should_log_retried_write_timeout() throws InterruptedException {
        this.simulateError(1, Result.write_request_timeout);
        this.retryDecision = RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)ConsistencyLevel.LOCAL_ONE);
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Retrying on write timeout on {} at consistency {} (initial consistency: {}, write type: {}, required acknowledgments: {}, received acknowledgments: {}, retries: {})", "next host", ConsistencyLevel.LOCAL_ONE, this.defaultCL, WriteType.SIMPLE, 1, 0, 0));
    }

    @Test(groups={"short"})
    public void should_log_ignored_unavailable() throws InterruptedException {
        this.simulateError(1, Result.unavailable);
        this.retryDecision = RetryPolicy.RetryDecision.ignore();
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Ignoring unavailable exception (initial consistency: {}, required replica: {}, alive replica: {}, retries: {})", this.defaultCL, 1, 0, 0));
    }

    @Test(groups={"short"})
    public void should_log_retried_unavailable() throws InterruptedException {
        this.simulateError(1, Result.unavailable);
        this.retryDecision = RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)ConsistencyLevel.LOCAL_ONE);
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Retrying on unavailable exception on {} at consistency {} (initial consistency: {}, required replica: {}, alive replica: {}, retries: {})", "next host", ConsistencyLevel.LOCAL_ONE, this.defaultCL, 1, 0, 0));
    }

    @Test(groups={"short"})
    public void should_log_ignored_request_error() throws InterruptedException {
        this.simulateError(1, Result.server_error);
        this.retryDecision = RetryPolicy.RetryDecision.ignore();
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Ignoring request error (initial consistency: {}, retries: {}, exception: {})", this.defaultCL, 0, new ServerError(this.host1.getSocketAddress(), "Server Error").toString()));
    }

    @Test(groups={"short"})
    public void should_log_retried_request_error() throws InterruptedException {
        this.simulateError(1, Result.server_error);
        this.retryDecision = RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)ConsistencyLevel.LOCAL_ONE);
        this.query();
        String line = this.appender.waitAndGet(5000L);
        Assertions.assertThat((String)line.trim()).isEqualTo((Object)this.expectedMessage("Retrying on request error on {} at consistency {} (initial consistency: {}, retries: {}, exception: {})", "next host", ConsistencyLevel.LOCAL_ONE, this.defaultCL, 0, new ServerError(this.host1.getSocketAddress(), "Server Error").toString()));
    }

    @Test(groups={"short"})
    public void should_call_init_method_on_inner_policy() {
        RetryPolicy innerPolicyMock = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        new LoggingRetryPolicy(innerPolicyMock).init(this.cluster);
        ((RetryPolicy)Mockito.verify((Object)innerPolicyMock)).init(this.cluster);
    }

    @Test(groups={"unit"})
    public void should_call_close_method_on_inner_policy() {
        RetryPolicy innerPolicyMock = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        new LoggingRetryPolicy(innerPolicyMock).close();
        ((RetryPolicy)Mockito.verify((Object)innerPolicyMock)).close();
    }

    private String expectedMessage(String template, Object ... args) {
        return MessageFormatter.arrayFormat((String)template, (Object[])args).getMessage();
    }

    class CustomRetryPolicy
    implements RetryPolicy {
        CustomRetryPolicy() {
        }

        public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            return LoggingRetryPolicyIntegrationTest.this.retryDecision;
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            return LoggingRetryPolicyIntegrationTest.this.retryDecision;
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            return LoggingRetryPolicyIntegrationTest.this.retryDecision;
        }

        public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
            return LoggingRetryPolicyIntegrationTest.this.retryDecision;
        }

        public void init(Cluster cluster) {
        }

        public void close() {
        }
    }
}

