/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.ScassandraTestBase;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.Test;

public class LatencyAwarePolicyTest
extends ScassandraTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_consider_latency_when_query_successful() throws Exception {
        String query = "SELECT foo FROM bar";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(query).build());
        LatencyAwarePolicy latencyAwarePolicy = LatencyAwarePolicy.builder((LoadBalancingPolicy)new RoundRobinPolicy()).withMininumMeasurements(1).build();
        Cluster.Builder builder = super.createClusterBuilder();
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)latencyAwarePolicy);
        Cluster cluster = builder.build();
        try {
            cluster.init();
            LatencyTrackerBarrier barrier = new LatencyTrackerBarrier(1);
            cluster.register((LatencyTracker)barrier);
            Session session = cluster.connect();
            session.execute(query);
            barrier.await();
            new LatencyAwarePolicy.Updater(latencyAwarePolicy).run();
            LatencyAwarePolicy.Snapshot snapshot = latencyAwarePolicy.getScoresSnapshot();
            Assertions.assertThat((Map)snapshot.getAllStats()).hasSize(1);
            LatencyAwarePolicy.Snapshot.Stats stats = snapshot.getStats(this.retrieveSingleHost(cluster));
            Assertions.assertThat((Object)stats).isNotNull();
            Assertions.assertThat((long)stats.getMeasurementsCount()).isEqualTo(1L);
            Assertions.assertThat((long)stats.getLatencyScore()).isNotEqualTo(-1L);
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_discard_latency_when_unavailable() throws Exception {
        String query = "SELECT foo FROM bar";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(query).withThen(PrimingRequest.then().withResult(Result.unavailable)).build());
        LatencyAwarePolicy latencyAwarePolicy = LatencyAwarePolicy.builder((LoadBalancingPolicy)new RoundRobinPolicy()).withMininumMeasurements(1).build();
        Cluster.Builder builder = super.createClusterBuilder();
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)latencyAwarePolicy);
        Cluster cluster = builder.build();
        try {
            cluster.init();
            LatencyTrackerBarrier barrier = new LatencyTrackerBarrier(1);
            cluster.register((LatencyTracker)barrier);
            Session session = cluster.connect();
            try {
                session.execute(query);
                Assertions.fail((String)"Should have thrown NoHostAvailableException");
            }
            catch (NoHostAvailableException e) {
                Throwable error = (Throwable)e.getErrors().get(this.hostAddress);
                Assertions.assertThat((Throwable)error).isNotNull();
                Assertions.assertThat((Throwable)error).isInstanceOf(UnavailableException.class);
            }
            barrier.await();
            new LatencyAwarePolicy.Updater(latencyAwarePolicy).run();
            LatencyAwarePolicy.Snapshot snapshot = latencyAwarePolicy.getScoresSnapshot();
            Assertions.assertThat((Map)snapshot.getAllStats()).isEmpty();
            LatencyAwarePolicy.Snapshot.Stats stats = snapshot.getStats(this.retrieveSingleHost(cluster));
            Assertions.assertThat((Object)stats).isNull();
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_consider_latency_when_read_timeout() throws Exception {
        String query = "SELECT foo FROM bar";
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(query).withThen(PrimingRequest.then().withResult(Result.read_request_timeout)).build());
        LatencyAwarePolicy latencyAwarePolicy = LatencyAwarePolicy.builder((LoadBalancingPolicy)new RoundRobinPolicy()).withMininumMeasurements(1).build();
        Cluster.Builder builder = super.createClusterBuilder();
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)latencyAwarePolicy);
        builder.withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE);
        Cluster cluster = builder.build();
        try {
            cluster.init();
            LatencyTrackerBarrier barrier = new LatencyTrackerBarrier(1);
            cluster.register((LatencyTracker)barrier);
            Session session = cluster.connect();
            try {
                session.execute(query);
                Assertions.fail((String)"Should have thrown ReadTimeoutException");
            }
            catch (ReadTimeoutException readTimeoutException) {
                // empty catch block
            }
            barrier.await();
            new LatencyAwarePolicy.Updater(latencyAwarePolicy).run();
            LatencyAwarePolicy.Snapshot snapshot = latencyAwarePolicy.getScoresSnapshot();
            Assertions.assertThat((Map)snapshot.getAllStats()).hasSize(1);
            LatencyAwarePolicy.Snapshot.Stats stats = snapshot.getStats(this.retrieveSingleHost(cluster));
            Assertions.assertThat((Object)stats).isNotNull();
            Assertions.assertThat((long)stats.getMeasurementsCount()).isEqualTo(1L);
            Assertions.assertThat((long)stats.getLatencyScore()).isNotEqualTo(-1L);
        }
        finally {
            cluster.close();
        }
    }

    private class LatencyTrackerBarrier
    implements LatencyTracker {
        private final CountDownLatch latch;

        private LatencyTrackerBarrier(int numberOfQueries) {
            this.latch = new CountDownLatch(numberOfQueries);
        }

        public void update(Host host, Statement statement, Exception exception, long newLatencyNanos) {
            this.latch.countDown();
        }

        public void await() throws InterruptedException {
            this.latch.await(10L, TimeUnit.SECONDS);
        }

        public void onRegister(Cluster cluster) {
        }

        public void onUnregister(Cluster cluster) {
        }
    }
}

