/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.TransportException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.AbstractRetryPolicyIntegrationTest;
import com.datastax.driver.core.policies.IdempotenceAwareRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.net.InetSocketAddress;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.mockito.Mockito;
import org.scassandra.http.client.ClosedConnectionConfig;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IdempotenceAwareRetryPolicyIntegrationTest
extends AbstractRetryPolicyIntegrationTest {
    public IdempotenceAwareRetryPolicyIntegrationTest() {
        super((RetryPolicy)new IdempotenceAwareRetryPolicy((RetryPolicy)new CustomRetryPolicy()));
    }

    @BeforeMethod(groups={"short"})
    public void setUpDefaultIdempotence() {
        this.cluster.getConfiguration().getQueryOptions().setDefaultIdempotence(false);
    }

    @Test(groups={"short"})
    public void should_not_retry_on_write_timeout_if_statement_non_idempotent() {
        this.simulateError(1, Result.write_request_timeout);
        try {
            this.query();
            Assertions.fail((String)"expected an WriteTimeoutException");
        }
        catch (WriteTimeoutException writeTimeoutException) {
            // empty catch block
        }
        this.assertOnWriteTimeoutWasCalled(0);
        Assertions.assertThat((long)this.errors.getWriteTimeouts().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_retry_on_write_timeout_if_statement_idempotent() {
        this.simulateError(1, Result.write_request_timeout);
        this.session.execute(new SimpleStatement("mock query").setIdempotent(true));
        this.assertOnWriteTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getWriteTimeouts().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(1L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_not_retry_on_client_timeout_if_statement_non_idempotent() {
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(1);
        try {
            this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(IdempotenceAwareRetryPolicyIntegrationTest.row("result", "result1"))).build());
            try {
                this.query();
                Assertions.fail((String)"expected an OperationTimedOutException");
            }
            catch (OperationTimedOutException e) {
                Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)String.format("[%s] Timed out waiting for server response", this.host1.getSocketAddress()));
            }
            this.assertOnRequestErrorWasCalled(0, OperationTimedOutException.class);
            Assertions.assertThat((long)this.errors.getClientTimeouts().getCount()).isEqualTo(1L);
            Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
            Assertions.assertThat((long)this.errors.getRetriesOnClientTimeout().getCount()).isEqualTo(0L);
            this.assertQueried(1, 1);
            this.assertQueried(2, 0);
            this.assertQueried(3, 0);
        }
        finally {
            this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(12000);
        }
    }

    @Test(groups={"short"})
    public void should_retry_on_client_timeout_if_statement_idempotent() {
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(1);
        try {
            this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(IdempotenceAwareRetryPolicyIntegrationTest.row("result", "result1"))).build());
            this.session.execute(new SimpleStatement("mock query").setIdempotent(true));
            this.assertOnRequestErrorWasCalled(1, OperationTimedOutException.class);
            Assertions.assertThat((long)this.errors.getClientTimeouts().getCount()).isEqualTo(1L);
            Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
            Assertions.assertThat((long)this.errors.getRetriesOnClientTimeout().getCount()).isEqualTo(1L);
            this.assertQueried(1, 1);
            this.assertQueried(2, 1);
            this.assertQueried(3, 0);
        }
        finally {
            this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(12000);
        }
    }

    @Test(groups={"short"}, dataProvider="serverSideErrors")
    public void should_not_retry_on_server_error_if_statement_non_idempotent(Result error, Class<? extends DriverException> exception) {
        this.simulateError(1, error);
        try {
            this.query();
            Assertions.fail((String)("expected " + exception));
        }
        catch (DriverException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(exception);
        }
        this.assertOnRequestErrorWasCalled(0, ServerError.class);
        Assertions.assertThat((long)this.errors.getOthers().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnOtherErrors().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="serverSideErrors")
    public void should_retry_on_server_error_if_statement_idempotent(Result error, Class<? extends DriverException> exception) {
        this.simulateError(1, error);
        this.simulateError(2, error);
        this.simulateError(3, error);
        try {
            this.session.execute(new SimpleStatement("mock query").setIdempotent(true));
            Assertions.fail((String)"expected a NoHostAvailableException");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
            Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(exception);
        }
        this.assertOnRequestErrorWasCalled(3, exception);
        Assertions.assertThat((long)this.errors.getOthers().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getRetriesOnOtherErrors().getCount()).isEqualTo(3L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 1);
    }

    @Test(groups={"short"}, dataProvider="connectionErrors")
    public void should_not_retry_on_connection_error_if_statement_non_idempotent(ClosedConnectionConfig.CloseType closeType) {
        this.simulateError(1, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(2, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(3, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        try {
            this.query();
            Fail.fail((String)"expected a TransportException");
        }
        catch (TransportException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)String.format("[%s] Connection has been closed", this.host1.getSocketAddress()));
        }
        this.assertOnRequestErrorWasCalled(0, TransportException.class);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getConnectionErrors().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getIgnoresOnConnectionError().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnConnectionError().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="connectionErrors")
    public void should_retry_on_connection_error_if_statement_idempotent(ClosedConnectionConfig.CloseType closeType) {
        this.simulateError(1, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(2, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(3, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        try {
            this.session.execute(new SimpleStatement("mock query").setIdempotent(true));
            Fail.fail((String)"expected a TransportException");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
            Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(TransportException.class);
        }
        this.assertOnRequestErrorWasCalled(3, TransportException.class);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getConnectionErrors().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getIgnoresOnConnectionError().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnConnectionError().getCount()).isEqualTo(3L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 1);
    }

    @Test(groups={"short"})
    public void should_call_init_method_on_inner_policy() {
        RetryPolicy innerPolicyMock = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        new IdempotenceAwareRetryPolicy(innerPolicyMock).init(this.cluster);
        ((RetryPolicy)Mockito.verify((Object)innerPolicyMock)).init(this.cluster);
    }

    @Test(groups={"unit"})
    public void should_call_close_method_on_inner_policy() {
        RetryPolicy innerPolicyMock = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        new IdempotenceAwareRetryPolicy(innerPolicyMock).close();
        ((RetryPolicy)Mockito.verify((Object)innerPolicyMock)).close();
    }

    static class CustomRetryPolicy
    implements RetryPolicy {
        CustomRetryPolicy() {
        }

        public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            return RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)cl);
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            return RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)cl);
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            return RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)cl);
        }

        public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
            return RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)cl);
        }

        public void init(Cluster cluster) {
        }

        public void close() {
        }
    }
}

