/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.HostFilterPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HostFilterPolicyTest {
    @Mock
    Cluster cluster;
    @Mock
    Host host1;
    @Mock
    Host host2;
    @Mock
    Host host3;
    InetSocketAddress address1 = InetSocketAddress.createUnresolved("192.168.1.1", 2345);
    InetSocketAddress address2 = InetSocketAddress.createUnresolved("192.168.1.2", 9876);
    InetSocketAddress address3 = InetSocketAddress.createUnresolved("192.168.1.3", 6666);
    @Mock
    LoadBalancingPolicy wrappedPolicy;
    @Captor
    ArgumentCaptor<Collection<Host>> hostsCaptor;

    @BeforeMethod(groups={"unit"})
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.host1.getSocketAddress()).thenReturn((Object)this.address1);
        Mockito.when((Object)this.host2.getSocketAddress()).thenReturn((Object)this.address2);
        Mockito.when((Object)this.host3.getSocketAddress()).thenReturn((Object)this.address3);
        Mockito.when((Object)this.wrappedPolicy.distance((Host)Mockito.any(Host.class))).thenReturn((Object)HostDistance.LOCAL);
    }

    @Test(groups={"unit"})
    public void should_delegate_to_wrapped_policy_when_predicate_is_true() {
        Predicate predicate = Predicates.alwaysTrue();
        HostFilterPolicy policy = new HostFilterPolicy(this.wrappedPolicy, predicate);
        policy.onAdd(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy)).onAdd(this.host1);
        policy.onDown(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy)).onDown(this.host1);
        policy.onUp(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy)).onUp(this.host1);
        policy.onRemove(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy)).onRemove(this.host1);
        Assertions.assertThat((Comparable)policy.distance(this.host1)).isSameAs((Object)HostDistance.LOCAL);
        policy.close();
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy)).close();
    }

    @Test(groups={"unit"})
    public void should_not_delegate_to_wrapped_policy_when_predicate_is_false() {
        Predicate predicate = Predicates.alwaysFalse();
        HostFilterPolicy policy = new HostFilterPolicy(this.wrappedPolicy, predicate);
        policy.onAdd(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy, (VerificationMode)Mockito.never())).onAdd(this.host1);
        policy.onDown(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy, (VerificationMode)Mockito.never())).onDown(this.host1);
        policy.onUp(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy, (VerificationMode)Mockito.never())).onUp(this.host1);
        policy.onRemove(this.host1);
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy, (VerificationMode)Mockito.never())).onRemove(this.host1);
        Assertions.assertThat((Comparable)policy.distance(this.host1)).isSameAs((Object)HostDistance.IGNORED);
    }

    @Test(groups={"unit"})
    public void should_filter_init_hosts_with_predicate() {
        Predicate predicate = Predicates.in((Collection)Lists.newArrayList((Object[])new Host[]{this.host1, this.host2}));
        HostFilterPolicy policy = new HostFilterPolicy(this.wrappedPolicy, predicate);
        policy.init(this.cluster, (Collection)Lists.newArrayList((Object[])new Host[]{this.host1, this.host2, this.host3}));
        ((LoadBalancingPolicy)Mockito.verify((Object)this.wrappedPolicy)).init((Cluster)Mockito.eq((Object)this.cluster), (Collection)this.hostsCaptor.capture());
        Assertions.assertThat((Iterable)((Iterable)this.hostsCaptor.getValue())).containsOnly((Object[])new Host[]{this.host1, this.host2});
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_throw_if_predicate_filters_out_all_init_hosts() {
        Predicate predicate = Predicates.alwaysFalse();
        HostFilterPolicy policy = new HostFilterPolicy(this.wrappedPolicy, predicate);
        policy.init(this.cluster, (Collection)Lists.newArrayList((Object[])new Host[]{this.host1, this.host2, this.host3}));
    }

    @Test(groups={"unit"})
    public void should_return_query_plan_of_wrapped_policy() {
        Mockito.when((Object)this.wrappedPolicy.newQueryPlan((String)Mockito.any(String.class), (Statement)Mockito.any(Statement.class))).thenReturn((Object)Iterators.forArray((Object[])new Host[]{this.host1, this.host2, this.host3}));
        HostFilterPolicy policy = new HostFilterPolicy(this.wrappedPolicy, null);
        Assertions.assertThat((Iterator)policy.newQueryPlan("keyspace", (Statement)Mockito.mock(Statement.class))).containsExactly((Object[])new Host[]{this.host1, this.host2, this.host3});
    }

    @Test(groups={"unit"})
    public void should_ignore_DCs_in_black_list() {
        Mockito.when((Object)this.host1.getDatacenter()).thenReturn((Object)"dc1");
        Mockito.when((Object)this.host2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.host3.getDatacenter()).thenReturn(null);
        HostFilterPolicy policy = HostFilterPolicy.fromDCBlackList((LoadBalancingPolicy)this.wrappedPolicy, (Iterable)Lists.newArrayList((Object[])new String[]{"dc2"}));
        Assertions.assertThat((Comparable)policy.distance(this.host1)).isSameAs((Object)HostDistance.LOCAL);
        Assertions.assertThat((Comparable)policy.distance(this.host2)).isSameAs((Object)HostDistance.IGNORED);
        Assertions.assertThat((Comparable)policy.distance(this.host3)).isSameAs((Object)HostDistance.LOCAL);
    }

    @Test(groups={"unit"})
    public void should_ignore_DCs_not_in_white_list_and_not_null() {
        Mockito.when((Object)this.host1.getDatacenter()).thenReturn((Object)"dc1");
        Mockito.when((Object)this.host2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.host3.getDatacenter()).thenReturn(null);
        HostFilterPolicy policy = HostFilterPolicy.fromDCWhiteList((LoadBalancingPolicy)this.wrappedPolicy, (Iterable)Lists.newArrayList((Object[])new String[]{"dc1"}));
        Assertions.assertThat((Comparable)policy.distance(this.host1)).isSameAs((Object)HostDistance.LOCAL);
        Assertions.assertThat((Comparable)policy.distance(this.host2)).isSameAs((Object)HostDistance.IGNORED);
        Assertions.assertThat((Comparable)policy.distance(this.host3)).isSameAs((Object)HostDistance.LOCAL);
    }
}

