/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.TransportException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.AbstractRetryPolicyIntegrationTest;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.scassandra.http.client.ClosedConnectionConfig;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.Test;

public class FallthroughRetryPolicyIntegrationTest
extends AbstractRetryPolicyIntegrationTest {
    public FallthroughRetryPolicyIntegrationTest() {
        super((RetryPolicy)FallthroughRetryPolicy.INSTANCE);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_read_timeout_with_0_receivedResponses() {
        this.simulateError(1, Result.read_request_timeout);
        try {
            this.query();
            Assertions.fail((String)"expected a ReadTimeoutException");
        }
        catch (ReadTimeoutException readTimeoutException) {
            // empty catch block
        }
        this.assertOnReadTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getRetriesOnReadTimeout().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_write_timeout_with_SIMPLE_write_type() {
        this.simulateError(1, Result.write_request_timeout);
        try {
            this.query();
            Assertions.fail((String)"expected a WriteTimeoutException");
        }
        catch (WriteTimeoutException writeTimeoutException) {
            // empty catch block
        }
        this.assertOnWriteTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_unavailable() {
        this.simulateError(1, Result.unavailable);
        try {
            this.query();
            Assertions.fail((String)"expected an UnavailableException");
        }
        catch (UnavailableException unavailableException) {
            // empty catch block
        }
        this.assertOnUnavailableWasCalled(1);
        Assertions.assertThat((long)this.errors.getRetriesOnUnavailable().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_client_timeouts() {
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(1);
        try {
            this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(FallthroughRetryPolicyIntegrationTest.row("result", "result1"))).build());
            try {
                this.query();
                Fail.fail((String)"expected an OperationTimedOutException");
            }
            catch (OperationTimedOutException e) {
                Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)String.format("[%s] Timed out waiting for server response", this.host1.getSocketAddress()));
            }
            this.assertOnRequestErrorWasCalled(1, OperationTimedOutException.class);
            Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
            Assertions.assertThat((long)this.errors.getClientTimeouts().getCount()).isEqualTo(1L);
            Assertions.assertThat((long)this.errors.getRetriesOnClientTimeout().getCount()).isEqualTo(0L);
            this.assertQueried(1, 1);
            this.assertQueried(2, 0);
            this.assertQueried(3, 0);
        }
        finally {
            this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(12000);
        }
    }

    @Test(groups={"short"}, dataProvider="serverSideErrors")
    public void should_rethrow_on_server_side_error(Result error, Class<? extends DriverException> exception) {
        this.simulateError(1, error);
        try {
            this.query();
            Fail.fail((String)"expected a DriverException");
        }
        catch (DriverException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(exception);
        }
        this.assertOnRequestErrorWasCalled(1, ServerError.class);
        Assertions.assertThat((long)this.errors.getOthers().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnOtherErrors().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="connectionErrors")
    public void should_rethrow_on_connection_error(ClosedConnectionConfig.CloseType closeType) {
        this.simulateError(1, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        try {
            this.query();
            Fail.fail((String)"expected a TransportException");
        }
        catch (TransportException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)String.format("[%s] Connection has been closed", this.host1.getSocketAddress()));
        }
        this.assertOnRequestErrorWasCalled(1, TransportException.class);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getConnectionErrors().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getIgnoresOnConnectionError().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnConnectionError().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }
}

