/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.ReadFailureException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.TransportException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteFailureException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.AbstractRetryPolicyIntegrationTest;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.net.InetSocketAddress;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.scassandra.http.client.ClosedConnectionConfig;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.Consistency;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.ReadTimeoutConfig;
import org.scassandra.http.client.Result;
import org.scassandra.http.client.UnavailableConfig;
import org.scassandra.http.client.WriteTimeoutConfig;
import org.scassandra.http.client.WriteTypePrime;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DowngradingConsistencyRetryPolicyIntegrationTest
extends AbstractRetryPolicyIntegrationTest {
    public DowngradingConsistencyRetryPolicyIntegrationTest() {
        super((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
    }

    @DataProvider
    public static Object[][] consistencyLevels() {
        return new Object[][]{{4, ConsistencyLevel.THREE}, {3, ConsistencyLevel.THREE}, {2, ConsistencyLevel.TWO}, {1, ConsistencyLevel.ONE}};
    }

    @DataProvider
    public static Object[][] rethrowWriteTypes() {
        return new Object[][]{{WriteTypePrime.SIMPLE}, {WriteTypePrime.BATCH}, {WriteTypePrime.COUNTER}, {WriteTypePrime.CAS}};
    }

    @DataProvider
    public static Object[][] ignoreWriteTypesWithReceivedAcks() {
        return new Object[][]{{WriteTypePrime.SIMPLE}, {WriteTypePrime.BATCH}};
    }

    @Test(groups={"short"})
    public void should_retry_once_on_same_host_from_each_quorum_to_one() {
        this.simulateError(1, Result.read_request_timeout, (Config)new ReadTimeoutConfig(0, 3, false));
        try {
            this.queryWithCL(ConsistencyLevel.EACH_QUORUM);
        }
        catch (ReadTimeoutException e) {
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.ONE);
        }
        this.assertOnReadTimeoutWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getReadTimeouts().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnReadTimeout().getCount()).isEqualTo(1L);
        this.assertQueried(1, 2);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="consistencyLevels")
    public void should_retry_once_on_same_host_with_reduced_consistency_level_on_read_timeout(int received, ConsistencyLevel expectedDowngradedCL) {
        this.simulateError(1, Result.read_request_timeout, (Config)new ReadTimeoutConfig(received, received + 1, true));
        try {
            this.query();
            Assert.fail((String)"expected an ReadTimeoutException");
        }
        catch (ReadTimeoutException e) {
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)expectedDowngradedCL);
        }
        this.assertOnReadTimeoutWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getReadTimeouts().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnReadTimeout().getCount()).isEqualTo(1L);
        this.assertQueried(1, 2);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_retry_once_if_not_data_was_retrieved_and_enough_replicas_alive() {
        this.simulateError(1, Result.read_request_timeout, (Config)new ReadTimeoutConfig(1, 1, false));
        try {
            this.query();
            Assert.fail((String)"expected an ReadTimeoutException");
        }
        catch (ReadTimeoutException readTimeoutException) {
            // empty catch block
        }
        this.assertOnReadTimeoutWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getReadTimeouts().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnReadTimeout().getCount()).isEqualTo(1L);
        this.assertQueried(1, 2);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_if_no_hosts_alive_on_read_timeout() {
        this.simulateError(1, Result.read_request_timeout);
        try {
            this.query();
            Assert.fail((String)"expected a ReadTimeoutException");
        }
        catch (ReadTimeoutException readTimeoutException) {
            // empty catch block
        }
        this.assertOnReadTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getReadTimeouts().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnReadTimeout().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="rethrowWriteTypes")
    public void should_rethrow_on_write_timeout_with_write_type(WriteTypePrime writeType) {
        this.simulateError(1, Result.write_request_timeout, (Config)new WriteTimeoutConfig(writeType, 0, 2));
        try {
            this.query();
            Assert.fail((String)"expected a WriteTimeoutException");
        }
        catch (WriteTimeoutException writeTimeoutException) {
            // empty catch block
        }
        this.assertOnWriteTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getWriteTimeouts().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="ignoreWriteTypesWithReceivedAcks")
    public void should_ignore_on_write_timeout_with_write_type_and_received_acks(WriteTypePrime writeType) {
        this.simulateError(1, Result.write_request_timeout, (Config)new WriteTimeoutConfig(writeType, 1, 2));
        this.query();
        this.assertOnWriteTimeoutWasCalled(1);
        Assertions.assertThat((long)this.errors.getWriteTimeouts().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getIgnoresOnWriteTimeout().getCount()).isEqualTo(1L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_retry_once_on_same_host_with_BATCH_LOG_write_type() {
        this.simulateError(1, Result.write_request_timeout, (Config)new WriteTimeoutConfig(WriteTypePrime.BATCH_LOG, 1, 2));
        try {
            this.query();
            Assert.fail((String)"expected a WriteTimeoutException");
        }
        catch (WriteTimeoutException writeTimeoutException) {
            // empty catch block
        }
        this.assertOnWriteTimeoutWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getWriteTimeouts().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(1L);
        this.assertQueried(1, 2);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="consistencyLevels")
    public void should_retry_once_on_same_host_with_reduced_consistency_level_on_write_timeout(int alive, ConsistencyLevel expectedDowngradedCL) {
        this.simulateError(1, Result.write_request_timeout, (Config)new WriteTimeoutConfig(WriteTypePrime.UNLOGGED_BATCH, alive, alive + 1));
        try {
            this.query();
            Assert.fail((String)"expected a WriteTimeoutException");
        }
        catch (WriteTimeoutException e) {
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)expectedDowngradedCL);
        }
        this.assertOnWriteTimeoutWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getWriteTimeouts().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnWriteTimeout().getCount()).isEqualTo(1L);
        this.assertQueried(1, 2);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"}, dataProvider="consistencyLevels")
    public void should_retry_once_on_same_host_with_reduced_consistency_level_on_unavailable(int alive, ConsistencyLevel expectedDowngradedCL) {
        this.simulateError(1, Result.unavailable, (Config)new UnavailableConfig(alive + 1, alive));
        try {
            this.query();
            Assert.fail((String)"expected an UnavailableException");
        }
        catch (UnavailableException e) {
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)expectedDowngradedCL);
        }
        this.assertOnUnavailableWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getUnavailables().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnUnavailable().getCount()).isEqualTo(1L);
        this.assertQueried(1, 2);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_if_no_hosts_alive_on_unavailable() {
        this.simulateError(1, Result.unavailable, (Config)new UnavailableConfig(1, 0));
        try {
            this.query();
            Assert.fail((String)"expected an UnavailableException");
        }
        catch (UnavailableException unavailableException) {
            // empty catch block
        }
        this.assertOnUnavailableWasCalled(1);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getUnavailables().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetriesOnUnavailable().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_try_next_host_on_client_timeouts() {
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(1);
        try {
            this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(DowngradingConsistencyRetryPolicyIntegrationTest.row("result", "result1"))).build());
            this.scassandras.node(2).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(DowngradingConsistencyRetryPolicyIntegrationTest.row("result", "result2"))).build());
            this.scassandras.node(3).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(1000L)).withRows(DowngradingConsistencyRetryPolicyIntegrationTest.row("result", "result3"))).build());
            try {
                this.query();
                Assertions.fail((String)"expected a NoHostAvailableException");
            }
            catch (NoHostAvailableException e) {
                Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
                Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(OperationTimedOutException.class).extractingResultOf("getMessage").containsOnlyOnce(new Object[]{String.format("[%s] Timed out waiting for server response", this.host1.getSocketAddress()), String.format("[%s] Timed out waiting for server response", this.host2.getSocketAddress()), String.format("[%s] Timed out waiting for server response", this.host3.getSocketAddress())});
            }
            this.assertOnRequestErrorWasCalled(3, OperationTimedOutException.class);
            Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
            Assertions.assertThat((long)this.errors.getClientTimeouts().getCount()).isEqualTo(3L);
            Assertions.assertThat((long)this.errors.getRetriesOnClientTimeout().getCount()).isEqualTo(3L);
            this.assertQueried(1, 1);
            this.assertQueried(2, 1);
            this.assertQueried(3, 1);
        }
        finally {
            this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(12000);
        }
    }

    @Test(groups={"short"}, dataProvider="serverSideErrors")
    public void should_try_next_host_on_server_side_error(Result error, Class<? extends DriverException> exception) {
        this.simulateError(1, error);
        this.simulateError(2, error);
        this.simulateError(3, error);
        try {
            this.query();
            Fail.fail((String)"expected a NoHostAvailableException");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
            Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(exception);
        }
        this.assertOnRequestErrorWasCalled(3, exception);
        Assertions.assertThat((long)this.errors.getOthers().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getRetriesOnOtherErrors().getCount()).isEqualTo(3L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 1);
    }

    @Test(groups={"short"}, dataProvider="connectionErrors")
    public void should_try_next_host_on_connection_error(ClosedConnectionConfig.CloseType closeType) {
        this.simulateError(1, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(2, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        this.simulateError(3, Result.closed_connection, (Config)new ClosedConnectionConfig(closeType));
        try {
            this.query();
            Fail.fail((String)"expected a TransportException");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat(e.getErrors().keySet()).hasSize(3).containsOnly((Object[])new InetSocketAddress[]{this.host1.getSocketAddress(), this.host2.getSocketAddress(), this.host3.getSocketAddress()});
            Assertions.assertThat(e.getErrors().values()).hasOnlyElementsOfType(TransportException.class);
        }
        this.assertOnRequestErrorWasCalled(3, TransportException.class);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getConnectionErrors().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)this.errors.getIgnoresOnConnectionError().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnConnectionError().getCount()).isEqualTo(3L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 1);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_unavailable_if_CAS() {
        this.simulateError(1, Result.unavailable, (Config)new UnavailableConfig(1, 0, Consistency.SERIAL));
        this.simulateError(2, Result.unavailable, (Config)new UnavailableConfig(1, 0, Consistency.SERIAL));
        try {
            this.query();
            Assert.fail((String)"expected an UnavailableException");
        }
        catch (UnavailableException e) {
            Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.SERIAL);
        }
        this.assertOnUnavailableWasCalled(2);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getUnavailables().getCount()).isEqualTo(2L);
        Assertions.assertThat((long)this.errors.getRetriesOnUnavailable().getCount()).isEqualTo(1L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 1);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_read_failure() {
        this.simulateError(1, Result.read_failure);
        try {
            this.query();
            Assert.fail((String)"expected a ReadFailureException");
        }
        catch (DriverException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(ReadFailureException.class);
        }
        this.assertOnRequestErrorWasCalled(1, ReadFailureException.class);
        Assertions.assertThat((long)this.errors.getOthers().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnOtherErrors().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }

    @Test(groups={"short"})
    public void should_rethrow_on_write_failure() {
        this.simulateError(1, Result.write_failure);
        try {
            this.query();
            Assert.fail((String)"expected a WriteFailureException");
        }
        catch (DriverException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(WriteFailureException.class);
        }
        this.assertOnRequestErrorWasCalled(1, WriteFailureException.class);
        Assertions.assertThat((long)this.errors.getOthers().getCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.errors.getRetries().getCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.errors.getRetriesOnOtherErrors().getCount()).isEqualTo(0L);
        this.assertQueried(1, 1);
        this.assertQueried(2, 0);
        this.assertQueried(3, 0);
    }
}

