/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataProviders;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.QueryTracker;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.HostFilterPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DCAwareRoundRobinPolicyTest {
    private final Logger policyLogger = Logger.getLogger(DCAwareRoundRobinPolicy.class);
    private Level originalLevel;
    private MemoryAppender logs;
    private QueryTracker queryTracker;
    @Captor
    private ArgumentCaptor<Collection<Host>> initHostsCaptor;

    @BeforeMethod(groups={"short"})
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.originalLevel = this.policyLogger.getLevel();
        this.policyLogger.setLevel(Level.WARN);
        this.logs = new MemoryAppender();
        this.policyLogger.addAppender((Appender)this.logs);
        this.queryTracker = new QueryTracker();
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void tearDown() {
        this.policyLogger.setLevel(this.originalLevel);
        this.policyLogger.removeAppender((Appender)this.logs);
    }

    private Cluster.Builder builder() {
        return Cluster.builder().withNettyOptions(TestUtils.nonQuietClusterCloseOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_round_robin_within_local_dc() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5, 5).build();
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(ScassandraCluster.datacenter(1)).build()).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50);
            for (int i = 1; i <= 5; ++i) {
                this.queryTracker.assertQueried(sCluster, 1, i, 10);
                this.queryTracker.assertQueried(sCluster, 2, i, 0);
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_not_use_remote_hosts_if_some_nodes_are_up_in_local_dc() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5, 5).build();
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(ScassandraCluster.datacenter(1)).withUsedHostsPerRemoteDc(2).build()).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            sCluster.stop(cluster, 1, 5);
            sCluster.stop(cluster, 1, 3);
            sCluster.stop(cluster, 1, 1);
            Assertions.assertThat(cluster).controlHost().isNotNull();
            this.queryTracker.query(session, 50);
            this.queryTracker.assertQueried(sCluster, 1, 2, 25);
            this.queryTracker.assertQueried(sCluster, 1, 4, 25);
            for (int i = 1; i <= 5; ++i) {
                this.queryTracker.assertQueried(sCluster, 2, i, 0);
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_round_robin_on_remote_hosts_when_no_up_nodes_in_local_dc() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5, 5).build();
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withUsedHostsPerRemoteDc(2).build()).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            sCluster.stopDC(cluster, 1);
            Assertions.assertThat(cluster).controlHost().isNotNull();
            this.queryTracker.query(session, 50);
            ArrayList queryCounts = Lists.newArrayList();
            for (int i = 1; i <= 5; ++i) {
                queryCounts.add(this.queryTracker.queryCount(sCluster, 2, i));
            }
            Assertions.assertThat((Iterable)queryCounts).containsOnly((Object[])new Integer[]{0, 0, 0, 25, 25});
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="consistencyLevels", dataProviderClass=DataProviders.class)
    public void should_only_use_remote_hosts_when_using_non_dc_local_cl(ConsistencyLevel cl) {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2).build();
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withUsedHostsPerRemoteDc(2).build()).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            sCluster.stopDC(cluster, 1);
            Assertions.assertThat(cluster).controlHost().isNotNull();
            Class expectedException = cl.isDCLocal() ? NoHostAvailableException.class : null;
            this.queryTracker.query(session, 50, cl, expectedException);
            int expectedQueryCount = cl.isDCLocal() ? 0 : 25;
            for (int i = 1; i <= 2; ++i) {
                this.queryTracker.assertQueried(sCluster, 1, i, 0);
                this.queryTracker.assertQueried(sCluster, 2, i, expectedQueryCount);
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="consistencyLevels", dataProviderClass=DataProviders.class)
    public void should_use_remote_hosts_for_local_cl_when_allowed(ConsistencyLevel cl) {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2).build();
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().allowRemoteDCsForLocalConsistencyLevel().withUsedHostsPerRemoteDc(2).build()).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            sCluster.stopDC(cluster, 1);
            Assertions.assertThat(cluster).controlHost().isNotNull();
            this.queryTracker.query(session, 50, cl, null);
            for (int i = 1; i <= 2; ++i) {
                this.queryTracker.assertQueried(sCluster, 1, i, 0);
                this.queryTracker.assertQueried(sCluster, 2, i, 25);
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_not_send_requests_to_blacklisted_dc_using_host_filter_policy() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2, 2).build();
        HostFilterPolicy loadBalancingPolicy = HostFilterPolicy.fromDCBlackList((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withUsedHostsPerRemoteDc(2).build(), (Iterable)Lists.newArrayList((Object[])new String[]{ScassandraCluster.datacenter(2)}));
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)loadBalancingPolicy).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50);
            this.queryTracker.assertQueried(sCluster, 1, 1, 25);
            this.queryTracker.assertQueried(sCluster, 1, 2, 25);
            this.queryTracker.assertQueried(sCluster, 2, 1, 0);
            this.queryTracker.assertQueried(sCluster, 2, 2, 0);
            this.queryTracker.assertQueried(sCluster, 3, 1, 0);
            this.queryTracker.assertQueried(sCluster, 3, 1, 0);
            sCluster.stopDC(cluster, 1);
            Assertions.assertThat(cluster).controlHost().isNotNull();
            this.queryTracker.reset();
            this.queryTracker.query(session, 50);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 2, 1, 0);
            this.queryTracker.assertQueried(sCluster, 2, 2, 0);
            this.queryTracker.assertQueried(sCluster, 3, 1, 25);
            this.queryTracker.assertQueried(sCluster, 3, 2, 25);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_send_requests_to_whitelisted_dcs_using_host_filter_policy() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2, 2).build();
        HostFilterPolicy loadBalancingPolicy = HostFilterPolicy.fromDCWhiteList((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withUsedHostsPerRemoteDc(2).build(), (Iterable)Lists.newArrayList((Object[])new String[]{ScassandraCluster.datacenter(1), ScassandraCluster.datacenter(2)}));
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)loadBalancingPolicy).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50);
            this.queryTracker.assertQueried(sCluster, 1, 1, 25);
            this.queryTracker.assertQueried(sCluster, 1, 2, 25);
            this.queryTracker.assertQueried(sCluster, 2, 1, 0);
            this.queryTracker.assertQueried(sCluster, 2, 2, 0);
            this.queryTracker.assertQueried(sCluster, 3, 1, 0);
            this.queryTracker.assertQueried(sCluster, 3, 1, 0);
            sCluster.stopDC(cluster, 1);
            Assertions.assertThat(cluster).controlHost().isNotNull();
            this.queryTracker.reset();
            this.queryTracker.query(session, 50);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 2, 1, 25);
            this.queryTracker.assertQueried(sCluster, 2, 2, 25);
            this.queryTracker.assertQueried(sCluster, 3, 1, 0);
            this.queryTracker.assertQueried(sCluster, 3, 1, 0);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_local_dc_from_contact_points_when_not_explicitly_specified() {
        DCAwareRoundRobinPolicy policy = (DCAwareRoundRobinPolicy)Mockito.spy((Object)DCAwareRoundRobinPolicy.builder().build());
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2).build();
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).build();
        try {
            sCluster.init();
            Host host1 = TestUtils.findHost(cluster, 1);
            cluster.init();
            ((DCAwareRoundRobinPolicy)Mockito.verify((Object)policy)).init((Cluster)Matchers.any(Cluster.class), (Collection)this.initHostsCaptor.capture());
            Assertions.assertThat((Iterable)((Iterable)this.initHostsCaptor.getValue())).containsExactly((Object[])new Host[]{host1});
            Assertions.assertThat((String)policy.localDc).isEqualTo((Object)host1.getDatacenter());
            Assertions.assertThat((String)this.logs.get()).doesNotContain((CharSequence)"Some contact points don't match local datacenter");
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_warn_if_contact_points_have_different_dcs_when_not_explicitly_specified() {
        DCAwareRoundRobinPolicy policy = (DCAwareRoundRobinPolicy)Mockito.spy((Object)DCAwareRoundRobinPolicy.builder().build());
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2).build();
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress(), sCluster.address(2, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).build();
        try {
            sCluster.init();
            Host host1 = TestUtils.findHost(cluster, 1);
            Host host3 = TestUtils.findHost(cluster, 3);
            cluster.init();
            ((DCAwareRoundRobinPolicy)Mockito.verify((Object)policy)).init((Cluster)Matchers.any(Cluster.class), (Collection)this.initHostsCaptor.capture());
            Assertions.assertThat((Iterable)((Iterable)this.initHostsCaptor.getValue())).containsOnly((Object[])new Host[]{host1, host3});
            Assertions.assertThat((String)this.logs.get()).contains(new CharSequence[]{"Some contact points don't match local data center"});
            Assertions.assertThat((boolean)policy.isContactPointsMultipleDCs()).isTrue();
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_provided_local_dc_and_not_warn_if_contact_points_match() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2).build();
        DCAwareRoundRobinPolicy policy = (DCAwareRoundRobinPolicy)Mockito.spy((Object)DCAwareRoundRobinPolicy.builder().withLocalDc(ScassandraCluster.datacenter(1)).build());
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).build();
        try {
            sCluster.init();
            Host host1 = TestUtils.findHost(cluster, 1);
            cluster.init();
            ((DCAwareRoundRobinPolicy)Mockito.verify((Object)policy)).init((Cluster)Matchers.any(Cluster.class), (Collection)this.initHostsCaptor.capture());
            Assertions.assertThat((Iterable)((Iterable)this.initHostsCaptor.getValue())).containsOnly((Object[])new Host[]{host1});
            Assertions.assertThat((String)policy.localDc).isEqualTo((Object)host1.getDatacenter());
            Assertions.assertThat((String)this.logs.get()).doesNotContain((CharSequence)"Some contact points don't match local data center");
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_provided_local_dc_and_warn_if_contact_points_dont_match() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2).build();
        DCAwareRoundRobinPolicy policy = (DCAwareRoundRobinPolicy)Mockito.spy((Object)DCAwareRoundRobinPolicy.builder().withLocalDc(ScassandraCluster.datacenter(3)).build());
        Cluster cluster = this.builder().addContactPoints(new InetAddress[]{sCluster.address(1, 1).getAddress(), sCluster.address(2, 1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).build();
        try {
            sCluster.init();
            Host host1 = TestUtils.findHost(cluster, 1);
            Host host3 = TestUtils.findHost(cluster, 3);
            cluster.init();
            ((DCAwareRoundRobinPolicy)Mockito.verify((Object)policy)).init((Cluster)Matchers.any(Cluster.class), (Collection)this.initHostsCaptor.capture());
            Assertions.assertThat((Iterable)((Iterable)this.initHostsCaptor.getValue())).containsOnly((Object[])new Host[]{host1, host3});
            Assertions.assertThat((String)policy.localDc).isEqualTo((Object)ScassandraCluster.datacenter(3));
            Assertions.assertThat((String)this.logs.get()).contains(new CharSequence[]{"Some contact points don't match local data center"});
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    @Test(groups={"unit"})
    public void should_construct_policy_that_allows_remote_failover() {
        DCAwareRoundRobinPolicy dcAwareRoundRobinPolicy = DCAwareRoundRobinPolicy.builder().withLocalDc("dc1").allowRemoteDCsForLocalConsistencyLevel().build();
        Assertions.assertThat((boolean)dcAwareRoundRobinPolicy.isUseRemoteHostsForFailover()).isTrue();
    }

    @Test(groups={"unit"})
    public void should_construct_policy_that_does_not_allows_remote_failover() {
        DCAwareRoundRobinPolicy dcAwareRoundRobinPolicy = DCAwareRoundRobinPolicy.builder().withLocalDc("dc1").build();
        Assertions.assertThat((boolean)dcAwareRoundRobinPolicy.isUseRemoteHostsForFailover()).isFalse();
    }
}

