/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.policies.DelegatingLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CCMConfig(createSession={false})
public class CloseableLoadBalancingPolicyTest
extends CCMTestsSupport {
    private CloseMonitoringPolicy policy;

    @Test(groups={"short"})
    public void should_be_invoked_at_shutdown() {
        try {
            this.cluster().connect();
            this.cluster().close();
        }
        finally {
            Assertions.assertThat((boolean)this.policy.wasClosed).isTrue();
        }
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        this.policy = new CloseMonitoringPolicy(Policies.defaultLoadBalancingPolicy());
        return Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withLoadBalancingPolicy((LoadBalancingPolicy)this.policy);
    }

    static class CloseMonitoringPolicy
    extends DelegatingLoadBalancingPolicy {
        volatile boolean wasClosed = false;

        public CloseMonitoringPolicy(LoadBalancingPolicy delegate) {
            super(delegate);
        }

        @Override
        public void close() {
            this.wasClosed = true;
        }
    }
}

