/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.ReadFailureException;
import com.datastax.driver.core.exceptions.WriteFailureException;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CCMConfig(config={"tombstone_failure_threshold:1000"}, numberOfNodes={2}, jvmArgs={"-Dcassandra.test.fail_writes_ks=ks_write_fail"})
@CassandraVersion(value="2.2.0")
public class ReadWriteFailureExceptionTest
extends CCMTestsSupport {
    @Test(groups={"long"})
    public void should_readFailure_on_tombstone_overwelmed() throws Throwable {
        this.session().execute("CREATE KEYSPACE ks_read_fail WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 1}");
        this.session().execute("CREATE TABLE ks_read_fail.foo(pk int, cc int, v int, primary key (pk, cc))");
        PreparedStatement prepared = this.session().prepare("INSERT INTO ks_read_fail.foo (pk, cc, v) VALUES (1, ?, null)");
        for (int v = 0; v < 2000; ++v) {
            BoundStatement bound = prepared.bind(new Object[]{v});
            this.session().execute((Statement)bound);
        }
        try {
            ResultSet result = this.session().execute("SELECT * FROM ks_read_fail.foo WHERE pk = 1");
            Assertions.fail((String)"A ReadFailureException should have been thrown here");
        }
        catch (ReadFailureException e) {
            if (this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion().compareTo((Enum)ProtocolVersion.V5) >= 0) {
                Assertions.assertThat((Map)e.getFailuresMap()).hasSize(1).containsValue((Object)1);
            }
            Assertions.assertThat((Map)e.getFailuresMap()).isEmpty();
        }
    }

    @Test(groups={"long"})
    public void should_writeFailure_on_error() throws Throwable {
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "ks_write_fail", 1));
        this.session().execute("CREATE TABLE ks_write_fail.foo(pk int, cc int, v int, primary key (pk, cc))");
        try {
            this.session().execute("INSERT INTO ks_write_fail.foo (pk, cc, v) VALUES (1, 1, null)");
            Assertions.fail((String)"A WriteFailureException should have been thrown here");
        }
        catch (WriteFailureException e) {
            if (this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion().compareTo((Enum)ProtocolVersion.V5) >= 0) {
                Assertions.assertThat((Map)e.getFailuresMap()).hasSize(1).containsValue((Object)0);
            }
            Assertions.assertThat((Map)e.getFailuresMap()).isEmpty();
        }
    }
}

