/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.ConnectionException;
import java.net.InetSocketAddress;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConnectionExceptionTest {
    @Test(groups={"unit"})
    public void getHost_should_return_null_if_address_is_null() {
        Assert.assertNull((Object)new ConnectionException(null, "Test message").getHost());
    }

    @Test(groups={"unit"})
    public void getMessage_should_return_message_if_address_is_null() {
        Assert.assertEquals((String)new ConnectionException(null, "Test message").getMessage(), (String)"Test message");
    }

    @Test(groups={"unit"})
    public void getMessage_should_return_message_if_address_is_unresolved() {
        Assert.assertEquals((String)new ConnectionException(InetSocketAddress.createUnresolved("127.0.0.1", 9042), "Test message").getMessage(), (String)"[127.0.0.1:9042] Test message");
    }

    @Test(groups={"unit"})
    public void getMessage_should_return_message_if_address_is_resolved() {
        Assert.assertEquals((String)new ConnectionException(new InetSocketAddress("127.0.0.1", 9042), "Test message").getMessage(), (String)"[/127.0.0.1:9042] Test message");
    }
}

