/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.utils.DseVersion;
import java.util.UUID;
import org.testng.annotations.Test;

@DseVersion(value="6.7.0")
@CCMConfig
public class VirtualTableMetadataTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_parse_virtual_metadata() {
        KeyspaceMetadata km = this.session().getCluster().getMetadata().getKeyspace("system_views");
        Assertions.assertThat((km.getTables().size() >= 2 ? 1 : 0) != 0);
        Assertions.assertThat((boolean)km.isVirtual()).isTrue();
        Assertions.assertThat((boolean)km.isDurableWrites()).isFalse();
        Assertions.assertThat((String)km.getName()).isEqualTo((Object)"system_views");
        Assertions.assertThat((int)km.getUserTypes().size()).isEqualTo(0);
        Assertions.assertThat((int)km.getFunctions().size()).isEqualTo(0);
        Assertions.assertThat((int)km.getMaterializedViews().size()).isEqualTo(0);
        Assertions.assertThat((int)km.getAggregates().size()).isEqualTo(0);
        Assertions.assertThat((String)km.asCQLQuery()).isEqualTo((Object)"/* VIRTUAL KEYSPACE system_views WITH REPLICATION = { 'class' : 'null' } AND DURABLE_WRITES = false;*/");
        TableMetadata tm = km.getTable("sstable_tasks");
        Assertions.assertThat(tm).isNotNull();
        Assertions.assertThat((String)tm.getName()).isEqualTo((Object)"sstable_tasks");
        Assertions.assertThat((boolean)tm.isVirtual()).isTrue();
        Assertions.assertThat((int)tm.getColumns().size()).isEqualTo(7);
        Assertions.assertThat((int)tm.getPartitionKey().size()).isEqualTo(1);
        Assertions.assertThat((String)((ColumnMetadata)tm.getPartitionKey().get(0)).getName()).isEqualTo((Object)"keyspace_name");
        Assertions.assertThat((int)tm.getClusteringColumns().size()).isEqualTo(2);
        Assertions.assertThat((String)((ColumnMetadata)tm.getClusteringColumns().get(0)).getName()).isEqualTo((Object)"table_name");
        Assertions.assertThat((String)((ColumnMetadata)tm.getClusteringColumns().get(1)).getName()).isEqualTo((Object)"task_id");
        Assertions.assertThat((int)tm.getIndexes().size()).isEqualTo(0);
        Assertions.assertThat((int)tm.getViews().size()).isEqualTo(0);
        Assertions.assertThat((int)tm.getClusteringColumns().size()).isEqualTo(2);
        Assertions.assertThat((int)tm.getClusteringOrder().size()).isEqualTo(2);
        Assertions.assertThat((Comparable)tm.getId()).isEqualTo((Object)new UUID(0L, 0L));
        Assertions.assertThat((Object)tm.getOptions()).isNull();
        Assertions.assertThat(tm.getKeyspace()).isEqualTo(km);
        Assertions.assertThat((String)tm.exportAsString()).isEqualTo((Object)"/* VIRTUAL TABLE system_views.sstable_tasks (\n    keyspace_name text,\n    table_name text,\n    task_id uuid,\n    kind text,\n    progress bigint,\n    total bigint,\n    unit text,\n    PRIMARY KEY (keyspace_name, table_name, task_id)\n)  */");
        Assertions.assertThat((String)tm.asCQLQuery()).isEqualTo((Object)"/* VIRTUAL TABLE system_views.sstable_tasks (keyspace_name text, table_name text, task_id uuid, kind text, progress bigint, total bigint, unit text, PRIMARY KEY (keyspace_name, table_name, task_id))  */");
        ColumnMetadata cm = tm.getColumn("progress");
        Assertions.assertThat(cm).isNotNull();
        Assertions.assertThat((Object)cm.getParent()).isEqualTo((Object)tm);
        Assertions.assertThat(cm.getType()).isEqualTo(DataType.bigint());
        Assertions.assertThat((String)cm.getName()).isEqualTo((Object)"progress");
    }
}

