/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Duration;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.PrimitiveTypeSamples;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class UserTypesTest
extends CCMTestsSupport {
    private List<DataType> DATA_TYPE_PRIMITIVES;
    private Map<DataType, Object> samples;
    private static final List<DataType.Name> DATA_TYPE_NON_PRIMITIVE_NAMES = new ArrayList<DataType.Name>(EnumSet.of(DataType.Name.LIST, DataType.Name.SET, DataType.Name.MAP, DataType.Name.TUPLE));
    private final Callable<Boolean> userTableExists = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return UserTypesTest.this.cluster().getMetadata().getKeyspace(UserTypesTest.this.keyspace).getTable("user") != null;
        }
    };

    @Override
    public void onTestContextInitialized() {
        ProtocolVersion protocolVersion = this.ccm().getProtocolVersion();
        this.DATA_TYPE_PRIMITIVES = new ArrayList<DataType>(TestUtils.allPrimitiveTypes(protocolVersion));
        this.DATA_TYPE_PRIMITIVES.remove(DataType.counter());
        this.samples = PrimitiveTypeSamples.samples(protocolVersion);
        String type1 = "CREATE TYPE phone (alias text, number text)";
        String type2 = "CREATE TYPE \"\"\"User Address\"\"\" (street text, \"ZIP\"\"\" int, phones set<frozen<phone>>)";
        String type3 = "CREATE TYPE type_for_frozen_test(i int)";
        String table = "CREATE TABLE user (id int PRIMARY KEY, addr frozen<\"\"\"User Address\"\"\">)";
        this.execute(type1, type2, type3, table);
        ConditionChecker.check().that(this.userTableExists).before(5L, TimeUnit.MINUTES).becomesTrue();
    }

    @Test(groups={"short"})
    public void should_store_and_retrieve_with_prepared_statements() throws Exception {
        int userId = 0;
        PreparedStatement ins = this.session().prepare("INSERT INTO user(id, addr) VALUES (?, ?)");
        PreparedStatement sel = this.session().prepare("SELECT * FROM user WHERE id=?");
        UserType addrDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType(Metadata.quote((String)"\"User Address\""));
        UserType phoneDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("phone");
        UDTValue phone1 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "home")).setString("number", "0123548790");
        UDTValue phone2 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "work")).setString("number", "0698265251");
        UDTValue addr = (UDTValue)((UDTValue)((UDTValue)addrDef.newValue().setString("street", "1600 Pennsylvania Ave NW")).setInt(Metadata.quote((String)"ZIP\""), 20500)).setSet("phones", (Set)ImmutableSet.of((Object)phone1, (Object)phone2));
        this.session().execute((Statement)ins.bind(new Object[]{userId, addr}));
        Row r = this.session().execute((Statement)sel.bind(new Object[]{userId})).one();
        Assertions.assertThat((int)r.getInt("id")).isEqualTo(0);
    }

    @Test(groups={"short"})
    public void should_store_and_retrieve_with_simple_statements() throws Exception {
        int userId = 1;
        UserType addrDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType(Metadata.quote((String)"\"User Address\""));
        UserType phoneDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("phone");
        UDTValue phone1 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "home")).setString("number", "0123548790");
        UDTValue phone2 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "work")).setString("number", "0698265251");
        UDTValue addr = (UDTValue)((UDTValue)((UDTValue)addrDef.newValue().setString("street", "1600 Pennsylvania Ave NW")).setInt(Metadata.quote((String)"ZIP\""), 20500)).setSet("phones", (Set)ImmutableSet.of((Object)phone1, (Object)phone2));
        this.session().execute("INSERT INTO user(id, addr) VALUES (?, ?)", new Object[]{userId, addr});
        Row r = this.session().execute("SELECT * FROM user WHERE id=?", new Object[]{userId}).one();
        Assertions.assertThat((int)r.getInt("id")).isEqualTo(userId);
        Assertions.assertThat((Object)r.getUDTValue("addr")).isEqualTo((Object)addr);
    }

    @Test(groups={"short"})
    public void should_store_type_definitions_in_their_keyspace() throws Exception {
        KeyspaceMetadata thisKeyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        Assertions.assertThat(thisKeyspace.getUserType("address1")).isNull();
        Assertions.assertThat(thisKeyspace.getUserType("phone1")).isNull();
        Assertions.assertThat(thisKeyspace.getUserType(Metadata.quote((String)"\"User Address\""))).isNotNull();
        Assertions.assertThat(thisKeyspace.getUserType("phone")).isNotNull();
        String otherKeyspaceName = this.keyspace + "_nonEx";
        this.session().execute("CREATE KEYSPACE " + otherKeyspaceName + " WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
        KeyspaceMetadata otherKeyspace = this.cluster().getMetadata().getKeyspace(otherKeyspaceName);
        Assertions.assertThat(otherKeyspace.getUserType(Metadata.quote((String)"\"User Address\""))).isNull();
        Assertions.assertThat(otherKeyspace.getUserType("phone")).isNull();
    }

    @Test(groups={"short"})
    public void should_handle_UDT_with_many_fields() throws Exception {
        int MAX_TEST_LENGTH = 1024;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < MAX_TEST_LENGTH; ++i) {
            sb.append(String.format("v_%s int", i));
            if (i + 1 >= MAX_TEST_LENGTH) continue;
            sb.append(",");
        }
        this.session().execute(String.format("CREATE TYPE lengthy_udt (%s)", sb.toString()));
        this.session().execute("CREATE TABLE lengthy_udt_table (k int PRIMARY KEY, v frozen<lengthy_udt>)");
        UserType udtDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("lengthy_udt");
        for (int i : Arrays.asList(0, 1, 2, 3, MAX_TEST_LENGTH)) {
            UDTValue createdUDT = udtDef.newValue();
            for (int j = 0; j < i; ++j) {
                createdUDT.setInt(j, j);
            }
            this.session().execute("INSERT INTO lengthy_udt_table (k, v) VALUES (0, ?)", new Object[]{createdUDT});
            UDTValue r = this.session().execute("SELECT v FROM lengthy_udt_table WHERE k=0").one().getUDTValue("v");
            Assertions.assertThat((String)r.toString()).isEqualTo((Object)createdUDT.toString());
        }
    }

    @Test(groups={"short"})
    public void should_store_and_retrieve_UDT_containing_any_primitive_type() throws Exception {
        ArrayList<String> alpha_type_list = new ArrayList<String>();
        int startIndex = 97;
        for (int i = 0; i < this.DATA_TYPE_PRIMITIVES.size(); ++i) {
            alpha_type_list.add(String.format("%s %s", Character.toString((char)(startIndex + i)), this.DATA_TYPE_PRIMITIVES.get(i).getName()));
        }
        this.session().execute(String.format("CREATE TYPE alldatatypes (%s)", Joiner.on((char)',').join(alpha_type_list)));
        this.session().execute("CREATE TABLE alldatatypes_table (a int PRIMARY KEY, b frozen<alldatatypes>)");
        UserType alldatatypesDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("alldatatypes");
        UDTValue alldatatypes = alldatatypesDef.newValue();
        block23: for (int i = 0; i < this.DATA_TYPE_PRIMITIVES.size(); ++i) {
            DataType dataType = this.DATA_TYPE_PRIMITIVES.get(i);
            String index = Character.toString((char)(startIndex + i));
            Object sampleData = this.samples.get(dataType);
            switch (dataType.getName()) {
                case ASCII: {
                    alldatatypes.setString(index, (String)sampleData);
                    continue block23;
                }
                case BIGINT: {
                    alldatatypes.setLong(index, ((Long)sampleData).longValue());
                    continue block23;
                }
                case BLOB: {
                    alldatatypes.setBytes(index, (ByteBuffer)sampleData);
                    continue block23;
                }
                case BOOLEAN: {
                    alldatatypes.setBool(index, ((Boolean)sampleData).booleanValue());
                    continue block23;
                }
                case DECIMAL: {
                    alldatatypes.setDecimal(index, (BigDecimal)sampleData);
                    continue block23;
                }
                case DOUBLE: {
                    alldatatypes.setDouble(index, ((Double)sampleData).doubleValue());
                    continue block23;
                }
                case DURATION: {
                    alldatatypes.set(index, (Object)Duration.from((String)sampleData.toString()), Duration.class);
                    continue block23;
                }
                case FLOAT: {
                    alldatatypes.setFloat(index, ((Float)sampleData).floatValue());
                    continue block23;
                }
                case INET: {
                    alldatatypes.setInet(index, (InetAddress)sampleData);
                    continue block23;
                }
                case TINYINT: {
                    alldatatypes.setByte(index, ((Byte)sampleData).byteValue());
                    continue block23;
                }
                case SMALLINT: {
                    alldatatypes.setShort(index, ((Short)sampleData).shortValue());
                    continue block23;
                }
                case INT: {
                    alldatatypes.setInt(index, ((Integer)sampleData).intValue());
                    continue block23;
                }
                case TEXT: {
                    alldatatypes.setString(index, (String)sampleData);
                    continue block23;
                }
                case TIMESTAMP: {
                    alldatatypes.setTimestamp(index, (Date)sampleData);
                    continue block23;
                }
                case DATE: {
                    alldatatypes.setDate(index, (LocalDate)sampleData);
                    continue block23;
                }
                case TIME: {
                    alldatatypes.setTime(index, ((Long)sampleData).longValue());
                    continue block23;
                }
                case TIMEUUID: {
                    alldatatypes.setUUID(index, (UUID)sampleData);
                    continue block23;
                }
                case UUID: {
                    alldatatypes.setUUID(index, (UUID)sampleData);
                    continue block23;
                }
                case VARCHAR: {
                    alldatatypes.setString(index, (String)sampleData);
                    continue block23;
                }
                case VARINT: {
                    alldatatypes.setVarint(index, (BigInteger)sampleData);
                }
            }
        }
        PreparedStatement ins = this.session().prepare("INSERT INTO alldatatypes_table (a, b) VALUES (?, ?)");
        this.session().execute((Statement)ins.bind(new Object[]{0, alldatatypes}));
        ResultSet rs = this.session().execute("SELECT * FROM alldatatypes_table");
        List rows = rs.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Row row = (Row)rows.get(0);
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(0);
        Assertions.assertThat((Object)row.getUDTValue("b")).isEqualTo((Object)alldatatypes);
    }

    @Test(groups={"short"})
    public void should_store_and_retrieve_UDT_containing_collections_and_tuples() throws Exception {
        this.DATA_TYPE_PRIMITIVES.remove(DataType.counter());
        this.DATA_TYPE_PRIMITIVES.remove(DataType.duration());
        ArrayList<String> alpha_type_list = new ArrayList<String>();
        int startIndex = 97;
        for (int i = 0; i < DATA_TYPE_NON_PRIMITIVE_NAMES.size(); ++i) {
            for (int j = 0; j < this.DATA_TYPE_PRIMITIVES.size(); ++j) {
                String typeString = DATA_TYPE_NON_PRIMITIVE_NAMES.get(i) == DataType.Name.MAP ? String.format("%s_%s %s<%s, %s>", Character.toString((char)(startIndex + i)), Character.toString((char)(startIndex + j)), DATA_TYPE_NON_PRIMITIVE_NAMES.get(i), this.DATA_TYPE_PRIMITIVES.get(j).getName(), this.DATA_TYPE_PRIMITIVES.get(j).getName()) : (DATA_TYPE_NON_PRIMITIVE_NAMES.get(i) == DataType.Name.TUPLE ? String.format("%s_%s frozen<%s<%s>>", Character.toString((char)(startIndex + i)), Character.toString((char)(startIndex + j)), DATA_TYPE_NON_PRIMITIVE_NAMES.get(i), this.DATA_TYPE_PRIMITIVES.get(j).getName()) : String.format("%s_%s %s<%s>", Character.toString((char)(startIndex + i)), Character.toString((char)(startIndex + j)), DATA_TYPE_NON_PRIMITIVE_NAMES.get(i), this.DATA_TYPE_PRIMITIVES.get(j).getName()));
                alpha_type_list.add(typeString);
            }
        }
        this.session().execute(String.format("CREATE TYPE allcollectiontypes (%s)", Joiner.on((char)',').join(alpha_type_list)));
        this.session().execute("CREATE TABLE allcollectiontypes_table (a int PRIMARY KEY, b frozen<allcollectiontypes>)");
        UserType allcollectiontypesDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("allcollectiontypes");
        UDTValue allcollectiontypes = allcollectiontypesDef.newValue();
        for (int i = 0; i < DATA_TYPE_NON_PRIMITIVE_NAMES.size(); ++i) {
            block9: for (int j = 0; j < this.DATA_TYPE_PRIMITIVES.size(); ++j) {
                DataType.Name name = DATA_TYPE_NON_PRIMITIVE_NAMES.get(i);
                DataType dataType = this.DATA_TYPE_PRIMITIVES.get(j);
                String index = Character.toString((char)(startIndex + i)) + "_" + Character.toString((char)(startIndex + j));
                Object sampleElement = this.samples.get(dataType);
                switch (name) {
                    case LIST: {
                        allcollectiontypes.setList(index, (List)Lists.newArrayList((Object[])new Object[]{sampleElement}));
                        continue block9;
                    }
                    case SET: {
                        allcollectiontypes.setSet(index, (Set)Sets.newHashSet((Object[])new Object[]{sampleElement}));
                        continue block9;
                    }
                    case MAP: {
                        allcollectiontypes.setMap(index, (Map)ImmutableMap.of((Object)sampleElement, (Object)sampleElement));
                        continue block9;
                    }
                    case TUPLE: {
                        allcollectiontypes.setTupleValue(index, this.cluster().getMetadata().newTupleType(new DataType[]{dataType}).newValue(new Object[]{sampleElement}));
                    }
                }
            }
        }
        PreparedStatement ins = this.session().prepare("INSERT INTO allcollectiontypes_table (a, b) VALUES (?, ?)");
        this.session().execute((Statement)ins.bind(new Object[]{0, allcollectiontypes}));
        ResultSet rs = this.session().execute("SELECT * FROM allcollectiontypes_table");
        List rows = rs.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Row row = (Row)rows.get(0);
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(0);
        Assertions.assertThat((Object)row.getUDTValue("b")).isEqualTo((Object)allcollectiontypes);
    }

    @Test(groups={"short"})
    public void should_save_and_retrieve_nested_UDTs() throws Exception {
        int MAX_NESTING_DEPTH = 4;
        this.session().execute("CREATE TYPE depth_0 (age int, name text)");
        for (int i = 1; i <= 4; ++i) {
            this.session().execute(String.format("CREATE TYPE depth_%s (value frozen<depth_%s>)", String.valueOf(i), String.valueOf(i - 1)));
        }
        this.session().execute(String.format("CREATE TABLE nested_udt_table (a int PRIMARY KEY, b frozen<depth_0>, c frozen<depth_1>, d frozen<depth_2>, e frozen<depth_3>,f frozen<depth_%s>)", 4));
        KeyspaceMetadata keyspaceMetadata = this.cluster().getMetadata().getKeyspace(this.keyspace);
        UserType depthZeroDef = keyspaceMetadata.getUserType("depth_0");
        UDTValue depthZero = (UDTValue)((UDTValue)depthZeroDef.newValue().setInt("age", 42)).setString("name", "Bob");
        UserType depthOneDef = keyspaceMetadata.getUserType("depth_1");
        UDTValue depthOne = (UDTValue)depthOneDef.newValue().setUDTValue("value", depthZero);
        UserType depthTwoDef = keyspaceMetadata.getUserType("depth_2");
        UDTValue depthTwo = (UDTValue)depthTwoDef.newValue().setUDTValue("value", depthOne);
        UserType depthThreeDef = keyspaceMetadata.getUserType("depth_3");
        UDTValue depthThree = (UDTValue)depthThreeDef.newValue().setUDTValue("value", depthTwo);
        UserType depthFourDef = keyspaceMetadata.getUserType("depth_4");
        UDTValue depthFour = (UDTValue)depthFourDef.newValue().setUDTValue("value", depthThree);
        PreparedStatement ins = this.session().prepare("INSERT INTO nested_udt_table (a, b, c, d, e, f) VALUES (?, ?, ?, ?, ?, ?)");
        this.session().execute((Statement)ins.bind(new Object[]{0, depthZero, depthOne, depthTwo, depthThree, depthFour}));
        ResultSet rs = this.session().execute("SELECT * FROM nested_udt_table");
        List rows = rs.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Row row = (Row)rows.get(0);
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(0);
        Assertions.assertThat((Object)row.getUDTValue("b")).isEqualTo((Object)depthZero);
        Assertions.assertThat((Object)row.getUDTValue("c")).isEqualTo((Object)depthOne);
        Assertions.assertThat((Object)row.getUDTValue("d")).isEqualTo((Object)depthTwo);
        Assertions.assertThat((Object)row.getUDTValue("e")).isEqualTo((Object)depthThree);
        Assertions.assertThat((Object)row.getUDTValue("f")).isEqualTo((Object)depthFour);
    }

    @Test(groups={"short"})
    public void should_save_and_retrieve_UDTs_with_null_values() throws Exception {
        this.session().execute("CREATE TYPE user_null_values (a text, b int, c uuid, d blob)");
        this.session().execute("CREATE TABLE null_values_table (a int PRIMARY KEY, b frozen<user_null_values>)");
        UserType userTypeDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("user_null_values");
        UDTValue userType = (UDTValue)((UDTValue)((UDTValue)((UDTValue)userTypeDef.newValue().setString("a", null)).setInt("b", 0)).setUUID("c", null)).setBytes("d", null);
        PreparedStatement ins = this.session().prepare("INSERT INTO null_values_table (a, b) VALUES (?, ?)");
        this.session().execute((Statement)ins.bind(new Object[]{0, userType}));
        ResultSet rs = this.session().execute("SELECT * FROM null_values_table");
        List rows = rs.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Row row = (Row)rows.get(0);
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(0);
        Assertions.assertThat((Object)row.getUDTValue("b")).isEqualTo((Object)userType);
        userType = (UDTValue)((UDTValue)((UDTValue)((UDTValue)userTypeDef.newValue().setString("a", "")).setInt("b", 0)).setUUID("c", null)).setBytes("d", ByteBuffer.allocate(0));
        this.session().execute((Statement)ins.bind(new Object[]{0, userType}));
        rs = this.session().execute("SELECT * FROM null_values_table");
        rows = rs.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        row = (Row)rows.get(0);
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(0);
        Assertions.assertThat((Object)row.getUDTValue("b")).isEqualTo((Object)userType);
    }

    @Test(groups={"short"})
    public void should_save_and_retrieve_UDTs_with_null_collections() throws Exception {
        this.session().execute("CREATE TYPE user_null_collections (a List<text>, b Set<text>, c Map<text, text>, d frozen<Tuple<text>>)");
        this.session().execute("CREATE TABLE null_collections_table (a int PRIMARY KEY, b frozen<user_null_collections>)");
        PreparedStatement ins = this.session().prepare("INSERT INTO null_collections_table (a, b) VALUES (0, { a: ?, b: ?, c: ?, d: ? })");
        this.session().execute((Statement)ins.bind().setList(0, null).setSet(1, null).setMap(2, null).setTupleValue(3, null));
        ResultSet rs = this.session().execute("SELECT * FROM null_collections_table");
        List rows = rs.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Row row = (Row)rows.get(0);
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(0);
        UserType userTypeDef = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("user_null_collections");
        UDTValue userType = (UDTValue)((UDTValue)((UDTValue)((UDTValue)userTypeDef.newValue().setList("a", null)).setSet("b", null)).setMap("c", null)).setTupleValue("d", null);
        Assertions.assertThat((Object)row.getUDTValue("b")).isEqualTo((Object)userType);
        ins = this.session().prepare("INSERT INTO null_collections_table (a, b) VALUES (1, { a: ? })");
        this.session().execute((Statement)ins.bind().setList(0, new ArrayList()));
        rs = this.session().execute("SELECT * FROM null_collections_table");
        rows = rs.all();
        Assertions.assertThat((int)rows.size()).isEqualTo(2);
        row = (Row)rows.get(0);
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(1);
        userType = (UDTValue)userTypeDef.newValue().setList(0, new ArrayList());
        Assertions.assertThat((Object)row.getUDTValue("b")).isEqualTo((Object)userType);
    }

    @Test(groups={"short"})
    public void should_indicate_user_type_is_frozen() {
        this.session().execute("CREATE TABLE frozen_table(k int primary key, v frozen<type_for_frozen_test>)");
        KeyspaceMetadata keyspaceMetadata = this.cluster().getMetadata().getKeyspace(this.keyspace);
        Assertions.assertThat(keyspaceMetadata.getUserType("type_for_frozen_test")).isNotFrozen();
        DataType userType = keyspaceMetadata.getTable("frozen_table").getColumn("v").getType();
        Assertions.assertThat(userType).isFrozen();
        Assertions.assertThat((String)userType.toString()).isEqualTo((Object)("frozen<" + this.keyspace + ".type_for_frozen_test>"));
        ResultSet rs = this.session().execute("SELECT v FROM frozen_table WHERE k = 1");
        Assertions.assertThat(rs.getColumnDefinitions().getType(0)).isNotFrozen();
        PreparedStatement pst = this.session().prepare("SELECT v FROM frozen_table WHERE k = ?");
        Assertions.assertThat(pst.getVariables().getType(0)).isNotFrozen();
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.6", description="Non-frozen UDTs were introduced in C* 3.6")
    public void should_indicate_user_type_is_not_frozen() {
        this.session().execute("CREATE TABLE not_frozen_table(k int primary key, v type_for_frozen_test)");
        KeyspaceMetadata keyspaceMetadata = this.cluster().getMetadata().getKeyspace(this.keyspace);
        Assertions.assertThat(keyspaceMetadata.getUserType("type_for_frozen_test")).isNotFrozen();
        DataType userType = keyspaceMetadata.getTable("not_frozen_table").getColumn("v").getType();
        Assertions.assertThat(userType).isNotFrozen();
        Assertions.assertThat((String)userType.toString()).isEqualTo((Object)(this.keyspace + ".type_for_frozen_test"));
        ResultSet rs = this.session().execute("SELECT v FROM not_frozen_table WHERE k = 1");
        Assertions.assertThat(rs.getColumnDefinitions().getType(0)).isNotFrozen();
        PreparedStatement pst = this.session().prepare("SELECT v FROM not_frozen_table WHERE k = ?");
        Assertions.assertThat(pst.getVariables().getType(0)).isNotFrozen();
    }

    @Test(groups={"short"})
    public void should_handle_udt_named_like_a_collection() {
        this.execute("CREATE TYPE tuple(a text)", "CREATE TYPE list(a text)", "CREATE TYPE frozen(a text)", "CREATE TYPE udt(tuple frozen<tuple>, frozen frozen<frozen>, m map<frozen<list>,frozen<frozen>>)");
        UserType udt = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("udt");
        Assertions.assertThat(udt.getFieldType("tuple")).isInstanceOf(UserType.class);
        Assertions.assertThat(udt.getFieldType("frozen")).isInstanceOf(UserType.class);
        Assertions.assertThat((DataType)udt.getFieldType("m").getTypeArguments().get(0)).isInstanceOf(UserType.class);
        Assertions.assertThat((DataType)udt.getFieldType("m").getTypeArguments().get(1)).isInstanceOf(UserType.class);
    }
}

