/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.MappingCodec;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class TypeCodecTupleIntegrationTest
extends CCMTestsSupport {
    private final String insertQuery = "INSERT INTO users (id, name, location) VALUES (?, ?, ?)";
    private final String selectQuery = "SELECT id, name, location FROM users WHERE id = ?";
    private final UUID uuid = UUID.randomUUID();
    private TupleType locationType;
    private TupleValue locationValue;
    private TupleValue partialLocationValueInserted;
    private Location location;
    private Location partialLocation;
    private TupleValue partialLocationValueRetrieved;

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE IF NOT EXISTS \"users\" (id uuid PRIMARY KEY, name text, location frozen<tuple<float,float>>)");
    }

    @Test(groups={"short"})
    public void should_handle_tuples_with_default_codecs() {
        this.setUpTupleTypes(this.cluster());
        this.session().execute("INSERT INTO users (id, name, location) VALUES (?, ?, ?)", new Object[]{this.uuid, "John Doe", this.locationValue});
        ResultSet rows = this.session().execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        Row row = rows.one();
        this.assertRow(row);
        PreparedStatement ps = this.session().prepare("INSERT INTO users (id, name, location) VALUES (?, ?, ?)");
        this.session().execute((Statement)ps.bind(new Object[]{this.uuid, "John Doe", this.locationValue}));
        rows = this.session().execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        row = rows.one();
        this.assertRow(row);
        this.session().execute((Statement)ps.bind().setUUID(0, this.uuid).setString(1, "John Doe").setTupleValue("location", this.locationValue));
        rows = this.session().execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_handle_partial_tuples_with_default_codecs() {
        this.setUpTupleTypes(this.cluster());
        this.session().execute("INSERT INTO users (id, name, location) VALUES (?, ?, ?)", new Object[]{this.uuid, "John Doe", this.partialLocationValueInserted});
        ResultSet rows = this.session().execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        Row row = rows.one();
        this.assertPartialRow(row);
        PreparedStatement ps = this.session().prepare("INSERT INTO users (id, name, location) VALUES (?, ?, ?)");
        this.session().execute((Statement)ps.bind(new Object[]{this.uuid, "John Doe", this.partialLocationValueInserted}));
        rows = this.session().execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        row = rows.one();
        this.assertPartialRow(row);
        this.session().execute((Statement)ps.bind().setUUID(0, this.uuid).setString(1, "John Doe").setTupleValue("location", this.partialLocationValueInserted));
        rows = this.session().execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        row = rows.one();
        this.assertPartialRow(row);
    }

    @Test(groups={"short"})
    public void should_handle_tuples_with_custom_codecs() {
        CodecRegistry codecRegistry = new CodecRegistry();
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withCodecRegistry(codecRegistry).build());
        Session session = cluster.connect(this.keyspace);
        this.setUpTupleTypes(cluster);
        codecRegistry.register((TypeCodec)new LocationCodec((TypeCodec<TupleValue>)TypeCodec.tuple((TupleType)this.locationType)));
        session.execute("INSERT INTO users (id, name, location) VALUES (?, ?, ?)", new Object[]{this.uuid, "John Doe", this.locationValue});
        ResultSet rows = session.execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        Row row = rows.one();
        Assertions.assertThat((Comparable)row.getUUID(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Comparable)((Comparable)row.get(0, UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((String)row.getString(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((String)((String)row.get(1, String.class))).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getTupleValue(2)).isEqualTo((Object)this.locationValue);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)this.location);
        Assertions.assertThat((Object)row.get(2, TupleValue.class)).isEqualTo((Object)this.locationValue);
        Assertions.assertThat((Object)row.get(2, Location.class)).isEqualTo((Object)this.location);
    }

    @Test(groups={"short"})
    public void should_handle_partial_tuples_with_custom_codecs() {
        CodecRegistry codecRegistry = new CodecRegistry();
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withCodecRegistry(codecRegistry).build());
        Session session = cluster.connect(this.keyspace);
        this.setUpTupleTypes(cluster);
        codecRegistry.register((TypeCodec)new LocationCodec((TypeCodec<TupleValue>)TypeCodec.tuple((TupleType)this.locationType)));
        session.execute("INSERT INTO users (id, name, location) VALUES (?, ?, ?)", new Object[]{this.uuid, "John Doe", this.partialLocationValueInserted});
        ResultSet rows = session.execute("SELECT id, name, location FROM users WHERE id = ?", new Object[]{this.uuid});
        Row row = rows.one();
        Assertions.assertThat((Comparable)row.getUUID(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Comparable)((Comparable)row.get(0, UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((String)row.getString(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((String)((String)row.get(1, String.class))).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getTupleValue(2)).isEqualTo((Object)this.locationType.newValue(new Object[]{Float.valueOf(37.387222f), null}));
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)this.partialLocation);
        Assertions.assertThat((Object)row.get(2, TupleValue.class)).isEqualTo((Object)this.locationType.newValue(new Object[]{Float.valueOf(37.387222f), null}));
        Assertions.assertThat((Object)row.get(2, Location.class)).isEqualTo((Object)this.partialLocation);
    }

    private void assertRow(Row row) {
        Assertions.assertThat((Comparable)row.getUUID(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Comparable)((Comparable)row.get(0, UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((String)row.getString(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((String)((String)row.get(1, String.class))).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getTupleValue(2)).isEqualTo((Object)this.locationValue);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)this.locationValue);
        Assertions.assertThat((Object)row.get(2, TupleValue.class)).isEqualTo((Object)this.locationValue);
    }

    private void assertPartialRow(Row row) {
        Assertions.assertThat((Comparable)row.getUUID(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Comparable)((Comparable)row.get(0, UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((String)row.getString(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((String)((String)row.get(1, String.class))).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getTupleValue(2)).isEqualTo((Object)this.partialLocationValueRetrieved);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)this.partialLocationValueRetrieved);
        Assertions.assertThat((Object)row.get(2, TupleValue.class)).isEqualTo((Object)this.partialLocationValueRetrieved);
    }

    private void setUpTupleTypes(Cluster cluster) {
        this.locationType = cluster.getMetadata().newTupleType(new DataType[]{DataType.cfloat(), DataType.cfloat()});
        this.locationValue = (TupleValue)((TupleValue)this.locationType.newValue().setFloat(0, 37.387222f)).setFloat(1, -121.97338f);
        this.partialLocationValueInserted = (TupleValue)cluster.getMetadata().newTupleType(new DataType[]{DataType.cfloat()}).newValue().setFloat(0, 37.387222f);
        this.partialLocationValueRetrieved = this.locationType.newValue(new Object[]{Float.valueOf(37.387222f), null});
        this.location = new Location(37.387222f, -121.97338f);
        this.partialLocation = new Location(37.387222f, 0.0f);
    }

    static class Location {
        float latitude;
        float longitude;

        public Location(float latitude, float longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return Float.compare(location.latitude, this.latitude) == 0 && Float.compare(location.longitude, this.longitude) == 0;
        }

        public int hashCode() {
            int result = this.latitude != 0.0f ? Float.floatToIntBits(this.latitude) : 0;
            result = 31 * result + (this.longitude != 0.0f ? Float.floatToIntBits(this.longitude) : 0);
            return result;
        }

        public String toString() {
            return "[" + this.latitude + ", " + this.longitude + "]";
        }
    }

    static class LocationCodec
    extends MappingCodec<Location, TupleValue> {
        private final TupleType tupleType;

        public LocationCodec(TypeCodec<TupleValue> innerCodec) {
            super(innerCodec, Location.class);
            this.tupleType = (TupleType)innerCodec.getCqlType();
        }

        @Override
        protected Location deserialize(TupleValue value) {
            return value == null ? null : new Location(value.getFloat(0), value.getFloat(1));
        }

        @Override
        protected TupleValue serialize(Location value) {
            return value == null ? null : (TupleValue)((TupleValue)this.tupleType.newValue().setFloat(0, value.latitude)).setFloat(1, value.longitude);
        }
    }
}

