/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TypeCodecOverlappingJavaTypeIntegrationTest
extends CCMTestsSupport {
    private static final String insertQuery = "INSERT INTO \"myTable\" (c_int, l_int, c_text) VALUES (?, ?, ?)";
    private static final String selectQuery = "SELECT c_int, l_int, c_text FROM \"myTable\" WHERE c_int = ?";

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE \"myTable\" (c_int int PRIMARY KEY, l_int list<int>, c_text text )");
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withCodecRegistry(new CodecRegistry().register((TypeCodec)new IntToStringCodec()));
    }

    @Test(groups={"short"})
    public void should_use_custom_codecs_with_prepared_statements() {
        PreparedStatement ps = this.session().prepare(insertQuery);
        this.session().execute((Statement)ps.bind().setInt(0, 42).setList(1, (List)Lists.newArrayList((Object[])new Integer[]{42})).setString(2, "42"));
        this.session().execute((Statement)ps.bind().setString(0, "42").setList(1, (List)Lists.newArrayList((Object[])new String[]{"42"}), String.class).setString(2, "42"));
        ps = this.session().prepare(selectQuery);
        this.assertRow(this.session().execute((Statement)ps.bind().setInt(0, 42)).one());
        this.assertRow(this.session().execute((Statement)ps.bind().setString(0, "42")).one());
    }

    private void assertRow(Row row) {
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(42);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)42);
        Assertions.assertThat((Integer)((Integer)row.get(0, Integer.class))).isEqualTo(42);
        Assertions.assertThat((String)((String)row.get(0, String.class))).isEqualTo((Object)"42");
        Assertions.assertThat((List)row.getList(1, Integer.class)).isEqualTo((Object)Lists.newArrayList((Object[])new Integer[]{42}));
        Assertions.assertThat((List)row.getList(1, String.class)).isEqualTo((Object)Lists.newArrayList((Object[])new String[]{"42"}));
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)Lists.newArrayList((Object[])new Integer[]{42}));
        Assertions.assertThat((List)((List)row.get(1, TypeTokens.listOf(Integer.class)))).isEqualTo((Object)Lists.newArrayList((Object[])new Integer[]{42}));
        Assertions.assertThat((List)((List)row.get(1, TypeTokens.listOf(String.class)))).isEqualTo((Object)Lists.newArrayList((Object[])new String[]{"42"}));
    }

    private class IntToStringCodec
    extends TypeCodec<String> {
        protected IntToStringCodec() {
            super(DataType.cint(), String.class);
        }

        public ByteBuffer serialize(String value, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return TypeCodec.cint().serialize(value == null ? null : Integer.valueOf(Integer.parseInt(value)), protocolVersion);
        }

        public String deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            Integer i = TypeCodec.cint().deserialize(bytes, protocolVersion);
            return i == null ? null : Integer.toString(i);
        }

        public String parse(String value) throws InvalidTypeException {
            return value;
        }

        public String format(String value) throws InvalidTypeException {
            return value;
        }

        public boolean accepts(Object value) {
            return value instanceof String && ((String)value).matches("\\d+");
        }
    }
}

