/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.utils.CassandraVersion;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class TypeCodecNestedUDTAndTupleIntegrationTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TYPE IF NOT EXISTS \"udt3\" (f3 text)", "CREATE TYPE IF NOT EXISTS \"udt2\" (f2 frozen<udt3>)", "CREATE TYPE IF NOT EXISTS \"udt1\" (f1 frozen<udt2>)", "CREATE TABLE IF NOT EXISTS \"t1\" (pk int PRIMARY KEY, c1 frozen<udt1>, c2 frozen<tuple<tuple<tuple<text>>>>, c3 frozen<tuple<tuple<tuple<udt1>>>>)", "INSERT INTO t1 (pk, c1) VALUES (1, {f1:{f2:{f3:'foo'}}})", "INSERT INTO t1 (pk, c2) VALUES (2, ((('foo'))))", "INSERT INTO t1 (pk, c3) VALUES (3, ((({f1:{f2:{f3:'foo'}}}))))");
    }

    @Test(groups={"short"})
    public void should_set_registry_on_nested_udts() {
        ResultSet rows = this.session().execute("SELECT c1 FROM t1 WHERE pk = 1");
        Row row = rows.one();
        UDTValue udt1 = row.getUDTValue("c1");
        Assertions.assertThat((Object)udt1.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        UDTValue udt2 = udt1.getUDTValue("f1");
        Assertions.assertThat((Object)udt2.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        UDTValue udt3 = udt2.getUDTValue("f2");
        Assertions.assertThat((Object)udt3.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        String f3 = udt3.getString("f3");
        Assertions.assertThat((String)f3).isEqualTo((Object)"foo");
    }

    @Test(groups={"short"})
    public void should_set_registry_on_nested_tuples() {
        ResultSet rows = this.session().execute("SELECT c2 FROM t1 WHERE pk = 2");
        Row row = rows.one();
        TupleValue tuple1 = row.getTupleValue("c2");
        Assertions.assertThat((Object)tuple1.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        TupleValue tuple2 = tuple1.getTupleValue(0);
        Assertions.assertThat((Object)tuple2.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        TupleValue tuple3 = tuple2.getTupleValue(0);
        Assertions.assertThat((Object)tuple3.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        String s = tuple3.getString(0);
        Assertions.assertThat((String)s).isEqualTo((Object)"foo");
    }

    @Test(groups={"short"})
    public void should_set_registry_on_nested_tuples_and_udts() {
        ResultSet rows = this.session().execute("SELECT c3 FROM t1 WHERE pk = 3");
        Row row = rows.one();
        TupleValue tuple1 = row.getTupleValue("c3");
        Assertions.assertThat((Object)tuple1.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        TupleValue tuple2 = tuple1.getTupleValue(0);
        Assertions.assertThat((Object)tuple2.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        TupleValue tuple3 = tuple2.getTupleValue(0);
        Assertions.assertThat((Object)tuple3.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        UDTValue udt1 = tuple3.getUDTValue(0);
        Assertions.assertThat((Object)udt1.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        UDTValue udt2 = udt1.getUDTValue("f1");
        Assertions.assertThat((Object)udt2.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        UDTValue udt3 = udt2.getUDTValue("f2");
        Assertions.assertThat((Object)udt3.getCodecRegistry()).isSameAs((Object)this.cluster().getConfiguration().getCodecRegistry());
        String f3 = udt3.getString("f3");
        Assertions.assertThat((String)f3).isEqualTo((Object)"foo");
    }
}

