/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.google.common.reflect.TypeToken;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

public class TypeCodecAssert<T>
extends AbstractAssert<TypeCodecAssert<T>, TypeCodec<T>> {
    private ProtocolVersion version = ProtocolVersion.NEWEST_SUPPORTED;

    protected TypeCodecAssert(TypeCodec<T> actual) {
        super(actual, TypeCodecAssert.class);
    }

    public TypeCodecAssert<T> accepts(TypeToken<?> javaType) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(javaType)).as("Codec %s should accept %s but it does not", new Object[]{this.actual, javaType})).isTrue();
        return this;
    }

    public TypeCodecAssert<T> doesNotAccept(TypeToken<?> javaType) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(javaType)).as("Codec %s should not accept %s but it does", new Object[]{this.actual, javaType})).isFalse();
        return this;
    }

    public TypeCodecAssert<T> accepts(Class<?> javaType) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(javaType)).as("Codec %s should accept %s but it does not", new Object[]{this.actual, javaType})).isTrue();
        return this;
    }

    public TypeCodecAssert<T> doesNotAccept(Class<?> javaType) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(javaType)).as("Codec %s should not accept %s but it does", new Object[]{this.actual, javaType})).isFalse();
        return this;
    }

    public TypeCodecAssert<T> accepts(Object value) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(value)).as("Codec %s should accept %s but it does not", new Object[]{this.actual, value})).isTrue();
        return this;
    }

    public TypeCodecAssert<T> doesNotAccept(Object value) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(value)).as("Codec %s should not accept %s but it does", new Object[]{this.actual, value})).isFalse();
        return this;
    }

    public TypeCodecAssert<T> accepts(DataType cqlType) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(cqlType)).as("Codec %s should accept %s but it does not", new Object[]{this.actual, cqlType})).isTrue();
        return this;
    }

    public TypeCodecAssert<T> doesNotAccept(DataType cqlType) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TypeCodec)this.actual).accepts(cqlType)).as("Codec %s should not accept %s but it does", new Object[]{this.actual, cqlType})).isFalse();
        return this;
    }

    public TypeCodecAssert<T> withProtocolVersion(ProtocolVersion version) {
        if (version == null) {
            Fail.fail((String)"ProtocolVersion cannot be null");
        }
        this.version = version;
        return this;
    }

    public TypeCodecAssert<T> canSerialize(Object value) {
        if (this.version == null) {
            Fail.fail((String)"ProtocolVersion cannot be null");
        }
        try {
            Assertions.assertThat((Object)((TypeCodec)this.actual).deserialize(((TypeCodec)this.actual).serialize(value, this.version), this.version)).isEqualTo(value);
        }
        catch (Exception e) {
            Fail.fail((String)String.format("Codec is supposed to serialize this value but it actually doesn't: %s", value), (Throwable)e);
        }
        return this;
    }

    public TypeCodecAssert<T> cannotSerialize(Object value) {
        if (this.version == null) {
            Fail.fail((String)"ProtocolVersion cannot be null");
        }
        try {
            ((TypeCodec)this.actual).serialize(value, this.version);
            Fail.fail((String)("Should not have been able to serialize " + value + " with " + this.actual));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public TypeCodecAssert<T> cannotFormat(Object value) {
        try {
            ((TypeCodec)this.actual).format(value);
            Fail.fail((String)("Should not have been able to format " + value + " with " + this.actual));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }
}

