/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.codahale.metrics.Meter;
import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.CassandraVersion;
import org.testng.annotations.Test;

@CassandraVersion(value="3.0")
public class TrafficMetersTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_measure_inbound_and_outbound_traffic() {
        Metrics metrics = this.session().getCluster().getMetrics();
        Meter bytesReceived = metrics.getBytesReceived();
        Meter bytesSent = metrics.getBytesSent();
        long bytesReceivedBefore = bytesReceived.getCount();
        long bytesSentBefore = bytesSent.getCount();
        SimpleStatement statement = new SimpleStatement("SELECT host_id FROM system.local");
        statement.setSerialConsistencyLevel(ConsistencyLevel.LOCAL_SERIAL);
        int requestSize = statement.requestSizeInBytes(this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion(), this.cluster().getConfiguration().getCodecRegistry());
        int responseSize = 21 + CBUtil.sizeOfString((String)"system") + CBUtil.sizeOfString((String)"local") + CBUtil.sizeOfString((String)"host_id") + 2 + 4 + 4 + 16;
        for (int i = 0; i < 1000; ++i) {
            this.session().execute((Statement)statement);
        }
        Assertions.assertThat((long)bytesSent.getCount()).isGreaterThanOrEqualTo(bytesSentBefore + (long)(requestSize * 1000));
        Assertions.assertThat((long)bytesReceived.getCount()).isGreaterThanOrEqualTo(bytesReceivedBefore + (long)(responseSize * 1000));
    }
}

