/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CassandraVersion(value="2.0.0")
public class TracingTest
extends CCMTestsSupport {
    private static final String KEY = "tracing_test";

    @Override
    public Cluster.Builder createClusterBuilder() {
        Cluster.Builder builder = Cluster.builder().withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        return builder;
    }

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test (k text, v int, PRIMARY KEY (k, v))");
        for (int i = 0; i < 100; ++i) {
            this.execute(String.format("INSERT INTO test (k, v) VALUES ('%s', %d)", KEY, i));
        }
    }

    @Test(groups={"short"})
    public void should_have_a_different_tracingId_for_each_page() {
        SimpleStatement st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        ResultSet result = this.session().execute(st.setFetchSize(40).enableTracing());
        result.all();
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        List executions = result.getAllExecutionInfo();
        UUID previousTraceId = null;
        for (ExecutionInfo executionInfo : executions) {
            QueryTrace queryTrace = executionInfo.getQueryTrace();
            Assertions.assertThat((Object)queryTrace).isNotNull();
            Assertions.assertThat((Comparable)queryTrace.getTraceId()).isNotEqualTo(previousTraceId);
            previousTraceId = queryTrace.getTraceId();
        }
        ((AbstractListAssert)Assertions.assertThat((List)result.getExecutionInfo().getQueryTrace().getEvents()).isNotNull()).isNotEmpty();
    }

    @Test(groups={"short"})
    public void should_preserve_tracing_status_across_retries() {
        SimpleStatement st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        st.setConsistencyLevel(ConsistencyLevel.THREE).enableTracing();
        ResultSet result = this.session().execute((Statement)st);
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((Object)result.getExecutionInfo().getQueryTrace()).isNotNull();
    }
}

