/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.TokenRangeAssert;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.testng.annotations.Test;

@CCMConfig(numberOfNodes={3}, createKeyspace={false})
public abstract class TokenIntegrationTest
extends CCMTestsSupport {
    private final DataType expectedTokenType;
    private final int numTokens;
    private final boolean useVnodes;
    private String ks1;
    private String ks2;

    public TokenIntegrationTest(DataType expectedTokenType, boolean useVnodes) {
        this.expectedTokenType = expectedTokenType;
        this.numTokens = useVnodes ? 256 : 1;
        this.useVnodes = useVnodes;
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        WhiteListPolicy lbp = new WhiteListPolicy((LoadBalancingPolicy)new RoundRobinPolicy(), Collections.singleton(this.ccm().addressOfNode(1)));
        return Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)lbp);
    }

    @Override
    public void onTestContextInitialized() {
        this.ks1 = TestUtils.generateIdentifier("ks_");
        this.ks2 = TestUtils.generateIdentifier("ks_");
        this.execute(String.format("CREATE KEYSPACE %s WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 1}", this.ks1), String.format("CREATE KEYSPACE %s WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 2}", this.ks2), String.format("USE %s", this.ks1), "CREATE TABLE foo(i int primary key)", "INSERT INTO foo (i) VALUES (1)", "INSERT INTO foo (i) VALUES (2)", "INSERT INTO foo (i) VALUES (3)");
    }

    @Test(groups={"short"})
    public void should_expose_token_ranges() throws Exception {
        Metadata metadata = this.cluster().getMetadata();
        int testKey = 1;
        Set replicas = metadata.getReplicas(this.ks1, TypeCodec.cint().serialize(Integer.valueOf(testKey), this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion()));
        Assertions.assertThat((Iterable)replicas).hasSize(1);
        Host replica = (Host)replicas.iterator().next();
        PreparedStatement rangeStmt = this.session().prepare("SELECT i FROM foo WHERE token(i) > ? and token(i) <= ?");
        TokenRange foundRange = null;
        for (TokenRange range : metadata.getTokenRanges()) {
            List<Row> rows = this.rangeQuery(rangeStmt, range);
            for (Row row : rows) {
                if (row.getInt("i") != testKey) continue;
                ((TokenRangeAssert)Assertions.assertThat(foundRange).describedAs("found the same key in two ranges: " + foundRange + " and " + range, new Object[0])).isNull();
                foundRange = range;
                Assertions.assertThat((Iterable)metadata.getReplicas(this.ks1, range)).contains((Object[])new Host[]{replica});
            }
        }
        Assertions.assertThat(foundRange).isNotNull();
    }

    private List<Row> rangeQuery(PreparedStatement rangeStmt, TokenRange range) {
        ArrayList rows = Lists.newArrayList();
        for (TokenRange subRange : range.unwrap()) {
            BoundStatement statement = rangeStmt.bind(new Object[]{subRange.getStart(), subRange.getEnd()});
            rows.addAll(this.session().execute((Statement)statement).all());
        }
        return rows;
    }

    @Test(groups={"short"})
    public void should_get_token_from_row_and_set_token_in_query() {
        Row row = this.session().execute("SELECT token(i) FROM foo WHERE i = 1").one();
        Token token = row.getToken(0);
        Assertions.assertThat(token.getType()).isEqualTo(this.expectedTokenType);
        Assertions.assertThat((Comparable)row.getPartitionKeyToken()).isEqualTo((Object)token);
        PreparedStatement pst = this.session().prepare("SELECT * FROM foo WHERE token(i) = ?");
        row = this.session().execute((Statement)pst.bind(new Object[]{token})).one();
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(1);
        row = this.session().execute((Statement)pst.bind().setToken(0, token)).one();
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(1);
        row = this.session().execute((Statement)pst.bind().setPartitionKeyToken(token)).one();
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(1);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0")
    public void should_get_token_from_row_and_set_token_in_query_with_binding_and_aliasing() {
        Row row = this.session().execute("SELECT token(i) AS t FROM foo WHERE i = 1").one();
        Token token = row.getToken("t");
        Assertions.assertThat(token.getType()).isEqualTo(this.expectedTokenType);
        PreparedStatement pst = this.session().prepare("SELECT * FROM foo WHERE token(i) = :myToken");
        row = this.session().execute((Statement)pst.bind().setToken("myToken", token)).one();
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(1);
        row = this.session().execute("SELECT * FROM foo WHERE token(i) = ?", new Object[]{token}).one();
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(1);
    }

    @Test(groups={"short"}, expectedExceptions={InvalidTypeException.class})
    public void should_raise_exception_when_get_token_on_non_token() {
        Row row = this.session().execute("SELECT i FROM foo WHERE i = 1").one();
        row.getToken(0);
    }

    @Test(groups={"short"})
    public void should_expose_token_ranges_per_host() {
        this.checkRangesPerHost(this.ks1, 1);
        this.checkRangesPerHost(this.ks2, 2);
        Assertions.assertThat(this.cluster()).hasValidTokenRanges();
    }

    private void checkRangesPerHost(String keyspace, int replicationFactor) {
        ArrayList allRangesWithReplicas = Lists.newArrayList();
        for (int i = 1; i <= 3; ++i) {
            Host host = TestUtils.findHost(this.cluster(), i);
            Set hostRanges = this.cluster().getMetadata().getTokenRanges(keyspace, host);
            if (!this.useVnodes) {
                Assertions.assertThat((Iterable)hostRanges).hasSize(replicationFactor * this.numTokens);
            }
            allRangesWithReplicas.addAll(hostRanges);
        }
        Assertions.assertThat((List)allRangesWithReplicas).hasSize(3 * this.numTokens * replicationFactor);
        HashSet allRanges = new HashSet(allRangesWithReplicas);
        Assertions.assertThat(allRanges).hasSize(3 * this.numTokens);
        Assertions.assertThat(this.cluster()).hasValidTokenRanges(keyspace);
    }

    @Test(groups={"short"})
    public void should_expose_tokens_per_host() {
        for (Host host : this.cluster().getMetadata().allHosts()) {
            Row row;
            Assertions.assertThat((Iterable)host.getTokens()).hasSize(this.numTokens);
            boolean isControlHost = host.getSocketAddress().equals(((Connection)this.cluster().manager.controlConnection.connectionRef.get()).address);
            if (isControlHost) {
                row = this.session().execute("select tokens from system.local").one();
            } else {
                Assertions.assertThat((Object)host.getBroadcastSocketAddress()).isNotNull();
                row = this.session().execute("select tokens from system.peers where peer = '" + host.getBroadcastSocketAddress().getAddress().getHostAddress() + "'").one();
            }
            Set tokenStrings = row.getSet("tokens", String.class);
            Assertions.assertThat((Iterable)tokenStrings).hasSize(this.numTokens);
            Iterable tokensFromSystemTable = Iterables.transform((Iterable)tokenStrings, (Function)new Function<String, Token>(){

                public Token apply(String input) {
                    return TokenIntegrationTest.this.tokenFactory().fromString(input);
                }
            });
            Assertions.assertThat((Iterable)host.getTokens()).containsOnlyOnce(Iterables.toArray((Iterable)tokensFromSystemTable, Token.class));
        }
    }

    @Test(groups={"short"})
    public void should_only_unwrap_one_range_for_all_ranges() {
        Set ranges = this.cluster().getMetadata().getTokenRanges();
        this.assertOnlyOneWrapped(ranges);
        Iterable splitRanges = Iterables.concat((Iterable)Iterables.transform((Iterable)ranges, (Function)new Function<TokenRange, Iterable<TokenRange>>(){

            public Iterable<TokenRange> apply(TokenRange input) {
                return input.splitEvenly(10);
            }
        }));
        this.assertOnlyOneWrapped(splitRanges);
    }

    protected void assertOnlyOneWrapped(Iterable<TokenRange> ranges) {
        TokenRange wrappedRange = null;
        for (TokenRange range : ranges) {
            if (range.isWrappedAround()) {
                ((TokenRangeAssert)Assertions.assertThat(wrappedRange).as("Found a wrapped around TokenRange (%s) when one already exists (%s).", new Object[]{range, wrappedRange})).isNull();
                wrappedRange = range;
                Assertions.assertThat(range).isWrappedAround();
                continue;
            }
            Assertions.assertThat(range).isNotWrappedAround();
        }
    }

    @Test(groups={"short"})
    public void should_expose_token_and_range_creation_methods() {
        Metadata metadata = this.cluster().getMetadata();
        TokenRange range = (TokenRange)metadata.getTokenRanges().iterator().next();
        Token start = metadata.newToken(range.getStart().toString());
        Token end = metadata.newToken(range.getEnd().toString());
        Assertions.assertThat(metadata.newTokenRange(start, end)).isEqualTo(range);
    }

    @Test(groups={"short"})
    public void should_create_token_from_partition_key() {
        Metadata metadata = this.cluster().getMetadata();
        Row row = this.session().execute("SELECT token(i) FROM foo WHERE i = 1").one();
        Token expected = row.getToken(0);
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        Assertions.assertThat((Comparable)metadata.newToken(new ByteBuffer[]{TypeCodec.cint().serialize(Integer.valueOf(1), protocolVersion)})).isEqualTo((Object)expected);
    }

    protected abstract Token.Factory tokenFactory();
}

