/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.utils.CassandraVersion;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CCMConfig(config={"cdc_enabled:true"})
@CassandraVersion(value="3.8", description="Requires CASSANDRA-12041 added in 3.8")
public class TableMetadataCDCTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_parse_cdc_from_table_options() {
        String cql = String.format("CREATE TABLE %s.cdc_table (\n    k text,\n    c int,\n    v timeuuid,\n    PRIMARY KEY (k, c)\n) WITH cdc=true;", this.keyspace);
        this.session().execute(cql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("cdc_table");
        Assertions.assertThat((boolean)table.getOptions().isCDC()).isEqualTo(true);
        Assertions.assertThat((String)table.asCQLQuery(true)).contains(new CharSequence[]{"cdc = true"});
    }
}

