/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapper;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.DelegatingLoadBalancingPolicy;
import com.datastax.driver.core.policies.DelegatingSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.NoSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class StatementWrapperTest
extends CCMTestsSupport {
    private static final String INSERT_QUERY = "insert into test (k, v) values (?, ?)";
    private static final String SELECT_QUERY = "select * from test where k = ?";
    private static final String INSERT_MULTIPAGE_QUERY = "insert into test_multipage (k, v) values (?, ?)";
    private static final String SELECT_MULTIPAGE_QUERY = "select * from test_multipage where k = ?";
    CustomLoadBalancingPolicy loadBalancingPolicy = new CustomLoadBalancingPolicy();
    CustomSpeculativeExecutionPolicy speculativeExecutionPolicy = new CustomSpeculativeExecutionPolicy();
    CustomRetryPolicy retryPolicy = new CustomRetryPolicy();

    @Override
    public void onTestContextInitialized() {
        this.execute("create table test (k text primary key, v int)");
        this.execute("create table test_multipage (k text, v int, primary key (k, v))");
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)this.loadBalancingPolicy).withSpeculativeExecutionPolicy((SpeculativeExecutionPolicy)this.speculativeExecutionPolicy).withRetryPolicy((RetryPolicy)this.retryPolicy);
    }

    @Test(groups={"short"})
    public void should_pass_wrapped_statement_to_load_balancing_policy() {
        this.loadBalancingPolicy.customStatementsHandled.set(0);
        SimpleStatement s = new SimpleStatement("select * from system.local");
        this.session().execute((Statement)s);
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(0);
        this.session().execute((Statement)new CustomStatement((Statement)s));
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(1);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_reuse_wrapped_simple_statement_for_multipage_query() {
        this.loadBalancingPolicy.customStatementsHandled.set(0);
        for (int v = 1; v <= 100; ++v) {
            this.session().execute((Statement)new SimpleStatement(INSERT_MULTIPAGE_QUERY, new Object[]{"key_simple_multipage", v}));
        }
        SimpleStatement s = new SimpleStatement(SELECT_MULTIPAGE_QUERY, new Object[]{"key_simple_multipage"});
        s.setFetchSize(1);
        CustomStatement customStatement = new CustomStatement((Statement)s);
        ResultSet rs = this.session().execute((Statement)customStatement);
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(1);
        Iterator it = rs.iterator();
        Assertions.assertThat((boolean)it.hasNext()).isTrue();
        it.next();
        Assertions.assertThat((Object)rs.getExecutionInfo().getStatement()).isEqualTo((Object)customStatement);
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(1);
        Assertions.assertThat((boolean)it.hasNext()).isTrue();
        it.next();
        Assertions.assertThat((Object)rs.getExecutionInfo().getStatement()).isEqualTo((Object)customStatement);
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(2);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_reuse_wrapped_bound_statement_for_multipage_query() {
        this.loadBalancingPolicy.customStatementsHandled.set(0);
        for (int v = 1; v <= 100; ++v) {
            this.session().execute((Statement)new SimpleStatement(INSERT_MULTIPAGE_QUERY, new Object[]{"key_prepared_multipage", v}));
        }
        PreparedStatement ps = this.session().prepare(SELECT_MULTIPAGE_QUERY);
        BoundStatement bs = ps.bind(new Object[]{"key_prepared_multipage"});
        bs.setFetchSize(1);
        CustomStatement customStatement = new CustomStatement((Statement)bs);
        ResultSet rs = this.session().execute((Statement)customStatement);
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(1);
        Iterator it = rs.iterator();
        Assertions.assertThat((boolean)it.hasNext()).isTrue();
        it.next();
        Assertions.assertThat((Object)rs.getExecutionInfo().getStatement()).isEqualTo((Object)customStatement);
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(1);
        Assertions.assertThat((boolean)it.hasNext()).isTrue();
        it.next();
        Assertions.assertThat((Object)rs.getExecutionInfo().getStatement()).isEqualTo((Object)customStatement);
        Assertions.assertThat((int)this.loadBalancingPolicy.customStatementsHandled.get()).isEqualTo(2);
    }

    @Test(groups={"short"})
    public void should_pass_wrapped_statement_to_speculative_execution_policy() {
        this.speculativeExecutionPolicy.customStatementsHandled.set(0);
        SimpleStatement s = new SimpleStatement("select * from system.local");
        this.session().execute((Statement)s);
        Assertions.assertThat((int)this.speculativeExecutionPolicy.customStatementsHandled.get()).isEqualTo(0);
        this.session().execute((Statement)new CustomStatement((Statement)s));
        Assertions.assertThat((int)this.speculativeExecutionPolicy.customStatementsHandled.get()).isEqualTo(1);
    }

    @Test(groups={"short"})
    public void should_pass_wrapped_statement_to_retry_policy() {
        this.retryPolicy.customStatementsHandled.set(0);
        Statement s = new SimpleStatement("select * from system.local").setConsistencyLevel(ConsistencyLevel.TWO);
        this.session().execute(s);
        Assertions.assertThat((int)this.retryPolicy.customStatementsHandled.get()).isEqualTo(0);
        this.session().execute((Statement)new CustomStatement(s));
        Assertions.assertThat((int)this.retryPolicy.customStatementsHandled.get()).isEqualTo(1);
    }

    @CassandraVersion(value="2.0.0")
    @Test(groups={"short"})
    public void should_execute_wrapped_simple_statement() {
        this.session().execute((Statement)new CustomStatement((Statement)new SimpleStatement(INSERT_QUERY, new Object[]{"key_simple", 1})));
        ResultSet rs = this.session().execute((Statement)new CustomStatement((Statement)new SimpleStatement(SELECT_QUERY, new Object[]{"key_simple"})));
        Assertions.assertThat((int)rs.one().getInt("v")).isEqualTo(1);
    }

    @Test(groups={"short"})
    public void should_execute_wrapped_bound_statement() {
        PreparedStatement preparedStatement = this.session().prepare((RegularStatement)new SimpleStatement(INSERT_QUERY));
        this.session().execute((Statement)new CustomStatement((Statement)preparedStatement.bind(new Object[]{"key_bound", 1})));
        preparedStatement = this.session().prepare((RegularStatement)new SimpleStatement(SELECT_QUERY));
        ResultSet rs = this.session().execute((Statement)new CustomStatement((Statement)preparedStatement.bind(new Object[]{"key_bound"})));
        Assertions.assertThat((int)rs.one().getInt("v")).isEqualTo(1);
    }

    @CassandraVersion(value="2.0.0")
    @Test(groups={"short"})
    public void should_execute_wrapped_batch_statement() {
        BatchStatement batchStatement = new BatchStatement();
        batchStatement.add((Statement)new SimpleStatement(INSERT_QUERY, new Object[]{"key_batch", 1}));
        this.session().execute((Statement)new CustomStatement((Statement)batchStatement));
        ResultSet rs = this.session().execute(SELECT_QUERY, new Object[]{"key_batch"});
        Assertions.assertThat((int)rs.one().getInt("v")).isEqualTo(1);
    }

    @CassandraVersion(value="2.0.0")
    @Test(groups={"short"})
    public void should_add_wrapped_batch_statement_to_batch_statement() {
        BatchStatement batchStatementForWrapping = new BatchStatement();
        batchStatementForWrapping.add((Statement)new SimpleStatement(INSERT_QUERY, new Object[]{"key1", 1}));
        BatchStatement batchStatement = new BatchStatement();
        batchStatement.add((Statement)new CustomStatement((Statement)new SimpleStatement(INSERT_QUERY, new Object[]{"key2", 2})));
        batchStatement.add((Statement)new CustomStatement((Statement)batchStatementForWrapping));
        this.session().execute((Statement)batchStatement);
        ResultSet rs = this.session().execute(SELECT_QUERY, new Object[]{"key1"});
        Assertions.assertThat((int)rs.one().getInt("v")).isEqualTo(1);
        rs = this.session().execute(SELECT_QUERY, new Object[]{"key2"});
        Assertions.assertThat((int)rs.one().getInt("v")).isEqualTo(2);
    }

    static class CustomRetryPolicy
    implements RetryPolicy {
        final AtomicInteger customStatementsHandled = new AtomicInteger();

        CustomRetryPolicy() {
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            if (statement instanceof CustomStatement) {
                this.customStatementsHandled.incrementAndGet();
            }
            return RetryPolicy.RetryDecision.ignore();
        }

        public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
            return RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)cl);
        }

        public void init(Cluster cluster) {
        }

        public void close() {
        }
    }

    static class CustomSpeculativeExecutionPolicy
    extends DelegatingSpeculativeExecutionPolicy {
        final AtomicInteger customStatementsHandled = new AtomicInteger();

        protected CustomSpeculativeExecutionPolicy() {
            super((SpeculativeExecutionPolicy)NoSpeculativeExecutionPolicy.INSTANCE);
        }

        @Override
        public SpeculativeExecutionPolicy.SpeculativeExecutionPlan newPlan(String loggedKeyspace, Statement statement) {
            if (statement instanceof CustomStatement) {
                this.customStatementsHandled.incrementAndGet();
            }
            return super.newPlan(loggedKeyspace, statement);
        }
    }

    static class CustomLoadBalancingPolicy
    extends DelegatingLoadBalancingPolicy {
        final AtomicInteger customStatementsHandled = new AtomicInteger();

        public CustomLoadBalancingPolicy() {
            super((LoadBalancingPolicy)new RoundRobinPolicy());
        }

        @Override
        public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
            if (statement instanceof CustomStatement) {
                this.customStatementsHandled.incrementAndGet();
            }
            return super.newQueryPlan(loggedKeyspace, statement);
        }
    }

    static class CustomStatement
    extends StatementWrapper {
        protected CustomStatement(Statement wrapped) {
            super(wrapped);
        }
    }
}

