/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StatementIdempotenceTest {
    private Cluster cluster;

    @BeforeMethod(groups={"unit"})
    public void setUpQueryBuilder() throws Exception {
        CodecRegistry codecRegistry = new CodecRegistry();
        this.cluster = (Cluster)Mockito.mock(Cluster.class);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        ProtocolOptions protocolOptions = (ProtocolOptions)Mockito.mock(ProtocolOptions.class);
        Mockito.when((Object)this.cluster.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.getCodecRegistry()).thenReturn((Object)codecRegistry);
        Mockito.when((Object)configuration.getProtocolOptions()).thenReturn((Object)protocolOptions);
        Mockito.when((Object)protocolOptions.getProtocolVersion()).thenReturn((Object)ProtocolVersion.NEWEST_SUPPORTED);
    }

    @Test(groups={"unit"})
    public void should_default_to_false_when_not_set_on_statement_nor_query_options() {
        QueryOptions queryOptions = new QueryOptions();
        SimpleStatement statement = new SimpleStatement("", new Object[]{this.cluster});
        Assertions.assertThat((boolean)statement.isIdempotentWithDefault(queryOptions)).isFalse();
    }

    @Test(groups={"unit"})
    public void should_use_query_options_when_not_set_on_statement() {
        QueryOptions queryOptions = new QueryOptions();
        SimpleStatement statement = new SimpleStatement("", new Object[]{this.cluster});
        for (boolean valueInOptions : new boolean[]{true, false}) {
            queryOptions.setDefaultIdempotence(valueInOptions);
            Assertions.assertThat((boolean)statement.isIdempotentWithDefault(queryOptions)).isEqualTo(valueInOptions);
        }
    }

    @Test(groups={"unit"})
    public void should_use_statement_when_set_on_statement() {
        QueryOptions queryOptions = new QueryOptions();
        SimpleStatement statement = new SimpleStatement("", new Object[]{this.cluster});
        for (boolean valueInOptions : new boolean[]{true, false}) {
            for (boolean valueInStatement : new boolean[]{true, false}) {
                queryOptions.setDefaultIdempotence(valueInOptions);
                statement.setIdempotent(valueInStatement);
                Assertions.assertThat((boolean)statement.isIdempotentWithDefault(queryOptions)).isEqualTo(valueInStatement);
            }
        }
    }

    @Test(groups={"unit"})
    public void should_infer_for_built_statement() {
        for (BuiltStatement statement : this.idempotentBuiltStatements()) {
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)statement.isIdempotent()).as(statement.getQueryString(), new Object[0])).isTrue();
        }
        for (BuiltStatement statement : this.nonIdempotentBuiltStatements()) {
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)statement.isIdempotent()).as(statement.getQueryString(), new Object[0])).isFalse();
        }
    }

    @Test(groups={"unit"})
    public void should_override_inferred_value_when_manually_set_on_built_statement() {
        for (boolean manualValue : new boolean[]{true, false}) {
            for (BuiltStatement statement : this.idempotentBuiltStatements()) {
                statement.setIdempotent(manualValue);
                Assertions.assertThat((Boolean)statement.isIdempotent()).isEqualTo(manualValue);
            }
            for (BuiltStatement statement : this.nonIdempotentBuiltStatements()) {
                statement.setIdempotent(manualValue);
                Assertions.assertThat((Boolean)statement.isIdempotent()).isEqualTo(manualValue);
            }
        }
    }

    private ImmutableList<BuiltStatement> idempotentBuiltStatements() {
        return ImmutableList.of((Object)QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)1)).where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.update((String)"foo").with(QueryBuilder.add((String)"s", (Object)1)).where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.update((String)"foo").with(QueryBuilder.put((String)"m", (Object)"a", (Object)1)).where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.select().countAll().from("foo").where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.select().ttl("v").from("foo").where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.select().writeTime("v").from("foo").where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.select().fcall("token", new Object[]{"k"}).from("foo").where(QueryBuilder.eq((String)"k", (Object)1)));
    }

    private ImmutableList<BuiltStatement> nonIdempotentBuiltStatements() {
        return ImmutableList.of((Object)QueryBuilder.update((String)"foo").with(QueryBuilder.append((String)"l", (Object)1)).where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)1)).and(QueryBuilder.prepend((String)"l", (Object)1)).where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"c")).where(QueryBuilder.eq((String)"k", (Object)1)), (Object)QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", QueryBuilder.fcall((String)"token", (Object[])new Object[]{"k"})), (Object)QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", QueryBuilder.now()), (Object)QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", QueryBuilder.uuid()), (Object)QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", (Object)Sets.newHashSet((Object[])new Object[]{QueryBuilder.fcall((String)"token", (Object[])new Object[]{"k"})})), (Object)QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", (Object)Sets.newHashSet((Object[])new Object[]{QueryBuilder.now()})), (Object)QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", (Object)Sets.newHashSet((Object[])new Object[]{QueryBuilder.uuid()})), (Object)QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, QueryBuilder.fcall((String)"token", (Object[])new Object[]{"k"})}), (Object)QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, QueryBuilder.now()}), (Object)QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, QueryBuilder.uuid()}), (Object[])new BuiltStatement[]{QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)"foo", (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{"k"}))}), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)"foo", (Object)QueryBuilder.now())}), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)"foo", (Object)QueryBuilder.uuid())}), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{"k"}), (Object)"foo")}), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)QueryBuilder.now(), (Object)"foo")}), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)QueryBuilder.uuid(), (Object)"foo")}), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{"k"}))).where(QueryBuilder.eq((String)"k", (Object)1)), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)QueryBuilder.now())).where(QueryBuilder.eq((String)"k", (Object)1)), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)QueryBuilder.uuid())).where(QueryBuilder.eq((String)"k", (Object)1)), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)Lists.newArrayList((Object[])new Object[]{QueryBuilder.fcall((String)"token", (Object[])new Object[]{"k"})}))).where(QueryBuilder.eq((String)"k", (Object)1)), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)Lists.newArrayList((Object[])new Object[]{QueryBuilder.now()}))).where(QueryBuilder.eq((String)"k", (Object)1)), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)Lists.newArrayList((Object[])new Object[]{QueryBuilder.uuid()}))).where(QueryBuilder.eq((String)"k", (Object)1)), QueryBuilder.delete().from("foo").where(QueryBuilder.lt((String)"k", (Object)QueryBuilder.fcall((String)"now", (Object[])new Object[0]))), QueryBuilder.delete().from("foo").where(QueryBuilder.lt((String)"k", (Object)QueryBuilder.now())), QueryBuilder.update((String)"foo").where(QueryBuilder.eq((String)"k", (Object)QueryBuilder.fcall((String)"now", (Object[])new Object[0]))), QueryBuilder.delete().listElt("a", 1).from("test_coll"), QueryBuilder.update((String)"foo").where(QueryBuilder.eq((String)"is", (Object)"charlie?")).ifExists(), QueryBuilder.update((String)"foo").where(QueryBuilder.eq((String)"good", (Object)"drivers")).onlyIf(QueryBuilder.contains((String)"developers", (Object)"datastax")), QueryBuilder.update((String)"foo").onlyIf().and(QueryBuilder.contains((String)"developers", (Object)"datastax")).where(QueryBuilder.eq((String)"good", (Object)"drivers")), QueryBuilder.update((String)"foo").onlyIf(QueryBuilder.contains((String)"developers", (Object)"datastax")).with(QueryBuilder.set((String)"v", (Object)0)), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)0)).onlyIf(QueryBuilder.contains((String)"hello", (Object)"world")), QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", (Object)Sets.newHashSet((Object[])new Object[]{QueryBuilder.now()})).ifNotExists(), QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)2)).ifExists(), QueryBuilder.delete().from("foo").onlyIf(QueryBuilder.eq((String)"k", (Object)2)), QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", QueryBuilder.raw((String)"foo()")), QueryBuilder.insertInto((String)"foo").value("k", (Object)1).value("v", (Object)Sets.newHashSet((Object[])new Object[]{QueryBuilder.raw((String)"foo()")})), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, QueryBuilder.raw((String)"foo()")}), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)"foo", (Object)QueryBuilder.raw((String)"foo()"))}), QueryBuilder.insertInto((String)"foo").values(new String[]{"k", "v"}, new Object[]{1, ImmutableMap.of((Object)QueryBuilder.raw((String)"foo()"), (Object)"foo")}), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)QueryBuilder.raw((String)"foo()"))).where(QueryBuilder.eq((String)"k", (Object)1)), QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"v", (Object)Lists.newArrayList((Object[])new Object[]{QueryBuilder.raw((String)"foo()")}))).where(QueryBuilder.eq((String)"k", (Object)1))});
    }
}

