/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.ServerSideTimestampGenerator;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.SortingLoadBalancingPolicy;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scassandra.http.client.Consistency;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SpeculativeExecutionTest {
    ScassandraCluster scassandras;
    Cluster cluster = null;
    SortingLoadBalancingPolicy loadBalancingPolicy;
    Metrics.Errors errors;
    Host host1;
    Host host2;
    Host host3;
    Session session;

    @BeforeMethod(groups={"short"})
    public void beforeMethod() {
        this.scassandras = ScassandraCluster.builder().withNodes(3).build();
        this.scassandras.init();
        int speculativeExecutionDelay = 200;
        this.loadBalancingPolicy = new SortingLoadBalancingPolicy();
        this.cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandras.address(2).getAddress()}).withPort(this.scassandras.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)this.loadBalancingPolicy).withSpeculativeExecutionPolicy((SpeculativeExecutionPolicy)new ConstantSpeculativeExecutionPolicy((long)speculativeExecutionDelay, 1)).withQueryOptions(new QueryOptions().setDefaultIdempotence(true)).withRetryPolicy((RetryPolicy)new CustomRetryPolicy()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        this.session = this.cluster.connect();
        this.host1 = TestUtils.findHost(this.cluster, 1);
        this.host2 = TestUtils.findHost(this.cluster, 2);
        this.host3 = TestUtils.findHost(this.cluster, 3);
        this.errors = this.cluster.getMetrics().getErrorMetrics();
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void afterMethod() {
        if (this.cluster != null) {
            this.cluster.close();
        }
        if (this.scassandras != null) {
            this.scassandras.stop();
        }
    }

    @Test(groups={"short"})
    public void should_not_start_speculative_execution_if_first_execution_completes_successfully() {
        this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result1"))).build());
        long execStartCount = this.errors.getSpeculativeExecutions().getCount();
        ResultSet rs = this.session.execute("mock query");
        Row row = rs.one();
        Assertions.assertThat((String)row.getString("result")).isEqualTo((Object)"result1");
        Assertions.assertThat((long)this.errors.getSpeculativeExecutions().getCount()).isEqualTo(execStartCount);
        ExecutionInfo executionInfo = rs.getExecutionInfo();
        Assertions.assertThat((List)executionInfo.getTriedHosts()).containsOnly((Object[])new Host[]{this.host1});
        Assertions.assertThat(executionInfo.getQueriedHost()).isEqualTo(this.host1);
        Assertions.assertThat((int)executionInfo.getSpeculativeExecutions()).isEqualTo(0);
        Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
    }

    @Test(groups={"short"})
    public void should_not_start_speculative_execution_if_first_execution_retries_but_is_still_fast_enough() {
        this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withConsistency(new Consistency[]{Consistency.TWO}).withThen(PrimingRequest.then().withResult(Result.read_request_timeout)).build());
        this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withConsistency(new Consistency[]{Consistency.ONE}).withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result1"))).build());
        long execStartCount = this.errors.getSpeculativeExecutions().getCount();
        long retriesStartCount = this.errors.getRetriesOnUnavailable().getCount();
        SimpleStatement statement = new SimpleStatement("mock query");
        statement.setConsistencyLevel(ConsistencyLevel.TWO);
        ResultSet rs = this.session.execute((Statement)statement);
        Row row = rs.one();
        Assertions.assertThat((Object)row).isNotNull();
        Assertions.assertThat((String)row.getString("result")).isEqualTo((Object)"result1");
        Assertions.assertThat((long)this.errors.getSpeculativeExecutions().getCount()).isEqualTo(execStartCount);
        Assertions.assertThat((long)this.errors.getRetriesOnReadTimeout().getCount()).isEqualTo(retriesStartCount + 1L);
        ExecutionInfo executionInfo = rs.getExecutionInfo();
        Assertions.assertThat((List)executionInfo.getTriedHosts()).containsOnly((Object[])new Host[]{this.host1});
        Assertions.assertThat(executionInfo.getQueriedHost()).isEqualTo(this.host1);
        Assertions.assertThat((int)executionInfo.getSpeculativeExecutions()).isEqualTo(0);
        Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
    }

    @Test(groups={"short"})
    public void should_start_speculative_execution_if_first_execution_takes_too_long() {
        this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result1")).withFixedDelay(Long.valueOf(400L))).build());
        this.scassandras.node(2).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result2"))).build());
        long execStartCount = this.errors.getSpeculativeExecutions().getCount();
        ResultSet rs = this.session.execute("mock query");
        Row row = rs.one();
        Assertions.assertThat((String)row.getString("result")).isEqualTo((Object)"result2");
        Assertions.assertThat((long)this.errors.getSpeculativeExecutions().getCount()).isEqualTo(execStartCount + 1L);
        ExecutionInfo executionInfo = rs.getExecutionInfo();
        Assertions.assertThat((List)executionInfo.getTriedHosts()).containsOnly((Object[])new Host[]{this.host2});
        Assertions.assertThat(executionInfo.getQueriedHost()).isEqualTo(this.host2);
        Assertions.assertThat((int)executionInfo.getSpeculativeExecutions()).isEqualTo(1);
        Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(1);
    }

    @Test(groups={"short"})
    public void should_start_speculative_execution_on_multiple_hosts_with_zero_delay() {
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandras.address(2).getAddress()}).withPort(this.scassandras.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)this.loadBalancingPolicy).withSpeculativeExecutionPolicy((SpeculativeExecutionPolicy)new ConstantSpeculativeExecutionPolicy(0L, 2)).withQueryOptions(new QueryOptions().setDefaultIdempotence(true)).withRetryPolicy((RetryPolicy)new CustomRetryPolicy()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        Session session = cluster.connect();
        this.host1 = TestUtils.findHost(cluster, 1);
        this.host2 = TestUtils.findHost(cluster, 2);
        this.host3 = TestUtils.findHost(cluster, 3);
        this.errors = cluster.getMetrics().getErrorMetrics();
        this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result1")).withFixedDelay(Long.valueOf(1000L))).build());
        this.scassandras.node(2).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result2")).withFixedDelay(Long.valueOf(1000L))).build());
        this.scassandras.node(3).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result3"))).build());
        long execStartCount = this.errors.getSpeculativeExecutions().getCount();
        ResultSet rs = session.execute("mock query");
        Row row = rs.one();
        Assertions.assertThat((String)row.getString("result")).isEqualTo((Object)"result3");
        Assertions.assertThat((long)this.errors.getSpeculativeExecutions().getCount()).isEqualTo(execStartCount + 2L);
        ExecutionInfo executionInfo = rs.getExecutionInfo();
        Assertions.assertThat((List)executionInfo.getTriedHosts()).containsOnly((Object[])new Host[]{this.host3});
        Assertions.assertThat(executionInfo.getQueriedHost()).isEqualTo(this.host3);
        Assertions.assertThat((int)executionInfo.getSpeculativeExecutions()).isEqualTo(2);
        Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(2);
    }

    @Test(groups={"short"})
    public void should_wait_until_all_executions_have_finished() {
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(1000);
        this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result1")).withFixedDelay(Long.valueOf(2000L))).build());
        this.scassandras.node(3).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result3")).withFixedDelay(Long.valueOf(500L))).build());
        this.scassandras.node(2).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result2")).withFixedDelay(Long.valueOf(2000L))).build());
        long execStartCount = this.errors.getSpeculativeExecutions().getCount();
        ResultSet rs = this.session.execute("mock query");
        Row row = rs.one();
        Assertions.assertThat((String)row.getString("result")).isEqualTo((Object)"result3");
        Assertions.assertThat((long)this.errors.getSpeculativeExecutions().getCount()).isEqualTo(execStartCount + 1L);
        ExecutionInfo executionInfo = rs.getExecutionInfo();
        Assertions.assertThat((List)executionInfo.getTriedHosts()).containsOnly((Object[])new Host[]{this.host1, this.host2, this.host3});
        Assertions.assertThat(executionInfo.getQueriedHost()).isEqualTo(this.host3);
        Assertions.assertThat((int)executionInfo.getSpeculativeExecutions()).isEqualTo(1);
        Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
    }

    @Test(groups={"short"})
    public void should_init_and_close_policy_on_cluster() {
        SpeculativeExecutionPolicy mockPolicy = (SpeculativeExecutionPolicy)Mockito.mock(SpeculativeExecutionPolicy.class);
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandras.address(2).getAddress()}).withPort(this.scassandras.getBinaryPort()).withSpeculativeExecutionPolicy(mockPolicy).build();
        ((SpeculativeExecutionPolicy)Mockito.verify((Object)mockPolicy, (VerificationMode)Mockito.times((int)0))).init(cluster);
        ((SpeculativeExecutionPolicy)Mockito.verify((Object)mockPolicy, (VerificationMode)Mockito.times((int)0))).close();
        try {
            cluster.init();
            ((SpeculativeExecutionPolicy)Mockito.verify((Object)mockPolicy, (VerificationMode)Mockito.times((int)1))).init(cluster);
        }
        finally {
            cluster.close();
            ((SpeculativeExecutionPolicy)Mockito.verify((Object)mockPolicy, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_same_default_timestamp_for_all_executions() {
        TimestampGenerator timestampGenerator = (TimestampGenerator)Mockito.spy((Object)ServerSideTimestampGenerator.INSTANCE);
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandras.address(2).getAddress()}).withPort(this.scassandras.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)this.loadBalancingPolicy).withTimestampGenerator(timestampGenerator).withSpeculativeExecutionPolicy((SpeculativeExecutionPolicy)new ConstantSpeculativeExecutionPolicy(1L, 2)).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            this.scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(SpeculativeExecutionTest.row("result", "result1")).withFixedDelay(Long.valueOf(2000L))).build());
            Session session = cluster.connect();
            Metrics.Errors errors = cluster.getMetrics().getErrorMetrics();
            long execStartCount = errors.getSpeculativeExecutions().getCount();
            SimpleStatement statement = new SimpleStatement("mock query");
            statement.setIdempotent(true);
            session.execute((Statement)statement);
            if (errors.getSpeculativeExecutions().getCount() == execStartCount + 1L) {
                ((TimestampGenerator)Mockito.verify((Object)timestampGenerator, (VerificationMode)Mockito.times((int)1))).next();
            }
        }
        finally {
            cluster.close();
        }
    }

    private static List<Map<String, ?>> row(String key, String value) {
        return ImmutableList.of((Object)ImmutableMap.of((Object)key, (Object)value));
    }

    static class CustomRetryPolicy
    implements RetryPolicy {
        CustomRetryPolicy() {
        }

        public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            if (nbRetry != 0) {
                return RetryPolicy.RetryDecision.rethrow();
            }
            return RetryPolicy.RetryDecision.retry((ConsistencyLevel)ConsistencyLevel.ONE);
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
            return RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)cl);
        }

        public void init(Cluster cluster) {
        }

        public void close() {
        }
    }
}

