/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.SpeculativeExecutionInfoFinder;
import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.PercentileSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.testng.annotations.Test;

public class SpeculativeExecutionInfoFinderTest {
    @Test(groups={"unit"})
    public void should_find_an_info_about_constant_speculative_execution_policy() {
        ConstantSpeculativeExecutionPolicy speculativeExecutionPolicy = new ConstantSpeculativeExecutionPolicy(100L, 5);
        InsightsSchema.SpeculativeExecutionInfo speculativeExecutionInfo = new SpeculativeExecutionInfoFinder().getSpeculativeExecutionInfo((SpeculativeExecutionPolicy)speculativeExecutionPolicy);
        Assertions.assertThat((Map)speculativeExecutionInfo.getOptions()).contains(new MapEntry[]{MapEntry.entry((Object)"constantDelayMillis", (Object)100L), MapEntry.entry((Object)"maxSpeculativeExecutions", (Object)5)});
        Assertions.assertThat((String)speculativeExecutionInfo.getType()).isEqualTo((Object)"ConstantSpeculativeExecutionPolicy");
        Assertions.assertThat((String)speculativeExecutionInfo.getNamespace()).isEqualTo((Object)"com.datastax.driver.core.policies");
    }

    @Test(groups={"unit"})
    public void should_find_an_info_about_percentile_speculative_execution_policy() {
        PercentileSpeculativeExecutionPolicy speculativeExecutionPolicy = new PercentileSpeculativeExecutionPolicy(null, 10.0, 5);
        InsightsSchema.SpeculativeExecutionInfo speculativeExecutionInfo = new SpeculativeExecutionInfoFinder().getSpeculativeExecutionInfo((SpeculativeExecutionPolicy)speculativeExecutionPolicy);
        Assertions.assertThat((Map)speculativeExecutionInfo.getOptions()).contains(new MapEntry[]{MapEntry.entry((Object)"percentile", (Object)10.0), MapEntry.entry((Object)"maxSpeculativeExecutions", (Object)5)});
        Assertions.assertThat((String)speculativeExecutionInfo.getType()).isEqualTo((Object)"PercentileSpeculativeExecutionPolicy");
        Assertions.assertThat((String)speculativeExecutionInfo.getNamespace()).isEqualTo((Object)"com.datastax.driver.core.policies");
    }
}

