/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.Assert;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class SingleConnectionPoolTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_throttle_requests() {
        int maxRequests = 10;
        this.cluster().getConfiguration().getPoolingOptions().setMaxRequestsPerConnection(HostDistance.LOCAL, 10);
        final AtomicBoolean excessInflightQueriesSpotted = new AtomicBoolean(false);
        final Host host = this.cluster().getMetadata().getHost(this.ccm().addressOfNode(1));
        ScheduledExecutorService openConnectionsWatcherExecutor = Executors.newScheduledThreadPool(1);
        Runnable openConnectionsWatcher = new Runnable(){

            @Override
            public void run() {
                int inFlight = SingleConnectionPoolTest.this.session().getState().getInFlightQueries(host);
                if (inFlight > 10) {
                    excessInflightQueriesSpotted.set(true);
                }
            }
        };
        openConnectionsWatcherExecutor.scheduleAtFixedRate(openConnectionsWatcher, 200L, 200L, TimeUnit.MILLISECONDS);
        for (int i = 0; i < 10000; ++i) {
            this.session().executeAsync("SELECT release_version FROM system.local");
        }
        openConnectionsWatcherExecutor.shutdownNow();
        if (excessInflightQueriesSpotted.get()) {
            Assert.fail((String)"Inflight queries exceeded the limit");
        }
    }
}

