/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolFeature;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class SimpleStatementIntegrationTest
extends CCMTestsSupport {
    private static final String keyspace2Internal = TestUtils.generateIdentifier("KS_");
    private static final String keyspace2 = Metadata.quoteIfNecessary((String)keyspace2Internal);

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE users(id int, id2 int, name text, primary key (id, id2))", "INSERT INTO users(id, id2, name) VALUES (1, 2, 'test')", String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace2, 1), String.format("CREATE TABLE %s.users2(id int, id2 int, name text, primary key (id, id2))", keyspace2), String.format("INSERT INTO %s.users2(id, id2, name) VALUES (2, 3, 'test2')", keyspace2));
    }

    @Test(groups={"short"})
    @CassandraVersion(value="4.0.0")
    public void should_use_keyspace_if_set() {
        this.queryWithKeyspaceOnStatement(this.keyspace);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="4.0.0")
    public void should_use_keyspace_if_set_no_ks_on_session() {
        this.queryWithKeyspaceOnStatement(null);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="4.0.0")
    public void should_use_keyspace_if_set_same_ks_on_session() {
        this.queryWithKeyspaceOnStatement(keyspace2);
    }

    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class})
    public void should_not_use_keyspace_if_set_and_protocol_does_not_support() {
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        while (ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(protocolVersion)) {
            protocolVersion = protocolVersion.getLowerSupported();
        }
        Cluster cluster = this.createClusterBuilderNoDebouncing().addContactPointsWithPorts(this.getContactPointsWithPorts()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withProtocolVersion(protocolVersion).build();
        this.queryWithKeyspaceOnStatement(cluster, this.keyspace);
    }

    private void queryWithKeyspaceOnStatement(String sessionKeyspace) {
        this.queryWithKeyspaceOnStatement(this.cluster(), sessionKeyspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryWithKeyspaceOnStatement(Cluster cluster, String sessionKeyspace) {
        Session session = sessionKeyspace != null ? cluster.connect(sessionKeyspace) : cluster.connect();
        try {
            SimpleStatement statement = new SimpleStatement("SELECT name FROM users2 WHERE id = 2 and id2 = 3").setKeyspace(keyspace2Internal);
            Row row = session.execute((Statement)statement).one();
            Assertions.assertThat((Object)row).isNotNull();
            Assertions.assertThat((String)row.getString("name")).isEqualTo((Object)"test2");
        }
        finally {
            session.close();
            if (cluster != this.cluster()) {
                cluster.close();
            }
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_execute_query_with_named_values() {
        SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id and id2 = :id2", (Map)ImmutableMap.of((Object)"id", (Object)1, (Object)"id2", (Object)2));
        Row row = this.session().execute((Statement)statement).one();
        Assertions.assertThat((Object)row).isNotNull();
        Assertions.assertThat((String)row.getString("name")).isEqualTo((Object)"test");
    }

    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class})
    @CassandraVersion(value="2.1.0")
    public void should_fail_if_query_with_named_values_but_missing_parameter() {
        SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id and id2 = :id2", (Map)ImmutableMap.of((Object)"id2", (Object)2));
        this.session().execute((Statement)statement).one();
    }

    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class})
    @CassandraVersion(value="2.1.0")
    public void should_fail_if_query_with_named_values_but_using_wrong_type() {
        SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id and id2 = :id2", (Map)ImmutableMap.of((Object)"id", (Object)2.7, (Object)"id2", (Object)2));
        this.session().execute((Statement)statement).one();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useNamedValuesWithProtocol(ProtocolVersion version) {
        Cluster vCluster = this.createClusterBuilder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(version).build();
        try {
            Session vSession = vCluster.connect(this.keyspace);
            SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id", (Map)ImmutableMap.of((Object)"id", (Object)1));
            vSession.execute((Statement)statement).one();
        }
        finally {
            vCluster.close();
        }
    }

    @Test(groups={"short"}, expectedExceptions={UnsupportedFeatureException.class})
    @CassandraVersion(value="2.0.0")
    public void should_fail_if_query_with_named_values_if_protocol_is_V2() {
        if (this.ccm().getCassandraVersion().getMajor() >= 3) {
            throw new SkipException("Skipping since Cassandra 3.0+ does not support protocol v2");
        }
        this.useNamedValuesWithProtocol(ProtocolVersion.V2);
    }

    @Test(groups={"short"}, expectedExceptions={UnsupportedFeatureException.class})
    @CassandraVersion(value="2.0.0")
    public void should_fail_if_query_with_named_values_if_protocol_is_V1() {
        if (this.ccm().getCassandraVersion().getMajor() >= 3) {
            throw new SkipException("Skipping since Cassandra 3.0+ does not support protocol v1");
        }
        this.useNamedValuesWithProtocol(ProtocolVersion.V1);
    }
}

