/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class SessionTest
extends CCMTestsSupport {
    private static final String TABLE1 = TestUtils.generateIdentifier("test1");
    private static final String TABLE2 = TestUtils.generateIdentifier("test2");
    private static final String TABLE3 = TestUtils.generateIdentifier("test3");
    private static final String COUNTER_TABLE = TestUtils.generateIdentifier("counters");

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE1), String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE2), String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE3), String.format("CREATE TABLE %s (k text PRIMARY KEY, c counter)", COUNTER_TABLE));
    }

    @Test(groups={"short"})
    public void should_execute_simple_statements() throws Exception {
        String key = "execute_test";
        ResultSet rs = this.session().execute(String.format(Locale.US, "INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", TABLE1, key, "foo", 42, Float.valueOf(24.03f)));
        Assertions.assertThat((boolean)rs.isExhausted()).isTrue();
        SessionTest.checkExecuteResultSet(this.session().execute(String.format("SELECT * FROM %s", TABLE1)), key);
        SessionTest.checkExecuteResultSet(this.session().execute(new SimpleStatement(String.format("SELECT * FROM %s", TABLE1)).setConsistencyLevel(ConsistencyLevel.ONE)), key);
        SessionTest.checkExecuteResultSet(this.session().executeAsync(String.format("SELECT * FROM %s", TABLE1)).getUninterruptibly(), key);
        SessionTest.checkExecuteResultSet(this.session().executeAsync(new SimpleStatement(String.format("SELECT * FROM %s", TABLE1)).setConsistencyLevel(ConsistencyLevel.ONE)).getUninterruptibly(), key);
    }

    @Test(groups={"short"})
    public void should_execute_prepared_statements() throws Exception {
        String key = "execute_prepared_test";
        ResultSet rs = this.session().execute(String.format(Locale.US, "INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", TABLE2, key, "foo", 42, Float.valueOf(24.03f)));
        Assertions.assertThat((boolean)rs.isExhausted()).isTrue();
        PreparedStatement p = this.session().prepare(String.format("SELECT * FROM %s WHERE k = ?", TABLE2));
        BoundStatement bs = p.bind(new Object[]{key});
        SessionTest.checkExecuteResultSet(this.session().execute((Statement)bs), key);
        SessionTest.checkExecuteResultSet(this.session().execute(bs.setConsistencyLevel(ConsistencyLevel.ONE)), key);
        SessionTest.checkExecuteResultSet(this.session().executeAsync((Statement)bs).getUninterruptibly(), key);
        SessionTest.checkExecuteResultSet(this.session().executeAsync(bs.setConsistencyLevel(ConsistencyLevel.ONE)).getUninterruptibly(), key);
    }

    static void checkExecuteResultSet(ResultSet rs, String key) {
        Assertions.assertThat((boolean)rs.isExhausted()).isFalse();
        Row row = rs.one();
        Assertions.assertThat((boolean)rs.isExhausted()).isTrue();
        Assertions.assertThat((String)row.getString("k")).isEqualTo((Object)key);
        Assertions.assertThat((String)row.getString("t")).isEqualTo((Object)"foo");
        Assertions.assertThat((int)row.getInt("i")).isEqualTo(42);
        Assertions.assertThat((float)row.getFloat("f")).isEqualTo(24.03f, Assertions.offset((Float)Float.valueOf(0.1f)));
    }

    @Test(groups={"short"})
    public void should_execute_prepared_counter_statement() throws Exception {
        PreparedStatement p = this.session().prepare("UPDATE " + COUNTER_TABLE + " SET c = c + ? WHERE k = ?");
        this.session().execute((Statement)p.bind(new Object[]{1L, "row"}));
        this.session().execute((Statement)p.bind(new Object[]{1L, "row"}));
        ResultSet rs = this.session().execute("SELECT * FROM " + COUNTER_TABLE);
        List rows = rs.all();
        Assertions.assertThat((List)rows).hasSize(1);
        Assertions.assertThat((long)((Row)rows.get(0)).getLong("c")).isEqualTo(2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_close_properly_when_racing_with_cluster_init() throws InterruptedException {
        for (int i = 0; i < 500; ++i) {
            final Cluster cluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
            try {
                final Session session = cluster.newSession();
                ExecutorService executor = Executors.newFixedThreadPool(2);
                final CountDownLatch startLatch = new CountDownLatch(1);
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            startLatch.await();
                            cluster.init();
                        }
                        catch (InterruptedException e) {
                            Assertions.fail((String)"unexpected interruption", (Throwable)e);
                        }
                    }
                });
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            startLatch.await();
                            TimeUnit.MILLISECONDS.sleep(10L);
                            session.close();
                        }
                        catch (InterruptedException e) {
                            Assertions.fail((String)"unexpected interruption", (Throwable)e);
                        }
                    }
                });
                startLatch.countDown();
                executor.shutdown();
                boolean normalShutdown = executor.awaitTermination(5L, TimeUnit.SECONDS);
                Assertions.assertThat((boolean)normalShutdown).isTrue();
                continue;
            }
            finally {
                cluster.close();
            }
        }
    }

    @Test(groups={"short"})
    public void should_give_explicit_error_message_when_keyspace_name_invalid() {
        try {
            this.cluster().connect("%!;");
            Assertions.fail((String)"Expected a SyntaxError");
        }
        catch (SyntaxError e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Error executing \"USE %!;\""}).contains(new CharSequence[]{"Check that your keyspace name is valid"});
        }
    }

    @Test(groups={"short"})
    public void should_give_explicit_error_message_when_keyspace_name_invalid_async() {
        ListenableFuture sessionFuture = this.cluster().connectAsync("");
        try {
            sessionFuture.get();
        }
        catch (ExecutionException e) {
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(SyntaxError.class);
            Assertions.assertThat((String)e.getCause().getMessage()).contains(new CharSequence[]{"no viable alternative at input '<EOF>'"}).contains(new CharSequence[]{"Check that your keyspace name is valid"});
        }
        catch (Exception e) {
            Assertions.fail((String)"Did not expect Exception", (Throwable)e);
        }
    }
}

