/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.KeyspaceMetadataAssert;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TableMetadataAssert;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractIterableAssert;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@CCMConfig(createCluster={false}, config={"enable_user_defined_functions:true"})
public class SchemaChangesTest
extends CCMTestsSupport {
    private static final String CREATE_KEYSPACE = "CREATE KEYSPACE %s WITH REPLICATION = { 'class' : 'SimpleStrategy', 'replication_factor': '1' }";
    private static final String ALTER_KEYSPACE = "ALTER KEYSPACE %s WITH durable_writes = false";
    private static final String DROP_KEYSPACE = "DROP KEYSPACE %s";
    private static final String CREATE_TABLE = "CREATE TABLE %s.table1(i int primary key)";
    private static final String ALTER_TABLE = "ALTER TABLE %s.table1 ADD j int";
    private static final String DROP_TABLE = "DROP TABLE %s.table1";
    private static final long NOTIF_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(1L);
    Cluster cluster1;
    Cluster cluster2;
    Cluster schemaDisabledCluster;
    Session session1;
    Session schemaDisabledSession;
    SchemaChangeListener listener1;
    SchemaChangeListener listener2;
    SchemaChangeListener schemaDisabledListener;
    List<SchemaChangeListener> listeners;
    ControlConnection schemaDisabledControlConnection;

    @BeforeClass(groups={"short"})
    public void setup() throws InterruptedException {
        this.cluster1 = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build();
        this.cluster2 = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build();
        this.schemaDisabledCluster = (Cluster)Mockito.spy((Object)Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withClusterName("schema-disabled").withQueryOptions(TestUtils.nonDebouncingQueryOptions().setMetadataEnabled(false)).build());
        this.schemaDisabledSession = this.schemaDisabledCluster.connect();
        this.schemaDisabledCluster.manager.controlConnection = this.schemaDisabledControlConnection = (ControlConnection)Mockito.spy((Object)this.schemaDisabledCluster.manager.controlConnection);
        this.session1 = this.cluster1.connect();
        this.cluster2.init();
        this.listener1 = (SchemaChangeListener)Mockito.mock(SchemaChangeListener.class);
        this.cluster1.register(this.listener1);
        this.listener2 = (SchemaChangeListener)Mockito.mock(SchemaChangeListener.class);
        this.cluster2.register(this.listener2);
        this.listeners = Lists.newArrayList((Object[])new SchemaChangeListener[]{this.listener1, this.listener2});
        this.schemaDisabledListener = (SchemaChangeListener)Mockito.mock(SchemaChangeListener.class);
        this.schemaDisabledCluster.register(this.schemaDisabledListener);
        ((SchemaChangeListener)Mockito.verify((Object)this.schemaDisabledListener, (VerificationMode)Mockito.times((int)1))).onRegister(this.schemaDisabledCluster);
        this.execute(CREATE_KEYSPACE, "lowercase");
        this.execute(CREATE_KEYSPACE, "\"CaseSensitive\"");
    }

    @AfterClass(groups={"short"}, alwaysRun=true)
    public void teardown() {
        if (this.cluster1 != null) {
            this.cluster1.close();
        }
        if (this.cluster2 != null) {
            this.cluster2.close();
        }
        if (this.schemaDisabledCluster != null) {
            this.schemaDisabledCluster.close();
        }
    }

    @DataProvider(name="existingKeyspaceName")
    public static Object[][] existingKeyspaceName() {
        return new Object[][]{{"lowercase"}, {"\"CaseSensitive\""}};
    }

    @DataProvider(name="newKeyspaceName")
    public static Object[][] newKeyspaceName() {
        return new Object[][]{{"lowercase2"}, {"\"CaseSensitive2\""}};
    }

    @BeforeMethod(groups={"short"})
    public void resetListeners() {
        for (SchemaChangeListener listener : this.listeners) {
            Mockito.reset((Object[])new SchemaChangeListener[]{listener});
        }
        Mockito.reset((Object[])new ControlConnection[]{this.schemaDisabledControlConnection});
    }

    @AfterMethod(groups={"short"})
    public void verifyNoMoreInteractionsWithListener() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaDisabledListener});
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    public void should_notify_of_table_creation(String keyspace) throws InterruptedException {
        this.execute(CREATE_TABLE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableAdded((TableMetadata)added.capture());
            Assertions.assertThat((TableMetadata)added.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasName("table1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1")).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    public void should_notify_of_table_update(String keyspace) throws InterruptedException {
        this.execute(CREATE_TABLE, keyspace);
        ArgumentCaptor added = null;
        for (SchemaChangeListener listener : this.listeners) {
            added = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableAdded((TableMetadata)added.capture());
            Assertions.assertThat((TableMetadata)added.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasName("table1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1")).hasNoColumn("j");
        }
        assert (added != null);
        this.execute(ALTER_TABLE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor current = ArgumentCaptor.forClass(TableMetadata.class);
            ArgumentCaptor previous = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableChanged((TableMetadata)current.capture(), (TableMetadata)previous.capture());
            ((TableMetadataAssert)Assertions.assertThat((TableMetadata)previous.getValue()).isEqualTo(added.getValue())).hasNoColumn("j");
            Assertions.assertThat((TableMetadata)current.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasName("table1").hasColumn("j");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1")).hasColumn("j");
        }
    }

    @Test(groups={"short"})
    public void should_not_update_tables_on_stale_keyspace_instance() throws InterruptedException {
        final Cluster cluster1 = this.session1.getCluster();
        String keyspaceName = "lowercase";
        this.execute(CREATE_TABLE, "lowercase");
        final KeyspaceMetadata oldKeyspace = cluster1.getMetadata().getKeyspace("lowercase");
        TableMetadata oldTable = oldKeyspace.getTable("table1");
        cluster1.getConfiguration().getQueryOptions().setMetadataEnabled(false);
        cluster1.getConfiguration().getQueryOptions().setMetadataEnabled(true);
        ConditionChecker.check().that(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return cluster1.getMetadata().getKeyspace("lowercase") == oldKeyspace;
            }
        }).becomesFalse();
        Assertions.assertThat(oldKeyspace.getTable("table1")).isSameAs(oldTable);
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="3.0")
    public void should_retain_view_on_table_update(String keyspace) throws InterruptedException {
        this.session1.execute(String.format("CREATE TABLE %s.table1 (pk int PRIMARY KEY, c int)", keyspace));
        ArgumentCaptor added = null;
        for (SchemaChangeListener listener : this.listeners) {
            added = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableAdded((TableMetadata)added.capture());
            Assertions.assertThat((TableMetadata)added.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasName("table1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1")).hasNoColumn("j");
        }
        assert (added != null);
        this.session1.execute(String.format("CREATE MATERIALIZED VIEW %s.mv1 AS SELECT c FROM %s.table1 WHERE c IS NOT NULL PRIMARY KEY (pk, c)", keyspace, keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor viewAdded = ArgumentCaptor.forClass(MaterializedViewMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onMaterializedViewAdded((MaterializedViewMetadata)viewAdded.capture());
            Assertions.assertThat((MaterializedViewMetadata)viewAdded.getValue()).hasName("mv1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getMaterializedView("mv1")).isNotNull();
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1").getView("mv1")).isNotNull();
        }
        this.execute(ALTER_TABLE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor current = ArgumentCaptor.forClass(TableMetadata.class);
            ArgumentCaptor previous = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableChanged((TableMetadata)current.capture(), (TableMetadata)previous.capture());
            ((TableMetadataAssert)Assertions.assertThat((TableMetadata)previous.getValue()).isEqualTo(added.getValue())).hasNoColumn("j");
            Assertions.assertThat((TableMetadata)current.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasName("table1").hasColumn("j");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1")).hasColumn("j");
            Assertions.assertThat(m.getKeyspace(keyspace).getMaterializedView("mv1")).isNotNull();
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1").getView("mv1")).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    public void should_notify_of_table_drop(String keyspace) throws InterruptedException {
        this.execute(CREATE_TABLE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableAdded((TableMetadata)added.capture());
            Assertions.assertThat((TableMetadata)added.getValue()).hasName("table1").isInKeyspace(Metadata.handleId((String)keyspace));
        }
        this.execute(DROP_TABLE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor removed = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableRemoved((TableMetadata)removed.capture());
            Assertions.assertThat((TableMetadata)removed.getValue()).hasName("table1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getTable("table1")).isNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.1.0")
    public void should_notify_of_udt_creation(String keyspace) {
        this.session1.execute(String.format("CREATE TYPE %s.type1(i int)", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(UserType.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onUserTypeAdded((UserType)added.capture());
            Assertions.assertThat((DataType)added.getValue()).isUserType(Metadata.handleId((String)keyspace), "type1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((DataType)m.getKeyspace(keyspace).getUserType("type1")).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.1.0")
    public void should_notify_of_udt_update(String keyspace) {
        this.session1.execute(String.format("CREATE TYPE %s.type1(i int)", keyspace));
        this.session1.execute(String.format("ALTER TYPE %s.type1 ADD j int", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor current = ArgumentCaptor.forClass(UserType.class);
            ArgumentCaptor previous = ArgumentCaptor.forClass(UserType.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onUserTypeChanged((UserType)current.capture(), (UserType)previous.capture());
            Assertions.assertThat((Iterable)((UserType)previous.getValue()).getFieldNames()).doesNotContain((Object[])new String[]{"j"});
            Assertions.assertThat((Iterable)((UserType)current.getValue()).getFieldNames()).contains((Object[])new String[]{"j"});
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getUserType("type1").getFieldType("j")).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.1.0")
    public void should_notify_of_udt_drop(String keyspace) {
        this.session1.execute(String.format("CREATE TYPE %s.type1(i int)", keyspace));
        this.session1.execute(String.format("DROP TYPE %s.type1", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor removed = ArgumentCaptor.forClass(UserType.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onUserTypeRemoved((UserType)removed.capture());
            Assertions.assertThat((DataType)removed.getValue()).isUserType(Metadata.handleId((String)keyspace), "type1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((DataType)m.getKeyspace(keyspace).getUserType("type1")).isNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.2.0")
    public void should_notify_of_function_creation(String keyspace) {
        this.session1.execute(String.format("CREATE FUNCTION %s.\"ID\"(i int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return i;'", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(FunctionMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onFunctionAdded((FunctionMetadata)added.capture());
            Assertions.assertThat((FunctionMetadata)added.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasSignature("\"ID\"(int)");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getFunction("\"ID\"", new DataType[]{DataType.cint()})).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.2.0")
    public void should_notify_of_function_update(String keyspace) {
        this.session1.execute(String.format("CREATE FUNCTION %s.\"ID\"(i int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return i;'", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(FunctionMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onFunctionAdded((FunctionMetadata)added.capture());
            Assertions.assertThat((FunctionMetadata)added.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasSignature("\"ID\"(int)");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getFunction("\"ID\"", new DataType[]{DataType.cint()})).isNotNull();
        }
        this.session1.execute(String.format("CREATE OR REPLACE FUNCTION %s.\"ID\"(i int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return i + 1;'", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor current = ArgumentCaptor.forClass(FunctionMetadata.class);
            ArgumentCaptor previous = ArgumentCaptor.forClass(FunctionMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onFunctionChanged((FunctionMetadata)current.capture(), (FunctionMetadata)previous.capture());
            Assertions.assertThat((FunctionMetadata)previous.getValue()).hasBody("return i;");
            Assertions.assertThat((FunctionMetadata)current.getValue()).hasBody("return i + 1;");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((String)m.getKeyspace(keyspace).getFunction("\"ID\"", new DataType[]{DataType.cint()}).getBody()).isEqualTo((Object)"return i + 1;");
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.2.0")
    public void should_notify_of_function_drop(String keyspace) {
        this.session1.execute(String.format("CREATE FUNCTION %s.\"ID\"(i int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return i;'", keyspace));
        this.session1.execute(String.format("DROP FUNCTION %s.\"ID\"", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor removed = ArgumentCaptor.forClass(FunctionMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onFunctionRemoved((FunctionMetadata)removed.capture());
            Assertions.assertThat((FunctionMetadata)removed.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasSignature("\"ID\"(int)");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getFunction("\"ID\"", new DataType[]{DataType.cint()})).isNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.2.0")
    public void should_notify_of_aggregate_creation(String keyspace) {
        this.session1.execute(String.format("CREATE FUNCTION %s.\"PLUS\"(s int, v int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return s+v;'", keyspace));
        this.session1.execute(String.format("CREATE AGGREGATE %s.\"SUM\"(int) SFUNC \"PLUS\" STYPE int INITCOND 0;", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(AggregateMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onAggregateAdded((AggregateMetadata)added.capture());
            Assertions.assertThat((AggregateMetadata)added.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasSignature("\"SUM\"(int)");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getAggregate("\"SUM\"", new DataType[]{DataType.cint()})).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.2.0")
    public void should_notify_of_aggregate_update(String keyspace) {
        this.session1.execute(String.format("CREATE FUNCTION %s.\"PLUS\"(s int, v int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return s+v;'", keyspace));
        this.session1.execute(String.format("CREATE AGGREGATE %s.\"SUM\"(int) SFUNC \"PLUS\" STYPE int INITCOND 0", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(AggregateMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onAggregateAdded((AggregateMetadata)added.capture());
            Assertions.assertThat((AggregateMetadata)added.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasSignature("\"SUM\"(int)");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((Object)m.getKeyspace(keyspace).getAggregate("\"SUM\"", new DataType[]{DataType.cint()}).getInitCond()).isEqualTo((Object)0);
        }
        this.session1.execute(String.format("CREATE OR REPLACE AGGREGATE %s.\"SUM\"(int) SFUNC \"PLUS\" STYPE int INITCOND 1", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor current = ArgumentCaptor.forClass(AggregateMetadata.class);
            ArgumentCaptor previous = ArgumentCaptor.forClass(AggregateMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onAggregateChanged((AggregateMetadata)current.capture(), (AggregateMetadata)previous.capture());
            Assertions.assertThat((AggregateMetadata)previous.getValue()).hasInitCond(0);
            Assertions.assertThat((AggregateMetadata)current.getValue()).hasInitCond(1);
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((Object)m.getKeyspace(keyspace).getAggregate("\"SUM\"", new DataType[]{DataType.cint()}).getInitCond()).isEqualTo((Object)1);
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="2.2.0")
    public void should_notify_of_aggregate_drop(String keyspace) {
        this.session1.execute(String.format("CREATE FUNCTION %s.\"PLUS\"(s int, v int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return s+v;'", keyspace));
        this.session1.execute(String.format("CREATE AGGREGATE %s.\"SUM\"(int) SFUNC \"PLUS\" STYPE int INITCOND 0", keyspace));
        this.session1.execute(String.format("DROP AGGREGATE %s.\"SUM\"", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor removed = ArgumentCaptor.forClass(AggregateMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onAggregateRemoved((AggregateMetadata)removed.capture());
            Assertions.assertThat((AggregateMetadata)removed.getValue()).isInKeyspace(Metadata.handleId((String)keyspace)).hasSignature("\"SUM\"(int)");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getAggregate("\"SUM\"", new DataType[]{DataType.cint()})).isNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="3.0")
    public void should_notify_of_view_creation(String keyspace) {
        this.session1.execute(String.format("CREATE TABLE %s.table1 (pk int PRIMARY KEY, c int)", keyspace));
        this.session1.execute(String.format("CREATE MATERIALIZED VIEW %s.mv1 AS SELECT c FROM %s.table1 WHERE c IS NOT NULL PRIMARY KEY (pk, c)", keyspace, keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor removed = ArgumentCaptor.forClass(MaterializedViewMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onMaterializedViewAdded((MaterializedViewMetadata)removed.capture());
            Assertions.assertThat((MaterializedViewMetadata)removed.getValue()).hasName("mv1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getMaterializedView("mv1")).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="3.0")
    public void should_notify_of_view_update(String keyspace) {
        this.session1.execute(String.format("CREATE TABLE %s.table1 (pk int PRIMARY KEY, c int)", keyspace));
        this.session1.execute(String.format("CREATE MATERIALIZED VIEW %s.mv1 AS SELECT c FROM %s.table1 WHERE c IS NOT NULL PRIMARY KEY (pk, c) WITH compaction = { 'class' : 'SizeTieredCompactionStrategy' }", keyspace, keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor removed = ArgumentCaptor.forClass(MaterializedViewMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onMaterializedViewAdded((MaterializedViewMetadata)removed.capture());
            Assertions.assertThat((MaterializedViewMetadata)removed.getValue()).hasName("mv1");
            Assertions.assertThat((String)((String)((MaterializedViewMetadata)removed.getValue()).getOptions().getCompaction().get("class"))).contains(new CharSequence[]{"SizeTieredCompactionStrategy"});
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((String)((String)m.getKeyspace(keyspace).getMaterializedView("mv1").getOptions().getCompaction().get("class"))).contains(new CharSequence[]{"SizeTieredCompactionStrategy"});
        }
        this.session1.execute(String.format("ALTER MATERIALIZED VIEW %s.mv1 WITH compaction = { 'class' : 'LeveledCompactionStrategy' }", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor current = ArgumentCaptor.forClass(MaterializedViewMetadata.class);
            ArgumentCaptor previous = ArgumentCaptor.forClass(MaterializedViewMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onMaterializedViewChanged((MaterializedViewMetadata)current.capture(), (MaterializedViewMetadata)previous.capture());
            Assertions.assertThat((String)((String)((MaterializedViewMetadata)previous.getValue()).getOptions().getCompaction().get("class"))).contains(new CharSequence[]{"SizeTieredCompactionStrategy"});
            Assertions.assertThat((String)((String)((MaterializedViewMetadata)current.getValue()).getOptions().getCompaction().get("class"))).contains(new CharSequence[]{"LeveledCompactionStrategy"});
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((String)((String)m.getKeyspace(keyspace).getMaterializedView("mv1").getOptions().getCompaction().get("class"))).contains(new CharSequence[]{"LeveledCompactionStrategy"});
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    @CassandraVersion(value="3.0")
    public void should_notify_of_view_drop(String keyspace) {
        this.session1.execute(String.format("CREATE TABLE %s.table1 (pk int PRIMARY KEY, c int)", keyspace));
        this.session1.execute(String.format("CREATE MATERIALIZED VIEW %s.mv1 AS SELECT c FROM %s.table1 WHERE c IS NOT NULL PRIMARY KEY (pk, c)", keyspace, keyspace));
        this.session1.execute(String.format("DROP MATERIALIZED VIEW %s.mv1", keyspace));
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor removed = ArgumentCaptor.forClass(MaterializedViewMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onMaterializedViewRemoved((MaterializedViewMetadata)removed.capture());
            Assertions.assertThat((MaterializedViewMetadata)removed.getValue()).hasName("mv1");
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace).getMaterializedView("mv1")).isNull();
        }
    }

    @Test(groups={"short"}, dataProvider="newKeyspaceName")
    public void should_notify_of_keyspace_creation(String keyspace) throws InterruptedException {
        this.execute(CREATE_KEYSPACE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(KeyspaceMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onKeyspaceAdded((KeyspaceMetadata)added.capture());
            Assertions.assertThat((KeyspaceMetadata)added.getValue()).hasName(Metadata.handleId((String)keyspace));
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace)).isNotNull();
        }
    }

    @Test(groups={"short"}, dataProvider="newKeyspaceName")
    public void should_notify_of_keyspace_update(String keyspace) throws InterruptedException {
        this.execute(CREATE_KEYSPACE, keyspace);
        ArgumentCaptor added = null;
        for (SchemaChangeListener listener : this.listeners) {
            added = ArgumentCaptor.forClass(KeyspaceMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onKeyspaceAdded((KeyspaceMetadata)added.capture());
            Assertions.assertThat((KeyspaceMetadata)added.getValue()).hasName(Metadata.handleId((String)keyspace));
        }
        assert (added != null);
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((boolean)m.getKeyspace(keyspace).isDurableWrites()).isTrue();
        }
        this.execute(ALTER_KEYSPACE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor current = ArgumentCaptor.forClass(KeyspaceMetadata.class);
            ArgumentCaptor previous = ArgumentCaptor.forClass(KeyspaceMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onKeyspaceChanged((KeyspaceMetadata)current.capture(), (KeyspaceMetadata)previous.capture());
            ((KeyspaceMetadataAssert)Assertions.assertThat((KeyspaceMetadata)previous.getValue()).isEqualTo(added.getValue())).isDurableWrites();
            Assertions.assertThat((KeyspaceMetadata)current.getValue()).hasName(Metadata.handleId((String)keyspace)).isNotDurableWrites();
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace)).isNotDurableWrites();
        }
    }

    @Test(groups={"short"}, dataProvider="newKeyspaceName")
    public void should_notify_of_keyspace_drop(String keyspace) throws InterruptedException {
        this.execute(CREATE_KEYSPACE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor added = ArgumentCaptor.forClass(KeyspaceMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onKeyspaceAdded((KeyspaceMetadata)added.capture());
            Assertions.assertThat((KeyspaceMetadata)added.getValue()).hasName(Metadata.handleId((String)keyspace));
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat((Iterable)m.getReplicas(keyspace, Bytes.fromHexString((String)"0xCAFEBABE"))).isNotEmpty();
        }
        this.execute(CREATE_TABLE, keyspace);
        this.execute(DROP_KEYSPACE, keyspace);
        for (SchemaChangeListener listener : this.listeners) {
            ArgumentCaptor table = ArgumentCaptor.forClass(TableMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onTableRemoved((TableMetadata)table.capture());
            Assertions.assertThat((TableMetadata)table.getValue()).hasName("table1").isInKeyspace(Metadata.handleId((String)keyspace));
            ArgumentCaptor ks = ArgumentCaptor.forClass(KeyspaceMetadata.class);
            ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)NOTIF_TIMEOUT_MS).times(1))).onKeyspaceRemoved((KeyspaceMetadata)ks.capture());
            Assertions.assertThat((KeyspaceMetadata)ks.getValue()).hasName(Metadata.handleId((String)keyspace));
        }
        for (Metadata m : this.metadatas()) {
            Assertions.assertThat(m.getKeyspace(keyspace)).isNull();
            Assertions.assertThat((Iterable)m.getReplicas(keyspace, Bytes.fromHexString((String)"0xCAFEBABE"))).isEmpty();
        }
    }

    @Test(groups={"short"}, expectedExceptions={IllegalStateException.class})
    public void should_throw_illegal_state_exception_on_newToken_with_metadata_disabled() {
        Cluster cluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions().setMetadataEnabled(false)).build();
        try {
            cluster.init();
            cluster.getMetadata().newToken("0x00");
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, expectedExceptions={IllegalStateException.class})
    public void should_throw_illegal_state_exception_on_newTokenRange_with_metadata_disabled() {
        Cluster cluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions().setMetadataEnabled(false)).build();
        try {
            cluster.init();
            Token.Factory factory = Token.getFactory((String)"Murmur3Partitioner");
            Token token = factory.fromString(Long.toString(1L));
            cluster.getMetadata().newTokenRange(token, token);
        }
        finally {
            cluster.close();
        }
    }

    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    public void should_not_refresh_schema_on_schema_change_response(String keyspace) throws InterruptedException {
        ResultSet rs = this.schemaDisabledSession.execute(String.format(CREATE_TABLE, keyspace));
        Assertions.assertThat((boolean)rs.getExecutionInfo().isSchemaInAgreement()).isTrue();
        Assertions.assertThat((boolean)this.schemaDisabledCluster.getMetadata().checkSchemaAgreement()).isTrue();
        ((ControlConnection)Mockito.verify((Object)this.schemaDisabledControlConnection, (VerificationMode)Mockito.after((int)1000).never())).refreshSchema((SchemaElement)Matchers.any(SchemaElement.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), Mockito.anyListOf(String.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="existingKeyspaceName")
    public void should_refresh_schema_and_token_map_if_schema_metadata_reenabled(String keyspace) throws Exception {
        try {
            this.schemaDisabledCluster.getConfiguration().getQueryOptions().setMetadataEnabled(true);
            ((ControlConnection)Mockito.verify((Object)this.schemaDisabledControlConnection, (VerificationMode)Mockito.after((int)1000))).refreshSchema(null, null, null, null);
            Assertions.assertThat(this.schemaDisabledCluster.getMetadata().getKeyspace(keyspace)).isNotNull();
            Token token1 = this.schemaDisabledCluster.getMetadata().newToken("0");
            Token token2 = this.schemaDisabledCluster.getMetadata().newToken("111111");
            Assertions.assertThat((Comparable)token1).isNotNull();
            Assertions.assertThat((Comparable)token2).isNotNull();
            Assertions.assertThat(this.schemaDisabledCluster.getMetadata().newTokenRange(token1, token2)).isNotNull();
            ((AbstractIterableAssert)Assertions.assertThat((Iterable)this.schemaDisabledCluster.getMetadata().getTokenRanges()).isNotNull()).isNotEmpty();
            Mockito.reset((Object[])new ControlConnection[]{this.schemaDisabledControlConnection});
            this.schemaDisabledCluster.getConfiguration().getQueryOptions().setMetadataEnabled(true);
            ((ControlConnection)Mockito.verify((Object)this.schemaDisabledControlConnection, (VerificationMode)Mockito.after((int)1000).never())).refreshSchema(null, null, null, null);
        }
        catch (Throwable throwable) {
            Mockito.reset((Object[])new SchemaChangeListener[]{this.schemaDisabledListener});
            this.schemaDisabledCluster.getConfiguration().getQueryOptions().setMetadataEnabled(false);
            throw throwable;
        }
        Mockito.reset((Object[])new SchemaChangeListener[]{this.schemaDisabledListener});
        this.schemaDisabledCluster.getConfiguration().getQueryOptions().setMetadataEnabled(false);
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void cleanup() throws InterruptedException {
        if (this.session1 != null) {
            ListenableFuture f = Futures.successfulAsList((Iterable)Lists.newArrayList((Object[])new ResultSetFuture[]{this.session1.executeAsync("DROP TABLE lowercase.table1"), this.session1.executeAsync("DROP TABLE \"CaseSensitive\".table1"), this.session1.executeAsync("DROP TYPE lowercase.type1"), this.session1.executeAsync("DROP TYPE \"CaseSensitive\".type1"), this.session1.executeAsync("DROP FUNCTION lowercase.\"ID\""), this.session1.executeAsync("DROP FUNCTION \"CaseSensitive\".\"ID\""), this.session1.executeAsync("DROP FUNCTION lowercase.\"PLUS\""), this.session1.executeAsync("DROP FUNCTION \"CaseSensitive\".\"PLUS\""), this.session1.executeAsync("DROP AGGREGATE lowercase.\"SUM\""), this.session1.executeAsync("DROP AGGREGATE \"CaseSensitive\".\"SUM\""), this.session1.executeAsync("DROP MATERIALIZED VIEW lowercase.mv1"), this.session1.executeAsync("DROP MATERIALIZED VIEW \"CaseSensitive\".mv1"), this.session1.executeAsync("DROP KEYSPACE lowercase2"), this.session1.executeAsync("DROP KEYSPACE \"CaseSensitive2\"")}));
            Futures.getUnchecked((Future)f);
        }
    }

    private void execute(String cql, String keyspace) throws InterruptedException {
        this.session1.execute(String.format(cql, keyspace));
    }

    private List<Metadata> metadatas() {
        return Lists.newArrayList((Object[])new Metadata[]{this.cluster1.getMetadata(), this.cluster2.getMetadata()});
    }
}

