/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.policies.DelegatingLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

@CCMConfig(numberOfNodes={2}, dirtiesContext={true}, createCluster={false})
public class SchemaChangesCCTest
extends CCMTestsSupport {
    private static final int NOTIF_TIMEOUT_MS = 5000;

    @Test(groups={"long"})
    public void should_receive_changes_made_while_control_connection_is_down_on_reconnect() throws Exception {
        ToggleablePolicy lbPolicy = new ToggleablePolicy(Policies.defaultLoadBalancingPolicy());
        Cluster cluster = this.register(Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)lbPolicy).addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).build());
        Cluster cluster2 = this.register(Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)lbPolicy).addContactPoints(new InetAddress[]{this.getContactPoints().get(1)}).withPort(this.ccm().getBinaryPort()).build());
        SchemaChangeListener listener = (SchemaChangeListener)Mockito.mock(SchemaChangeListener.class);
        cluster.init();
        cluster.register(listener);
        Session session2 = cluster2.connect();
        session2.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "ks1", 1));
        session2.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "ks2", 1));
        session2.execute("create table ks1.tbl1 (k text primary key, v text)");
        session2.execute("create table ks1.tbl2 (k text primary key, v text)");
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(2))).onKeyspaceAdded((KeyspaceMetadata)Matchers.any(KeyspaceMetadata.class));
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(2))).onTableAdded((TableMetadata)Matchers.any(TableMetadata.class));
        KeyspaceMetadata prealteredKeyspace = cluster.getMetadata().getKeyspace("ks1");
        KeyspaceMetadata predroppedKeyspace = cluster.getMetadata().getKeyspace("ks2");
        TableMetadata prealteredTable = cluster.getMetadata().getKeyspace("ks1").getTable("tbl1");
        TableMetadata predroppedTable = cluster.getMetadata().getKeyspace("ks1").getTable("tbl2");
        lbPolicy.returnEmptyQueryPlan = true;
        this.ccm().stop(1);
        Assertions.assertThat(cluster).host(1).goesDownWithin(20L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)cluster.manager.controlConnection.isOpen()).isFalse();
        session2.execute("drop keyspace ks2");
        session2.execute("drop table ks1.tbl2");
        session2.execute("alter keyspace ks1 with durable_writes=false");
        session2.execute("alter table ks1.tbl1 add new_col varchar");
        session2.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "ks3", 1));
        session2.execute("create table ks1.tbl3 (k text primary key, v text)");
        Mockito.reset((Object[])new SchemaChangeListener[]{listener});
        lbPolicy.returnEmptyQueryPlan = false;
        long maxControlConnectionWait = 60000L;
        long startTime = System.currentTimeMillis();
        while (!cluster.manager.controlConnection.isOpen() && System.currentTimeMillis() - startTime < maxControlConnectionWait) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)cluster.manager.controlConnection.isOpen()).as("Control connection was not opened after %dms.", new Object[]{maxControlConnectionWait})).isTrue();
        ArgumentCaptor removedKeyspace = ArgumentCaptor.forClass(KeyspaceMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(1))).onKeyspaceRemoved((KeyspaceMetadata)removedKeyspace.capture());
        Assertions.assertThat((KeyspaceMetadata)removedKeyspace.getValue()).hasName("ks2").isEqualTo(predroppedKeyspace);
        ArgumentCaptor droppedTable = ArgumentCaptor.forClass(TableMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(1))).onTableRemoved((TableMetadata)droppedTable.capture());
        Assertions.assertThat((TableMetadata)droppedTable.getValue()).isInKeyspace("ks1").hasName("tbl2").isEqualTo(predroppedTable);
        ArgumentCaptor alteredKeyspace = ArgumentCaptor.forClass(KeyspaceMetadata.class);
        ArgumentCaptor originalKeyspace = ArgumentCaptor.forClass(KeyspaceMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(1))).onKeyspaceChanged((KeyspaceMetadata)alteredKeyspace.capture(), (KeyspaceMetadata)originalKeyspace.capture());
        Assertions.assertThat((KeyspaceMetadata)originalKeyspace.getValue()).hasName("ks1").isDurableWrites().isEqualTo(prealteredKeyspace);
        Assertions.assertThat((KeyspaceMetadata)alteredKeyspace.getValue()).hasName("ks1").isNotDurableWrites();
        ArgumentCaptor alteredTable = ArgumentCaptor.forClass(TableMetadata.class);
        ArgumentCaptor originalTable = ArgumentCaptor.forClass(TableMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(1))).onTableChanged((TableMetadata)alteredTable.capture(), (TableMetadata)originalTable.capture());
        Assertions.assertThat((TableMetadata)originalTable.getValue()).isInKeyspace("ks1").hasName("tbl1").doesNotHaveColumn("new_col").isEqualTo(prealteredTable);
        Assertions.assertThat((TableMetadata)alteredTable.getValue()).isInKeyspace("ks1").hasName("tbl1").hasColumn("new_col", DataType.varchar());
        ArgumentCaptor addedKeyspace = ArgumentCaptor.forClass(KeyspaceMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(1))).onKeyspaceAdded((KeyspaceMetadata)addedKeyspace.capture());
        Assertions.assertThat((KeyspaceMetadata)addedKeyspace.getValue()).hasName("ks3");
        ArgumentCaptor addedTable = ArgumentCaptor.forClass(TableMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L).times(1))).onTableAdded((TableMetadata)addedTable.capture());
        Assertions.assertThat((TableMetadata)addedTable.getValue()).isInKeyspace("ks1").hasName("tbl3");
    }

    public static class ToggleablePolicy
    extends DelegatingLoadBalancingPolicy {
        volatile boolean returnEmptyQueryPlan;

        public ToggleablePolicy(LoadBalancingPolicy delegate) {
            super(delegate);
        }

        @Override
        public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
            if (this.returnEmptyQueryPlan && statement == Statement.DEFAULT) {
                return Collections.emptyList().iterator();
            }
            return super.newQueryPlan(loggedKeyspace, statement);
        }
    }
}

