/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.utils.UUIDs;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CCMConfig(numberOfNodes={2})
public class SchemaAgreementTest
extends CCMTestsSupport {
    static final String CREATE_TABLE = "CREATE TABLE table_%s (k int primary key, v int)";
    static final AtomicInteger COUNTER = new AtomicInteger(1);

    @Test(groups={"short"})
    public void should_set_flag_on_successful_agreement() {
        ProtocolOptions protocolOptions = this.cluster().getConfiguration().getProtocolOptions();
        protocolOptions.maxSchemaAgreementWaitSeconds = 10;
        ResultSet rs = this.session().execute(String.format(CREATE_TABLE, COUNTER.getAndIncrement()));
        Assertions.assertThat((boolean)rs.getExecutionInfo().isSchemaInAgreement()).isTrue();
    }

    @Test(groups={"short"})
    public void should_set_flag_on_non_schema_altering_statement() {
        ProtocolOptions protocolOptions = this.cluster().getConfiguration().getProtocolOptions();
        protocolOptions.maxSchemaAgreementWaitSeconds = 10;
        ResultSet rs = this.session().execute("select release_version from system.local");
        Assertions.assertThat((boolean)rs.getExecutionInfo().isSchemaInAgreement()).isTrue();
    }

    @Test(groups={"short"})
    public void should_unset_flag_on_failed_agreement() {
        ProtocolOptions protocolOptions = this.cluster().getConfiguration().getProtocolOptions();
        protocolOptions.maxSchemaAgreementWaitSeconds = 0;
        ResultSet rs = this.session().execute(String.format(CREATE_TABLE, COUNTER.getAndIncrement()));
        Assertions.assertThat((boolean)rs.getExecutionInfo().isSchemaInAgreement()).isFalse();
    }

    @Test(groups={"short"})
    public void should_check_agreement_through_cluster_metadata() {
        Cluster controlCluster = this.register(TestUtils.buildControlCluster(this.cluster(), this.ccm()));
        Session controlSession = controlCluster.connect();
        Row localRow = controlSession.execute("SELECT schema_version FROM system.local").one();
        UUID localVersion = localRow.getUUID("schema_version");
        Row peerRow = controlSession.execute("SELECT peer, schema_version FROM system.peers").one();
        InetAddress peerAddress = peerRow.getInet("peer");
        UUID peerVersion = peerRow.getUUID("schema_version");
        Assertions.assertThat((Comparable)localVersion).isEqualTo((Object)peerVersion);
        Assertions.assertThat((boolean)this.cluster().getMetadata().checkSchemaAgreement()).isTrue();
        SchemaAgreementTest.forceSchemaVersion(controlSession, peerAddress, UUIDs.random());
        Assertions.assertThat((boolean)this.cluster().getMetadata().checkSchemaAgreement()).isFalse();
        SchemaAgreementTest.forceSchemaVersion(controlSession, peerAddress, peerVersion);
    }

    private static void forceSchemaVersion(Session session, InetAddress peerAddress, UUID schemaVersion) {
        session.execute(String.format("UPDATE system.peers SET schema_version = %s WHERE peer = %s", TypeCodec.uuid().format((Object)schemaVersion), TypeCodec.inet().format((Object)peerAddress)));
    }
}

