/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.assertj.core.api.Assertions;
import org.scassandra.Scassandra;
import org.scassandra.http.client.ActivityClient;
import org.scassandra.http.client.CurrentClient;
import org.scassandra.http.client.PrimingClient;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class ScassandraTestBase {
    protected Scassandra scassandra;
    protected InetSocketAddress hostAddress;
    protected PrimingClient primingClient;
    protected ActivityClient activityClient;
    protected CurrentClient currentClient;
    protected static String ip = TestUtils.ipOfNode(1);

    @BeforeClass(groups={"short", "long"})
    public void beforeTestClass() {
        this.scassandra = TestUtils.createScassandraServer();
        this.scassandra.start();
        this.primingClient = this.scassandra.primingClient();
        this.activityClient = this.scassandra.activityClient();
        this.currentClient = this.scassandra.currentClient();
        this.hostAddress = new InetSocketAddress(ip, this.scassandra.getBinaryPort());
    }

    @AfterClass(groups={"short", "long"})
    public void afterTestClass() {
        if (this.scassandra != null) {
            this.scassandra.stop();
        }
    }

    @BeforeMethod(groups={"short", "long"})
    @AfterMethod(groups={"short", "long"})
    public void resetClients() {
        this.activityClient.clearAllRecordedActivity();
        this.primingClient.clearAllPrimes();
        this.currentClient.enableListener();
    }

    protected Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withPort(this.scassandra.getBinaryPort()).addContactPoints(new InetAddress[]{this.hostAddress.getAddress()}).withPort(this.scassandra.getBinaryPort()).withPoolingOptions(new PoolingOptions().setCoreConnectionsPerHost(HostDistance.LOCAL, 1).setMaxConnectionsPerHost(HostDistance.LOCAL, 1).setHeartbeatIntervalSeconds(0));
    }

    protected Host retrieveSingleHost(Cluster cluster) {
        Host host = cluster.getMetadata().getHost(this.hostAddress);
        if (host == null) {
            Assertions.fail((String)"Unable to retrieve host");
        }
        return host;
    }

    public static abstract class PerClassCluster
    extends ScassandraTestBase {
        protected Cluster cluster;
        protected Session session;
        protected Host host;

        @Override
        @BeforeClass(groups={"short", "long"})
        public void beforeTestClass() {
            super.beforeTestClass();
            Cluster.Builder builder = this.createClusterBuilder();
            this.cluster = builder.build();
            this.host = this.retrieveSingleHost(this.cluster);
            this.session = this.cluster.connect();
        }

        @Override
        @AfterClass(groups={"short", "long"})
        public void afterTestClass() {
            if (this.cluster != null) {
                this.cluster.close();
            }
            super.afterTestClass();
        }
    }
}

