/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.SSLTestBase;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(auth={false})
public class SSLEncryptionTest
extends SSLTestBase {
    @Test(groups={"short"}, dataProvider="sslImplementation", dataProviderClass=SSLTestBase.class)
    public void should_connect_with_ssl_without_client_auth_and_node_doesnt_require_auth(SSLTestBase.SslImplementation sslImplementation) throws Exception {
        this.connectWithSSLOptions(this.getSSLOptions(sslImplementation, false, true));
    }

    @Test(groups={"short"}, dataProvider="sslImplementation", dataProviderClass=SSLTestBase.class, expectedExceptions={NoHostAvailableException.class})
    public void should_not_connect_with_ssl_without_trusting_server_cert(SSLTestBase.SslImplementation sslImplementation) throws Exception {
        this.connectWithSSLOptions(this.getSSLOptions(sslImplementation, false, false));
    }

    @Test(groups={"short"}, expectedExceptions={NoHostAvailableException.class})
    public void should_not_connect_without_ssl_but_node_uses_ssl() throws Exception {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).build());
        cluster.connect();
    }

    @CCMConfig(dirtiesContext={true})
    @Test(groups={"long"}, dataProvider="sslImplementation", dataProviderClass=SSLTestBase.class)
    public void should_reconnect_with_ssl_on_node_up(SSLTestBase.SslImplementation sslImplementation) throws Exception {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withSSL(this.getSSLOptions(sslImplementation, true, true)).build());
        cluster.connect();
        this.ccm().stop(1);
        this.ccm().start(1);
        Assertions.assertThat(cluster).host(1).comesUpWithin(TestUtils.TEST_BASE_NODE_WAIT, TimeUnit.SECONDS);
    }

    @Test(groups={"isolated"})
    public void should_use_system_properties_with_default_ssl_options() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", CCMBridge.DEFAULT_CLIENT_TRUSTSTORE_FILE.getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStorePassword", "cassandra1sfun");
        try {
            this.connectWithSSL();
        }
        finally {
            try {
                System.clearProperty("javax.net.ssl.trustStore");
                System.clearProperty("javax.net.ssl.trustStorePassword");
            }
            catch (SecurityException securityException) {}
        }
    }
}

