/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.data.Index;

public class ResultSetAssert
extends AbstractListAssert<ResultSetAssert, List<Row>, Row> {
    private final TupleListAssert helper;
    private static final Function<Row, Tuple> ROW_TO_TUPLE = new Function<Row, Tuple>(){

        public Tuple apply(Row input) {
            Object[] cols = new Object[input.getColumnDefinitions().size()];
            for (int i = 0; i < input.getColumnDefinitions().size(); ++i) {
                cols[i] = input.getObject(i);
            }
            return new Tuple(cols);
        }
    };

    public ResultSetAssert(ResultSet actual) {
        super(actual.all(), ResultSetAssert.class);
        this.helper = new TupleListAssert(Lists.transform((List)((List)this.actual), ROW_TO_TUPLE));
    }

    public static Tuple row(Object ... cols) {
        return new Tuple(cols);
    }

    public ResultSetAssert contains(Tuple value, Index index) {
        this.helper.contains(value, index);
        return this;
    }

    public ResultSetAssert containsSubsequence(Tuple ... sequence) {
        this.helper.containsSubsequence(sequence);
        return this;
    }

    public ResultSetAssert containsOnly(Tuple ... values) {
        this.helper.containsOnly(values);
        return this;
    }

    public ResultSetAssert endsWith(Tuple ... sequence) {
        this.helper.endsWith(sequence);
        return this;
    }

    public ResultSetAssert startsWith(Tuple ... sequence) {
        this.helper.startsWith(sequence);
        return this;
    }

    public ResultSetAssert doesNotContain(Tuple value, Index index) {
        this.helper.doesNotContain(value, index);
        return this;
    }

    public ResultSetAssert doesNotContain(Tuple ... values) {
        this.helper.doesNotContain(values);
        return this;
    }

    public ResultSetAssert containsExactly(Tuple ... values) {
        this.helper.containsExactly(values);
        return this;
    }

    public ResultSetAssert containsOnlyOnce(Tuple ... values) {
        this.helper.containsOnlyOnce(values);
        return this;
    }

    public ResultSetAssert contains(Tuple ... values) {
        this.helper.contains(values);
        return this;
    }

    public ResultSetAssert containsSequence(Tuple ... sequence) {
        this.helper.containsSequence(sequence);
        return this;
    }

    private static class TupleListAssert
    extends AbstractListAssert<TupleListAssert, List<Tuple>, Tuple> {
        private TupleListAssert(List<Tuple> rows) {
            super(rows, TupleListAssert.class);
        }
    }

    public static class Tuple {
        final Object[] cols;

        public Tuple(Object ... cols) {
            this.cols = cols;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)o;
            return Arrays.equals(this.cols, tuple.cols);
        }

        public int hashCode() {
            return Arrays.hashCode(this.cols);
        }

        public String toString() {
            return '(' + Joiner.on((char)',').join(this.cols) + ')';
        }
    }
}

