/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.TestUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.scassandra.Scassandra;
import org.scassandra.http.client.PrimingRequest;
import org.testng.annotations.Test;

public class RequestHandlerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"long"})
    public void should_handle_race_between_response_and_cancellation() {
        Scassandra scassandra = TestUtils.createScassandraServer();
        Cluster cluster = null;
        try {
            scassandra.start();
            List<ImmutableMap> rows = Collections.singletonList(ImmutableMap.of((Object)"key", (Object)1));
            scassandra.primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(rows).withFixedDelay(Long.valueOf(10L))).build());
            cluster = Cluster.builder().addContactPoint(TestUtils.ipOfNode(1)).withPort(scassandra.getBinaryPort()).withPoolingOptions(new PoolingOptions().setCoreConnectionsPerHost(HostDistance.LOCAL, 1).setMaxConnectionsPerHost(HostDistance.LOCAL, 1).setHeartbeatIntervalSeconds(0)).build();
            Session session = cluster.connect();
            int samples = 100;
            long start = System.currentTimeMillis();
            for (int i = 0; i < samples; ++i) {
                session.execute("mock query");
            }
            long elapsed = System.currentTimeMillis() - start;
            long queryDuration = elapsed / (long)samples;
            for (int i = 0; i < 2000; ++i) {
                ResultSetFuture future = session.executeAsync("mock query");
                try {
                    future.getUninterruptibly(queryDuration, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (TimeoutException e) {
                    future.cancel(true);
                }
            }
            Connection connection = this.getSingleConnection(session);
            Assertions.assertThat((int)connection.inFlight.get()).isEqualTo(0);
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
            scassandra.stop();
        }
    }

    private Connection getSingleConnection(Session session) {
        HostConnectionPool pool = (HostConnectionPool)((SessionManager)session).pools.values().iterator().next();
        return (Connection)pool.connections.get(0);
    }
}

