/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.ReconnectionPolicyInfoFinder;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.testng.annotations.Test;

public class ReconnectionPolicyInfoFinderTest {
    @Test(groups={"unit"})
    public void should_find_an_info_about_constant_reconnection_policy() {
        ConstantReconnectionPolicy constantReconnectionPolicy = new ConstantReconnectionPolicy(10L);
        InsightsSchema.ReconnectionPolicyInfo reconnectionPolicyInfo = new ReconnectionPolicyInfoFinder().getReconnectionPolicyInfo((ReconnectionPolicy)constantReconnectionPolicy);
        Assertions.assertThat((Map)reconnectionPolicyInfo.getOptions()).contains(new MapEntry[]{MapEntry.entry((Object)"delayMs", (Object)10L)});
        Assertions.assertThat((String)reconnectionPolicyInfo.getType()).isEqualTo((Object)"ConstantReconnectionPolicy");
    }

    @Test(groups={"unit"})
    public void should_find_an_info_about_exponential_reconnection_policy() {
        ExponentialReconnectionPolicy exponentialReconnectionPolicy = new ExponentialReconnectionPolicy(100L, 500L);
        InsightsSchema.ReconnectionPolicyInfo reconnectionPolicyInfo = new ReconnectionPolicyInfoFinder().getReconnectionPolicyInfo((ReconnectionPolicy)exponentialReconnectionPolicy);
        Assertions.assertThat((Map)reconnectionPolicyInfo.getOptions()).contains(new MapEntry[]{MapEntry.entry((Object)"baseDelayMs", (Object)100L), MapEntry.entry((Object)"maxDelayMs", (Object)500L)});
        Assertions.assertThat(reconnectionPolicyInfo.getOptions().get("maxAttempts")).isNotNull();
        Assertions.assertThat((String)reconnectionPolicyInfo.getType()).isEqualTo((Object)"ExponentialReconnectionPolicy");
    }
}

