/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ScassandraTestBase;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import org.scassandra.http.client.PrimingRequest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReadTimeoutTest
extends ScassandraTestBase.PerClassCluster {
    String query = "SELECT foo FROM bar";

    @BeforeMethod(groups={"short"})
    public void setup() {
        this.primingClient.prime(PrimingRequest.queryBuilder().withQuery(this.query).withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(100L))).build());
        this.cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(10);
    }

    @Test(groups={"short"}, expectedExceptions={OperationTimedOutException.class})
    public void should_use_default_timeout_if_not_overridden_by_statement() {
        this.session.execute(this.query);
    }

    @Test(groups={"short"})
    public void should_use_statement_timeout_if_overridden() {
        Statement statement = new SimpleStatement(this.query).setReadTimeoutMillis(10000);
        this.session.execute(statement);
    }

    @Test(groups={"short"})
    public void should_disable_timeout_if_set_to_zero_at_statement_level() {
        Statement statement = new SimpleStatement(this.query).setReadTimeoutMillis(0);
        this.session.execute(statement);
    }
}

