/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Maps;
import org.testng.Assert;

public class QueryTracker {
    public static final String QUERY = "select * from test.foo";
    Map<InetAddress, Integer> coordinators = Maps.newConcurrentHashMap();

    public void query(Session session, int times) {
        this.query(session, times, ConsistencyLevel.ONE);
    }

    public void query(Session session, int times, ConsistencyLevel cl) {
        this.query(session, times, cl, null);
    }

    public void query(Session session, int times, InetSocketAddress expectedHost) {
        this.query(session, times, (Statement)new SimpleStatement(QUERY), null, expectedHost);
    }

    public void query(Session session, int times, Class<? extends Exception> expectedException, InetSocketAddress expectedHost) {
        this.query(session, times, (Statement)new SimpleStatement(QUERY), expectedException, expectedHost);
    }

    public void query(Session session, int times, ConsistencyLevel cl, Class<? extends Exception> expectedException) {
        SimpleStatement statement = new SimpleStatement(QUERY);
        if (cl != null) {
            statement.setConsistencyLevel(cl);
        }
        this.query(session, times, (Statement)statement, expectedException, null);
    }

    public void query(Session session, int times, Statement statement) {
        this.query(session, times, statement, null, null);
    }

    public void query(Session session, int times, Statement statement, Class<? extends Exception> expectedException, InetSocketAddress expectedHost) {
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < times; ++i) {
            futures.add(session.executeAsync(statement));
        }
        try {
            for (ListenableFuture future : futures) {
                try {
                    ResultSet result = (ResultSet)Uninterruptibles.getUninterruptibly((Future)future, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                    InetSocketAddress address = result.getExecutionInfo().getQueriedHost().getSocketAddress();
                    InetAddress coordinator = address.getAddress();
                    Integer n = this.coordinators.get(coordinator);
                    this.coordinators.put(coordinator, n == null ? 1 : n + 1);
                    if (expectedHost == null) continue;
                    Assertions.assertThat((Object)address).isEqualTo((Object)expectedHost);
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    if (expectedException == null) {
                        Assert.fail((String)"Query fail", (Throwable)ex);
                    } else {
                        Assertions.assertThat((Throwable)cause).isInstanceOf(expectedException);
                    }
                    if (!(cause instanceof CoordinatorException)) continue;
                    Assertions.assertThat((Object)((CoordinatorException)cause).getAddress()).isEqualTo((Object)expectedHost);
                }
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Queries failed", (Throwable)e);
        }
    }

    public int queryCount(ScassandraCluster sCluster, int dc, int node) {
        try {
            InetSocketAddress host = sCluster.address(dc, node);
            Integer queried = this.coordinators.get(host.getAddress());
            return queried != null ? queried : 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assertQueried(ScassandraCluster sCluster, int dc, int node, int n) {
        int queryCount = this.queryCount(sCluster, dc, node);
        ((AbstractIntegerAssert)Assertions.assertThat((int)queryCount).as("Expected node %d:%d to be queried %d times but was %d", new Object[]{dc, node, n, queryCount})).isEqualTo(n);
    }

    public void reset() {
        this.coordinators.clear();
    }
}

