/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.utils.CassandraVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class QueryTimestampTest
extends CCMTestsSupport {
    private volatile long timestampFromGenerator;

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE foo (k int PRIMARY KEY, v int)");
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        Cluster.Builder builder = Cluster.builder().withTimestampGenerator(new TimestampGenerator(){

            public long next() {
                return QueryTimestampTest.this.timestampFromGenerator;
            }
        }).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        return builder;
    }

    @BeforeMethod(groups={"short"})
    public void cleanData() {
        this.session().execute("TRUNCATE foo");
    }

    @Test(groups={"short"})
    public void should_use_CQL_timestamp_over_anything_else() {
        this.timestampFromGenerator = 10L;
        String query = "INSERT INTO foo (k, v) VALUES (1, 1) USING TIMESTAMP 20";
        this.session().execute(new SimpleStatement(query).setDefaultTimestamp(30L));
        long writeTime = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        Assert.assertEquals((long)writeTime, (long)20L);
    }

    @Test(groups={"short"})
    public void should_use_statement_timestamp_over_generator() {
        this.timestampFromGenerator = 10L;
        String query = "INSERT INTO foo (k, v) VALUES (1, 1)";
        this.session().execute(new SimpleStatement(query).setDefaultTimestamp(30L));
        long writeTime = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        Assert.assertEquals((long)writeTime, (long)30L);
    }

    @Test(groups={"short"})
    public void should_use_generator_timestamp_if_none_other_specified() {
        this.timestampFromGenerator = 10L;
        String query = "INSERT INTO foo (k, v) VALUES (1, 1)";
        this.session().execute(query);
        long writeTime = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        Assert.assertEquals((long)writeTime, (long)10L);
    }

    @Test(groups={"short"})
    public void should_use_server_side_timestamp_if_none_specified() {
        this.timestampFromGenerator = Long.MIN_VALUE;
        long clientTime = System.currentTimeMillis() * 1000L;
        String query = "INSERT INTO foo (k, v) VALUES (1, 1)";
        this.session().execute(query);
        long writeTime = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        Assert.assertTrue((writeTime >= clientTime ? 1 : 0) != 0);
    }

    @Test(groups={"short"})
    public void should_apply_statement_timestamp_only_to_batched_queries_without_timestamp() {
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement("INSERT INTO foo (k, v) VALUES (1, 1)"));
        batch.add((Statement)new SimpleStatement("INSERT INTO foo (k, v) VALUES (2, 1) USING TIMESTAMP 20"));
        batch.setDefaultTimestamp(10L);
        this.session().execute((Statement)batch);
        long writeTime1 = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        long writeTime2 = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 2").one().getLong(0);
        Assert.assertEquals((long)writeTime1, (long)10L);
        Assert.assertEquals((long)writeTime2, (long)20L);
    }

    @Test(groups={"short"})
    public void should_apply_generator_timestamp_only_to_batched_queries_without_timestamp() {
        this.timestampFromGenerator = 10L;
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement("INSERT INTO foo (k, v) VALUES (1, 1)"));
        batch.add((Statement)new SimpleStatement("INSERT INTO foo (k, v) VALUES (2, 1) USING TIMESTAMP 20"));
        this.session().execute((Statement)batch);
        long writeTime1 = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        long writeTime2 = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 2").one().getLong(0);
        Assert.assertEquals((long)writeTime1, (long)10L);
        Assert.assertEquals((long)writeTime2, (long)20L);
    }

    @Test(groups={"short"})
    public void should_apply_server_side_timestamp_only_to_batched_queries_without_timestamp() {
        this.timestampFromGenerator = Long.MIN_VALUE;
        long clientTime = System.currentTimeMillis() * 1000L;
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement("INSERT INTO foo (k, v) VALUES (1, 1)"));
        batch.add((Statement)new SimpleStatement("INSERT INTO foo (k, v) VALUES (2, 1) USING TIMESTAMP 20"));
        this.session().execute((Statement)batch);
        long writeTime1 = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        long writeTime2 = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 2").one().getLong(0);
        Assert.assertTrue((writeTime1 >= clientTime ? 1 : 0) != 0);
        Assert.assertEquals((long)writeTime2, (long)20L);
    }

    @Test(groups={"short"})
    public void should_preserve_timestamp_when_retrying() {
        SimpleStatement statement = new SimpleStatement("INSERT INTO foo (k, v) VALUES (1, 1)");
        statement.setDefaultTimestamp(10L);
        statement.setConsistencyLevel(ConsistencyLevel.TWO);
        this.session().execute((Statement)statement);
        Metrics.Errors metrics = this.session().getCluster().getMetrics().getErrorMetrics();
        Assert.assertEquals((long)metrics.getRetriesOnUnavailable().getCount(), (long)1L);
        long writeTime = this.session().execute("SELECT writeTime(v) FROM foo WHERE k = 1").one().getLong(0);
        Assert.assertEquals((long)writeTime, (long)10L);
    }
}

