/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SortingLoadBalancingPolicy;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.scassandra.http.client.PreparedStatementPreparation;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class QueryOptionsTest {
    ScassandraCluster scassandra;
    QueryOptions queryOptions;
    SortingLoadBalancingPolicy loadBalancingPolicy;
    Cluster cluster = null;
    Session session = null;
    Host host1;
    Host host2;
    Host host3;

    @BeforeMethod(groups={"short"})
    public void beforeMethod() {
        this.scassandra = ScassandraCluster.builder().withNodes(3).build();
        this.scassandra.init();
        this.queryOptions = new QueryOptions();
        this.loadBalancingPolicy = new SortingLoadBalancingPolicy();
        this.cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandra.address(2).getAddress()}).withPort(this.scassandra.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)this.loadBalancingPolicy).withQueryOptions(this.queryOptions).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        this.session = this.cluster.connect();
        this.host1 = TestUtils.findHost(this.cluster, 1);
        this.host2 = TestUtils.findHost(this.cluster, 2);
        this.host3 = TestUtils.findHost(this.cluster, 3);
        Iterator iterator = Lists.newArrayList((Object[])new Integer[]{1, 2, 3}).iterator();
        while (iterator.hasNext()) {
            int host = (Integer)iterator.next();
            Assertions.assertThat((List)this.scassandra.node(host).activityClient().retrievePreparedStatementPreparations()).hasSize(0);
            this.scassandra.node(host).activityClient().clearAllRecordedActivity();
        }
    }

    public void validatePrepared(boolean expectAll) {
        String query = "select sansa_stark from the_known_world";
        PreparedStatement statement = this.session.prepare(query);
        Assertions.assertThat((Map)this.cluster.manager.preparedQueries).containsValue((Object)statement);
        List preparationOne = this.scassandra.node(1).activityClient().retrievePreparedStatementPreparations();
        List preparationTwo = this.scassandra.node(2).activityClient().retrievePreparedStatementPreparations();
        List preparationThree = this.scassandra.node(3).activityClient().retrievePreparedStatementPreparations();
        Assertions.assertThat((List)preparationOne).hasSize(1);
        Assertions.assertThat((String)((PreparedStatementPreparation)preparationOne.get(0)).getPreparedStatementText()).isEqualTo((Object)query);
        if (expectAll) {
            Assertions.assertThat((List)preparationTwo).hasSize(1);
            Assertions.assertThat((String)((PreparedStatementPreparation)preparationTwo.get(0)).getPreparedStatementText()).isEqualTo((Object)query);
            Assertions.assertThat((List)preparationThree).hasSize(1);
            Assertions.assertThat((String)((PreparedStatementPreparation)preparationThree.get(0)).getPreparedStatementText()).isEqualTo((Object)query);
        } else {
            Assertions.assertThat((List)preparationTwo).isEmpty();
            Assertions.assertThat((List)preparationThree).isEmpty();
        }
    }

    @Test(groups={"short"})
    public void should_prepare_once_when_prepare_on_all_hosts_false() {
        this.queryOptions.setPrepareOnAllHosts(false);
        this.validatePrepared(false);
    }

    @Test(groups={"short"})
    public void should_prepare_everywhere_when_prepare_on_all_hosts_true() {
        this.queryOptions.setPrepareOnAllHosts(true);
        this.validatePrepared(true);
    }

    @Test(groups={"short"})
    public void should_prepare_everywhere_when_not_configured() {
        this.validatePrepared(true);
    }

    private void valideReprepareOnUp(boolean expectReprepare) {
        String query = "select sansa_stark from the_known_world";
        int maxTries = 3;
        for (int i = 1; i <= maxTries; ++i) {
            this.session.prepare(query);
            List preparationOne = this.scassandra.node(1).activityClient().retrievePreparedStatementPreparations();
            Assertions.assertThat((List)preparationOne).hasSize(1);
            Assertions.assertThat((String)((PreparedStatementPreparation)preparationOne.get(0)).getPreparedStatementText()).isEqualTo((Object)query);
            this.scassandra.node(1).activityClient().clearAllRecordedActivity();
            this.scassandra.node(1).stop();
            Assertions.assertThat(this.cluster).host(1).goesDownWithin(10L, TimeUnit.SECONDS);
            this.scassandra.node(1).start();
            Assertions.assertThat(this.cluster).host(1).comesUpWithin(60L, TimeUnit.SECONDS);
            preparationOne = this.scassandra.node(1).activityClient().retrievePreparedStatementPreparations();
            if (expectReprepare) {
                try {
                    Assertions.assertThat((List)preparationOne).hasSize(1);
                    Assertions.assertThat((String)((PreparedStatementPreparation)preparationOne.get(0)).getPreparedStatementText()).isEqualTo((Object)query);
                    break;
                }
                catch (AssertionError e) {
                    if (i == maxTries) {
                        throw e;
                    }
                    this.scassandra.node(1).activityClient().clearAllRecordedActivity();
                    continue;
                }
            }
            Assertions.assertThat((List)preparationOne).isEmpty();
            break;
        }
    }

    @Test(groups={"short"})
    public void should_reprepare_on_up_when_enabled() {
        this.queryOptions.setReprepareOnUp(true);
        this.valideReprepareOnUp(true);
    }

    @Test(groups={"short"})
    public void should_reprepare_on_up_by_default() {
        this.valideReprepareOnUp(true);
    }

    @Test(groups={"short"})
    public void should_not_reprepare_on_up_when_disabled() {
        this.queryOptions.setReprepareOnUp(false);
        this.valideReprepareOnUp(false);
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void afterMethod() {
        if (this.cluster != null) {
            this.cluster.close();
        }
        if (this.scassandra != null) {
            this.scassandra.stop();
        }
    }
}

